<?php
    $img_html = '';
     if( has_post_thumbnail() ) {
        $thumb = wp_get_attachment_image( get_post_thumbnail_id( get_the_ID() ), "large");
        $img = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'large' );
        $img = !empty($img) ? $img[0] : '';
        $img_html ="<div class='hotel-room-thumb' data-bg-image='".$img."'><div class='entry-hover'></div></div>";
    }
   $result = $rate = $stars = '';
    for( $i=0; $i < 5; $i++) {
      $color_class = '';
      if( $i < (int)Themeton_Std::getmeta('star') ) { $color_class = 'color-yellow'; }
        $stars .= "<span class='fa fa-star $color_class'></span>";
    }

    $rate = "<div class='rate uk-scrollspy'>
                $stars
              </div>";

    $value = Themeton_Std::getmeta_type_list('meta_option_name'); // return array     

    if(!empty($value)){
        foreach ($value as $item  ) {
            
            $result .= '<li>'.'<span>'.$item['label'].'</span>'.'&nbsp'.$item['content'];
        }
    }
    if(has_excerpt()) {
        $excerpt = get_the_excerpt();
    } else {
        $excerpt = Themeton_Tpl::clear_urls( wp_trim_words( wp_strip_all_tags(strip_shortcodes(get_the_content())), 15));
    }

?>
<div class="uk-grid uk-margin-medium">
    <div class="uk-width-1-2@m uk-width-1-2@l">
        <?php printf($img_html); ?>
    </div>
    <div class="uk-width-1-2@m uk-grid uk-width-1-2@l uk-padding pl6 ">
        <div class='entry-meta '>
            <h3><?php the_title(); ?></h3>
            <?php printf($rate); ?>
            <p><?php echo esc_html($excerpt); ?></p>
        
            <div class='uk-grid uk-child-width-1-2  uk-padding uk-padding-remove-bottom'>
                <ul class='meta-details '>
                    <?php printf($result); ?>
                </ul>
                <div class="meta-details-r">
                    <span><?php esc_html_e('Starts from', 'lagom'); ?></span>
                    <p class='price'><?php echo Themeton_Std::getmeta('room_price')?></p>
                    <a href="<?php echo get_the_permalink();?>" class="uk-button uk-button-default mt2"> <?php esc_html_e('book now', 'lagom'); ?></a>
                </div>
            </div>
        </div>
        
    </div>
</div>  