<?php
if ( post_password_required() ) {
    return;
}
if( !function_exists('lagom_custom_comment_item') ):
function lagom_custom_comment_item($comment, $args, $depth) {
    $GLOBALS['comment'] = $comment;

    if ( 'div' == $args['style'] ) {
        $tag = 'div';
    } else {
        $tag = 'li';
    }

    switch ( $comment->comment_type ) :
        case 'pingback' :
        case 'trackback' :
    ?>
    
    <<?php echo esc_attr($tag); ?> class="comment pingback">
        <p><?php esc_html_e('Pingback:', 'lagom'); ?> <?php comment_author_link(); ?><?php edit_comment_link( esc_html__('Edit', 'lagom'), '<span class="edit-link">', '</span>' ); ?></p>
    <?php
            break;
        default: 
    ?>
    <<?php echo esc_attr($tag); ?> <?php comment_class( empty( $args['has_children'] ) ? '' : 'parent' ) ?> id="comment-<?php comment_ID() ?>">
        <article> 
            <div class="uk-visible-toggle">
            <div class="comment-avatar">
                <?php echo get_avatar( $comment, 128 ); ?>
            </div>

            <div class="comment-body">
                <div class="meta-data">
                    <a href="javascript:;" class="comment-author"><?php echo get_comment_author(); ?></a>
                </div>
                <div class="meta-data">
                    <span class="comment-date"><?php printf( '%1$s', get_comment_date() ); ?> - <?php printf( '%1$s', get_comment_time() ); ?></span>
                    <span class="comment-reply">
                        <?php comment_reply_link( array_merge( $args, array( 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?>
                    </span>
                </div>
                <div class="comment-content">
                    <?php comment_text(); ?>
                </div>
            </div>
            </div>
        </article>
    <?php
            break;
    endswitch;
}
endif;
// Comment Navigation
if ( ! function_exists( 'lagom_theme_comment_nav' ) ) :
    function lagom_theme_comment_nav() {
        // Are there comments to navigate through?
        if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) :
        ?>
        <nav class="navigation comment-navigation" role="navigation">
            <h2 class="screen-reader-text"><?php esc_html_e('Comment navigation', 'lagom'); ?></h2>
            <div class="nav-links uk-clearfix">
                <?php
                    if ( $prev_link = get_previous_comments_link( esc_html__('Older Comments', 'lagom') ) ) :
                        printf( '<div class="nav-previous">%s</div>', $prev_link );
                    endif;

                    if ( $lagom_link = get_next_comments_link( esc_html__('Newer Comments', 'lagom') ) ) :
                        printf( '<div class="nav-next">%s</div>', $lagom_link );
                    endif;
                ?>
            </div><!-- .nav-links -->
        </nav><!-- .comment-navigation -->
        <?php
        endif;
    }
endif;
?>
<div id="comments" class="comments-area">    
    <?php if ( have_comments() ) : ?>
    <div class="comments-wrapper">
        <h2 class="comments-title lagom-brand-title" data-title="<?php esc_attr_e('Comments', 'lagom'); ?>">
            <?php
                printf( _nx( 'One comment', '%1$s Comments', get_comments_number(), 'comment', 'lagom' ),
                    number_format_i18n( get_comments_number() ), get_the_title() );
            ?>
        </h2>
        <?php lagom_theme_comment_nav(); ?>
        <ol class="comment-list">
            <?php
                wp_list_comments( array(
                    'style'       => 'ol',
                    'short_ping'  => true,
                    'avatar_size' => 56,
                    'callback'    => 'lagom_custom_comment_item'
                ) );
            ?>
        </ol><!-- end .comment-list -->
    </div>
    <?php endif; // end of have_comments() ?>
    <?php
    // If comments are closed and there are comments, let's leave a little note, shall we?
    if ( ! comments_open() && get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) :
        echo '<p class="no-comments">'.esc_html_e('Comments are closed.', 'lagom').'</p>';
    endif;
        $req = get_option( 'require_name_email' );
        $aria_req = ( $req ? " aria-required='true'" : '' );
        comment_form(
            array(
                'title_reply' => esc_attr__('Leave a comment', 'lagom'),
                'comment_notes_after' => '',
                'fields' => array(
                    'author' => '<div class="mt3"><input id="author" class="uk-input" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) .
                                        '" placeholder="'.esc_attr__('Name *', 'lagom').'" ' . $aria_req . ' /></div>',
                    'email' => '<div class="mt3">
                                    <input id="email" class="uk-input" name="email" type="text" value="' . esc_attr(  $commenter['comment_author_email'] ) .
                                    '" placeholder="'.esc_attr__('Email *', 'lagom').'" ' . $aria_req . ' /></div>',
                    'website' => '<div class="mt3">
                                    <input id="url" class="uk-input" name="url" type="text" value="' . esc_attr( $commenter['comment_author_url'] ) .
                                    '" placeholder="'.esc_attr__('Website', 'lagom').'"/></div>',
                ),
                'comment_field' => '<textarea id="comment" class="uk-textarea" name="comment" placeholder="'.esc_attr__('Comments', 'lagom').'"></textarea>'
            )
        );
    ?>
</div>