<?php

// No direct access, please
if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Template part for displaying post social sharer
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Flexia
 */
$thumbnail = '';
    if (function_exists('has_post_thumbnail')) {
        if ( has_post_thumbnail() ) {
             $thumbnail = wp_get_attachment_url( get_post_thumbnail_id() );
        }
    }
$social_sharing_text = get_theme_mod('flexia_social_sharing_text', 'Share This Story');
$facebook_sharing = get_theme_mod('post_social_share_facebook', true);
$twitter_sharing = get_theme_mod('post_social_share_twitter', true);
$linkedin_sharing = get_theme_mod('post_social_share_linkedin', true);
$gmail_sharing = get_theme_mod('post_social_share_gmail', true);
$pinterest_sharing = get_theme_mod('post_social_share_pinterest', true);
$reddit_sharing = get_theme_mod('post_social_share_reddit', true);
$blogger_sharing = get_theme_mod('post_social_share_blogger', true);
$thumblr_sharing = get_theme_mod('post_social_share_thumblr', true);
?>

<div class="flexia-social-share">
	<div class="flexia-social-share-heading">
        <h5><?php echo wp_kses_post($social_sharing_text); ?></h5>
	</div>
	<ul class="flexia-social-share-links">
		<?php if( $facebook_sharing == true ) : ?>
		<li><a href="https://www.facebook.com/sharer/sharer.php?u=<?php the_permalink(); ?>" target="_blank"><svg version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 23.101 23.101" style="enable-background:new 0 0 23.101 23.101;" xml:space="preserve"><g><path d="M8.258,4.458c0-0.144,0.02-0.455,0.06-0.931c0.043-0.477,0.223-0.976,0.546-1.5c0.32-0.522,0.839-0.991,1.561-1.406 C11.144,0.208,12.183,0,13.539,0h3.82v4.163h-2.797c-0.277,0-0.535,0.104-0.768,0.309c-0.231,0.205-0.35,0.4-0.35,0.581v2.59h3.914 c-0.041,0.507-0.086,1-0.138,1.476l-0.155,1.258c-0.062,0.425-0.125,0.819-0.187,1.182h-3.462v11.542H8.258V11.558H5.742V7.643 h2.516V4.458z"/><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g></svg></a></li>
		<?php endif; ?>

		<?php if( $twitter_sharing == true ) : ?>
		<li><a href="https://twitter.com/home?status=<?php the_permalink(); ?>" target="_blank"><svg id="Bold" enable-background="new 0 0 24 24" height="512" viewBox="0 0 24 24" width="512" xmlns="http://www.w3.org/2000/svg"><path d="m21.534 7.113c.976-.693 1.797-1.558 2.466-2.554v-.001c-.893.391-1.843.651-2.835.777 1.02-.609 1.799-1.566 2.165-2.719-.951.567-2.001.967-3.12 1.191-.903-.962-2.19-1.557-3.594-1.557-2.724 0-4.917 2.211-4.917 4.921 0 .39.033.765.114 1.122-4.09-.2-7.71-2.16-10.142-5.147-.424.737-.674 1.58-.674 2.487 0 1.704.877 3.214 2.186 4.089-.791-.015-1.566-.245-2.223-.606v.054c0 2.391 1.705 4.377 3.942 4.835-.401.11-.837.162-1.29.162-.315 0-.633-.018-.931-.084.637 1.948 2.447 3.381 4.597 3.428-1.674 1.309-3.8 2.098-6.101 2.098-.403 0-.79-.018-1.177-.067 2.18 1.405 4.762 2.208 7.548 2.208 8.683 0 14.342-7.244 13.986-14.637z"/></svg></a></li>
		<?php endif; ?>

		<?php if( $linkedin_sharing == true ) : ?>
		<li><a href="https://www.linkedin.com/shareArticle?mini=true&url=<?php the_permalink(); ?>&title=&summary=&source=" target="_blank"><svg height="682pt" viewBox="-21 -35 682.66669 682" width="682pt" xmlns="http://www.w3.org/2000/svg"><path d="m77.613281-.667969c-46.929687 0-77.613281 30.816407-77.613281 71.320313 0 39.609375 29.769531 71.304687 75.8125 71.304687h.890625c47.847656 0 77.625-31.695312 77.625-71.304687-.894531-40.503906-29.777344-71.320313-76.714844-71.320313zm0 0"/><path d="m8.109375 198.3125h137.195313v412.757812h-137.195313zm0 0"/><path d="m482.054688 188.625c-74.011719 0-123.640626 69.546875-123.640626 69.546875v-59.859375h-137.199218v412.757812h137.191406v-230.5c0-12.339843.894531-24.660156 4.519531-33.484374 9.917969-24.640626 32.488281-50.167969 70.390625-50.167969 49.644532 0 69.5 37.851562 69.5 93.339843v220.8125h137.183594v-236.667968c0-126.78125-67.6875-185.777344-157.945312-185.777344zm0 0"/></svg></a></li>
		<?php endif; ?>

		<?php if( $gmail_sharing == true ) : ?>
		<li><a href="https://mail.google.com/mail/?view=cm&fs=1&tf=1&to=&su=<?php the_title(); ?>&body=<?php the_permalink(); ?>&ui=2&tf=1&pli=1" target="_blank"><svg id="Layer_1" enable-background="new 0 0 512 512" height="512" viewBox="0 0 512 512" width="512" xmlns="http://www.w3.org/2000/svg"><path d="m452 48h-392c-33.084 0-60 26.916-60 60v49.495l220.191 163.781c10.709 7.965 23.259 11.948 35.809 11.948s25.1-3.982 35.809-11.948l220.191-163.781v-49.495c0-33.084-26.916-60-60-60zm20 89.396-204.063 151.784c-7.14 5.311-16.734 5.311-23.873 0l-204.064-151.784v-29.396c0-11.028 8.972-20 20-20h392c11.028 0 20 8.972 20 20zm0 99.703 40-29.752v196.653c0 33.084-26.916 60-60 60h-392c-33.084 0-60-26.916-60-60v-196.653l40 29.752v166.901c0 11.028 8.972 20 20 20h392c11.028 0 20-8.972 20-20z"/></svg></a></li>
		<?php endif; ?>

		<?php if( $pinterest_sharing == true ) : ?>
		<li><a href="https://pinterest.com/pin/create/button/?url=<?php the_permalink(); ?>&media=<?php echo esc_attr($thumbnail); ?>&description=" target="_blank"><svg version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 511.977 511.977" style="enable-background:new 0 0 511.977 511.977;" xml:space="preserve"> <g> <g> <path d="M262.948,0C122.628,0,48.004,89.92,48.004,187.968c0,45.472,25.408,102.176,66.08,120.16 c6.176,2.784,9.536,1.6,10.912-4.128c1.216-4.352,6.56-25.312,9.152-35.2c0.8-3.168,0.384-5.92-2.176-8.896 c-13.504-15.616-24.224-44.064-24.224-70.752c0-68.384,54.368-134.784,146.88-134.784c80,0,135.968,51.968,135.968,126.304 c0,84-44.448,142.112-102.208,142.112c-31.968,0-55.776-25.088-48.224-56.128c9.12-36.96,27.008-76.704,27.008-103.36 c0-23.904-13.504-43.68-41.088-43.68c-32.544,0-58.944,32.224-58.944,75.488c0,27.488,9.728,46.048,9.728,46.048 S144.676,371.2,138.692,395.488c-10.112,41.12,1.376,107.712,2.368,113.44c0.608,3.168,4.16,4.16,6.144,1.568 c3.168-4.16,42.08-59.68,52.992-99.808c3.968-14.624,20.256-73.92,20.256-73.92c10.72,19.36,41.664,35.584,74.624,35.584 c98.048,0,168.896-86.176,168.896-193.12C463.62,76.704,375.876,0,262.948,0z"/> </g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> </svg></a></li>
		<?php endif; ?>

		<?php if( $reddit_sharing == true ) : ?>
		<li><a href="https://www.reddit.com/submit?url=<?php the_permalink(); ?>&title=<?php the_title(); ?>" target="_blank"><svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 100 100" style="enable-background:new 0 0 100 100;" xml:space="preserve">
<path class="st0" d="M-190,1133.7c5.9-0.7,11.7-1.5,17.6-2c50.7-4.4,99-17.5,144-41.1c109.1-57.2,178.9-145.7,208.7-265.4
	c6.2-25,9.5-50.5,10.2-76.3c0-1.6,0.7-3.1,1-4.7c0,129.8,0,259.5,0,389.6C64.4,1133.7-62.8,1133.7-190,1133.7z"/>
<g>
	<path class="st1" d="M52.3,100c-1.5,0-3.1,0-4.6,0c-0.2,0-0.4-0.1-0.6-0.1c-2.2-0.3-4.4-0.4-6.6-0.8C29.8,97,20.8,92,13.4,84
		C4.7,74.7,0.3,63.5,0,50.7c-0.1-3,0.2-5.9,0.7-8.9C2.4,31.4,6.9,22.5,14.3,15c8.5-8.7,18.9-13.6,31-14.8c5-0.5,10-0.2,14.9,0.8
		c10.2,2.2,19,7,26.1,14.7c8.5,9.1,13,19.9,13.6,32.4c0,0.2,0.1,0.4,0.1,0.6c0,0.8,0,1.7,0,2.5c0,0.2-0.1,0.4-0.1,0.6
		c-0.1,3.2-0.5,6.4-1.3,9.6c-3.7,15-12.5,26.1-26.1,33.2c-5.6,3-11.7,4.6-18,5.1C53.8,99.8,53,99.9,52.3,100z M47.9,41.2
		c-0.3,0-0.6,0.1-0.9,0.1c-4.4,0.3-8.6,1.3-12.6,3.1c-0.4,0.2-0.6,0.2-1-0.1c-1.5-1-3.2-1.4-5-1c-4.6,1-6.9,6-4.7,10.3
		c0.1,0.3,0.2,0.7,0.1,1c-1.2,3.6-0.8,7,1.1,10.2c1.6,2.7,3.9,4.7,6.6,6.3c4.8,2.9,10,4.3,15.6,4.7c5.7,0.4,11.3-0.3,16.7-2.3
		c3.9-1.5,7.4-3.6,10.1-6.8c3-3.7,4-7.8,2.3-12.4c-0.1-0.2,0-0.5,0-0.7c0.2-1,0.6-1.9,0.7-2.9c0.1-2.7-1-4.8-3.3-6.2
		c-2.2-1.4-4.5-1.3-6.8,0c-0.3,0.2-0.5,0.2-0.9,0c-3.3-1.6-6.8-2.5-10.4-3c-0.9-0.1-1.8-0.2-2.7-0.3c0-0.2,0.1-0.4,0.1-0.6
		c0.6-3.3,2.5-5.6,5.4-7.1c0.4-0.2,0.6-0.2,1,0c1.2,0.9,2.6,1.2,4.1,0.9c3.1-0.6,5-3.4,4.6-6.6c-0.4-3.3-3.6-5.6-6.8-4.9
		c-2.7,0.6-4.5,3-4.4,5.9c0,0.5-0.2,0.8-0.6,1.1c-1.7,1-3.3,2.1-4.9,3.2c-1.3,0.9-2.2,2.2-2.5,3.7C48.5,38.3,48.2,39.7,47.9,41.2z"
		/>
	<path class="st1" d="M50.1,71.2c-2.6-0.1-5-0.2-7.3-1.1c-1.3-0.5-2.4-1.2-3.3-2.3c-0.5-0.6-0.8-1.3-0.7-2.1
		c0.1-1.1,0.8-1.6,1.9-1.2c0.2,0.1,0.4,0.2,0.6,0.3c1.5,1.1,3.2,1.6,5,1.7c2.9,0.3,5.8,0.3,8.6-0.2c1.3-0.2,2.4-0.7,3.5-1.4
		c0.3-0.2,0.7-0.4,1.1-0.5c0.8-0.2,1.4,0.2,1.5,1c0.1,0.9-0.1,1.7-0.6,2.4c-0.7,1-1.7,1.6-2.7,2.1c-1.6,0.7-3.4,1.1-5.2,1.2
		C51.6,71.2,50.8,71.2,50.1,71.2z"/>
	<path class="st1" d="M45.4,55.1c0,2.5-1.9,4.6-4.4,4.5c-2.5,0-4.4-2-4.4-4.6c0-2.5,2-4.6,4.4-4.6C43.5,50.5,45.4,52.6,45.4,55.1z"
		/>
	<path class="st1" d="M63.3,55.1c0,2.5-2,4.5-4.4,4.5c-2.5,0-4.4-2-4.4-4.6c0-2.5,2-4.6,4.4-4.6C61.3,50.5,63.3,52.6,63.3,55.1z"/>
</g>
</svg></a></li>
		<?php endif; ?>

		<?php if( $blogger_sharing == true ) : ?>
		<li><a href="https://www.blogger.com/blog_this.pyra?t&u=<?php the_permalink(); ?>&n=<?php the_title(); ?>" target="_blank"><svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 viewBox="0 0 100 100" style="enable-background:new 0 0 100 100;" xml:space="preserve">
<g>
	<path class="st0" d="M-0.1,61.1c0-11.2,0-22.4,0-33.5c0-0.2,0.1-0.4,0.1-0.7c0-4.6,0.1-9.1,0.1-13.7c0-0.6,0.1-1.2,0.2-1.7
		C1.4,7.1,4,3.9,7.9,1.8c1.3-0.7,2.7-1.3,4.2-1.4c1.4-0.1,2.8-0.1,4.2-0.1c2.8,0,5.5-0.1,8.3-0.1c7.1,0,14.2,0,21.3-0.1
		c0.2,0,0.4-0.1,0.6-0.1c5.8,0,11.7,0,17.5,0c0.2,0,0.3,0.1,0.5,0.1c7.2,0,14.4,0.1,21.6,0.1c0.6,0,1.2,0,1.8,0.1
		c2.4,0.5,4.5,1.5,6.4,2.9c2.3,1.8,3.8,4.2,4.9,6.8c0.2,0.5,0.3,1,0.4,1.5c0.1,1.9,0.3,3.9,0.3,5.8c0.1,2.6,0.1,5.3,0.1,7.9
		c0,20,0,40-0.1,60c0,0.7,0,1.5-0.2,2.2c-0.8,4.7-3.2,8.2-7.3,10.6c-1.5,0.9-3.2,1.5-5,1.8c-0.5,0.1-1,0.1-1.6,0.2
		c-23.8,0-47.6,0-71.4,0c-0.2,0-0.4-0.1-0.6-0.1c-0.7-0.1-1.4,0-2.1-0.2c-2.9-0.6-5.4-2-7.5-4c-2.2-2.1-3.5-4.7-4.1-7.6
		C0,86.7,0,85.2,0,83.7c0-7.3,0-14.7-0.1-22C0,61.5-0.1,61.3-0.1,61.1z M19,49.7c-0.1,0-0.1,0-0.2,0c0.1,4.7,0.1,9.4,0.3,14
		c0.1,2.3,0.7,4.5,1.7,6.6c1.8,3.7,4.5,6.5,8,8.5c2.3,1.3,4.7,2.2,7.4,2.2c2.1,0,4.2,0.1,6.3,0.1c6.8,0,13.5,0,20.3-0.1
		c0.4,0,0.9,0,1.3-0.1c3.9-0.5,7.3-2,10.3-4.7c4.1-3.7,6.5-8.2,6.5-13.7c0-1.7,0.1-3.4,0.1-5c0-3.8,0-7.5-0.1-11.3
		c0-1.1-0.4-2.1-1.2-2.8c-0.3-0.3-0.7-0.6-1.1-0.7c-0.6-0.2-1.2-0.2-1.8-0.2c-1.3-0.1-2.6-0.1-3.8-0.3c-1.4-0.1-2.8-1.3-3-2.6
		c-0.1-0.7-0.2-1.5-0.2-2.2c0-2-0.4-3.9-1.2-5.7c-2.1-5-5.7-8.6-10.4-11.1c-1.5-0.8-3.2-1.5-5-1.5c-1.9-0.1-3.9-0.1-5.8-0.2
		c-3.4,0-6.7,0-10.1,0.1c-1,0-2.1,0.1-3.1,0.4c-5.1,1.1-9.1,3.8-12.1,8.1c-2.3,3.3-3.4,6.9-3.4,11C19,42.3,19,46,19,49.7z"/>
	<path class="st0" d="M49.9,64.8c-3,0-6,0-9,0c-1,0-2-0.1-3-0.2c-0.3,0-0.6-0.2-0.8-0.3c-0.9-0.6-1.5-1.5-1.7-2.6
		c-0.2-1.6,1.1-3.4,2.7-3.5c0.9-0.1,1.8-0.2,2.7-0.2c5.5,0,11.1-0.1,16.6-0.1c1.5,0,3,0.1,4.4,0.2c1.4,0.1,2.6,1.7,2.6,2.9
		c0,0.4,0,0.8-0.1,1.1c-0.4,1.5-1.2,2.2-2.9,2.4c-0.8,0.1-1.5,0.2-2.3,0.2C56.1,64.7,53,64.7,49.9,64.8
		C49.9,64.7,49.9,64.7,49.9,64.8z"/>
	<path class="st0" d="M44.2,42.4c-1.6,0-3.2,0-4.8,0c-0.5,0-1.1,0-1.6-0.1c-1.2-0.3-1.9-1.1-2.3-2.2c-0.4-1.4-0.1-2.6,0.9-3.6
		c0.7-0.6,1.5-0.8,2.3-0.8c3.3-0.1,6.6-0.1,9.9-0.1c1,0,2.1,0,3,0.6c1.1,0.7,1.6,1.7,1.6,2.9c0,1.4-0.7,2.5-2,3
		c-0.7,0.2-1.4,0.2-2.1,0.3C47.5,42.4,45.9,42.4,44.2,42.4z"/>
</g>
</svg></a></li>
		<?php endif; ?>

		<?php if( $thumblr_sharing == true ) : ?>
		<li><a href="https://www.tumblr.com/share?v=3&u=<?php the_permalink(); ?>&t=<?php the_title(); ?>" target="_blank"><svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 viewBox="0 0 100 100" style="enable-background:new 0 0 100 100;" xml:space="preserve">

<path class="st0" d="M-190,1133.7c5.9-0.7,11.7-1.5,17.6-2c50.7-4.4,99-17.5,144-41.1c109.1-57.2,178.9-145.7,208.7-265.4
	c6.2-25,9.5-50.5,10.2-76.3c0-1.6,0.7-3.1,1-4.7c0,129.8,0,259.5,0,389.6C64.4,1133.7-62.8,1133.7-190,1133.7z"/>
<path d="M49.9,0C59.2,0,68.6,0,77.9,0c13.8,0.1,22,8.1,22.1,21.9c0.1,18.8,0.1,37.6,0,56.3c-0.1,13.5-8.2,21.6-21.8,21.7
	c-18.8,0.1-37.6,0.1-56.3,0C8,99.9,0,91.7,0,77.8C0,59.2,0,40.6,0,22C0.1,8.2,8.1,0.1,22,0C31.3,0,40.6,0,49.9,0z M66.7,69
	c-2.4-0.1-4.2-0.1-6-0.3c-3.1-0.3-5.3-1.8-5.4-5.1c-0.1-5.7,0-11.5,0-17.9c3.9,0,7.4,0,10.9,0c0-4.2,0-7.8,0-11.7
	c-3.8,0-7.2,0-11.2,0c0-5.4,0-10.3,0-15.4c-3.4,0-6.2,0-9.2,0c-1.3,7.9-4.7,14-12.5,16.9c-0.7,0.3-1.4,1.5-1.5,2.4
	c-0.2,2.5-0.1,5.1-0.1,7.7c3.1,0.2,5.6,0.4,8.8,0.6c0,7.4-0.3,14.4,0.1,21.4c0.3,5.6,3.1,10.4,8.6,11.8c5.6,1.4,11.1,1.2,17.5,1.2
	C66.7,75.6,66.7,73,66.7,69z"/>
</svg></a></li>
		<?php endif; ?>
	</ul>
</div> <!-- Social Share end-->