<?php
/*
Plugin Name: Website Security
Plugin URI: https://www.siteguarding.com/
Description: Special security plugin to connect your website to SiteGuarding.com services
Author: SiteGuarding.com
Version: 1.1
Author URI: https://www.siteguarding.com/
License: GPLv2
*/
if (!defined('ABSPATH')) die('Access is not allowed');

if (!defined('SGWS_SITE_ROOT')) define('SGWS_SITE_ROOT', ABSPATH . DIRECTORY_SEPARATOR);



$sgws_plugin_dir = dirname(__FILE__).DIRECTORY_SEPARATOR;
if (!defined('SGWS_TOOLS_FILE')) define('SGWS_TOOLS_FILE', $sgws_plugin_dir . 'siteguarding_tools.php');


if( is_admin() ) {
	
	add_action('admin_menu', 'register_sgws_website_security');

	function register_sgws_website_security() { 
		add_menu_page('sgws_website_security', 'Website Security', 'activate_plugins', 'sgws_website_security', 'sgws_website_security_callback', plugins_url( 'images/icon.svg', __FILE__ ));
		
	}

	function sgws_website_security_callback() 
	{
	    $autologin_config = SGWS_SITE_ROOT.DIRECTORY_SEPARATOR.'webanalyze'.DIRECTORY_SEPARATOR.'website-security-conf.php';
        if (file_exists($autologin_config)) include_once($autologin_config);
       
		$domain = get_site_url();
        $admin_email = get_option( 'admin_email' );

		
		echo '<div class="wrap">';			
			?>		
		
		<h2>Website Security</h2>

		<?php

		$success = sgws_check_file();
		if ($success) 
        {
            if (defined('WEBSITE_SECURITY_AUTOLOGIN'))
            {
                // file exists
                ?>
                <form action="https://www.siteguarding.com/index.php" method="post">
                
                <p style="text-align: center;">
                <img style="width: 500px;margin: 20px 0;" src="<?php echo plugins_url('images/', __FILE__).'logo_siteguarding.svg'; ?>" />
                </p>
                <p style="text-align: center; font-size: 19px;">Use SiteGuarding dashboard to manage security services of your website</p>

                <p style="text-align: center">
                    <input class="button button-primary button-hero" type="submit" value="Security Dashboard" />
                </p>

                <input type="hidden" name="option" value="com_securapp" />
                <input type="hidden" name="autologin_key" value="<?php echo WEBSITE_SECURITY_AUTOLOGIN; ?>" />
                <input type="hidden" name="website_url" value="<?php echo $domain; ?>" />
                <input type="hidden" name="task" value="Panel_autologin" />
                </form>
                <?php
            }
            else {
                // Need to register the website
                ?>
                <p style="text-align: center;">
                <img style="width: 500px;margin: 20px 0;" src="<?php echo plugins_url('images/', __FILE__).'logo_siteguarding.svg'; ?>" />
                </p>
                <p style="text-align: center; font-size: 19px;">One more step to protect your website.</p>
                <p style="text-align: center; font-size: 15px;">
                Please go to <a href="https://www.siteguarding.com/en/login">SiteGuarding.com</a> login to the account and add your website.
                </p>
                <p style="text-align: center;">
                <a class="button button-primary button-hero" href="https://www.siteguarding.com/en/login">CLICK TO LOGIN</a>
                </p>
                <?php
            }

		} else {
			echo '<p style="color:red"><b>The file does not exist or corrupted. Could not to overwrite it. Please reinstall plugin from <a target="_blank" href="https://www.siteguarding.com">https://www.siteguarding.com</a></b></p>';
		}
		echo '</div>';
	
	}
	
}	

	add_filter( 'cron_schedules', 'sgws_cron_day' );
	function sgws_cron_day( $schedules ) {
		$schedules['one_per_day'] = array(
			'interval' => 60 * 60 * 24,
			'display' => 'one per day'
		);
		return $schedules;
	}
	
	function sgws_check_file() {
		
		$tools_file = SGWS_SITE_ROOT.'siteguarding_tools.php';
		if (!is_file($tools_file) || md5_file($tools_file) !== md5_file(SGWS_TOOLS_FILE)) copy(SGWS_TOOLS_FILE, $tools_file);
		return (is_file($tools_file) && md5_file($tools_file) === md5_file(SGWS_TOOLS_FILE));
        
        $folder = SGWS_SITE_ROOT.DIRECTORY_SEPARATOR.'webanalyze';
        if (!file_exists($folder)) mkdir($folder);
		
	}
	
	add_action( 'sgws_check_file_cron', 'sgws_check_file' );
	
	
	function sgws_deactivation() {
		wp_clear_scheduled_hook( 'sgws_check_file_cron' );
	}

	register_deactivation_hook( __FILE__, 'sgws_deactivation' );	
	
	
	function sgws_activation() {
		sgws_check_file();
		if( ! wp_next_scheduled( 'sgws_check_file_cron' ) ) {  
			wp_schedule_event( time(), 'one_per_day', 'sgws_check_file_cron');  
		} else if (wp_get_schedule( 'sgws_check_file_cron' ) != 'one_per_day') {
			wp_clear_scheduled_hook( 'sgws_check_file_cron' );
			wp_schedule_event( time(), 'one_per_day', 'sgws_check_file_cron');
		}
	}

	register_activation_hook( __FILE__, 'sgws_activation' );

	
	

