<?php

if( !class_exists('TTRenderMetaFields')) {
class TTRenderMetaFields{

    public static function getField($params){
        
        global $post;
        $name = $params['name'];
        $type = $params['type'];
        $meta_val = Themeton_Std::getmeta($params['name'], $post->ID);

        $default = isset($params['default']) ? $params['default'] : '';
        $value = $meta_val != '' ? $meta_val : $default;
        if (isset($params['option']))
            $option = $params['option'];

        $gatts = 'id="' . esc_attr($name) . '" name="' . esc_attr($name) . '"';


        switch ($type) {
            case 'title':
                return '<span style="font-weight: bold;font-size:14px;background-color: #4cd864;display: inline-block;padding:7px;border-radius: 3px;color: #fff;">' . $params['title'] . '</span>';
                break;
            case 'colorpicker':
                return '<input type="text" ' . $gatts . ' value="' . esc_attr($value) . '" class="lagom_wpcolorpicker" data-default-color="' . $default . '" />';
                break;
            case 'text':
                return '<input type="text" ' . $gatts . ' value="' . esc_attr($value) . '" />';
                break;
            case 'number':
                return '<input type="number" ' . $gatts . ' step="1" min="0" value="' . esc_attr((int)$value) . '" class="small-text" />';
                break;
            case 'textarea':
                return '<textarea ' . $gatts . '>' . $value . '</textarea>';
                break;
            case 'select':
                $html = '<select ' . $gatts . ' default-value="' . esc_attr($value) . '" class="lagom_wpselectbox">';
                foreach ($option as $key => $val) {
                    $html .= '<option value="' . $key . '">' . $val . '</option>';
                }
                $html .= '</select>';
                return $html;
                break;
            case 'radio':
                $html = '';
                foreach ($option as $key => $val) {
                    $html .= '<input type="radio" group="lagom_group_' . esc_attr($name) . '" ' . $gatts . ' class="lagom_wpradiobox" ' . ($value == $key ? 'checked' : '') . '>';
                    $html .= $val . '<br>';
                }
                return $html;
                break;
            case 'icon':
                $html = '';
                foreach ($option as $key => $val) {
                    $html .= '<input type="radio" group="lagom_group_' . esc_attr($name) . '" ' . $gatts . ' class="lagom_wpradiobox" ' . ($val == $key ? 'checked' : '') . '>';
                    $html .= $val;
                    if ($key == 'custom')
                        $html .= '<input type="text" value""/>';
                    $html .= '<br>';
                }
                return $html;
                break;
            case 'thumbs':
                $html = '';
                $ndx = 0;
                foreach ($option as $key => $val) {
                    $ndx++;
                    $html .= '<input type="radio" group="lagom_group_' . esc_attr($name) . '" name="' . esc_attr($name) . '" id="' . esc_attr($name . $ndx) . '" value="' . esc_attr($key) . '" class="lagom_wpradiobox" ' . ($key == $value ? 'checked' : '') . '>';
                    $html .= '<label for="' . esc_attr($name . $ndx) . '"><img src="' . esc_attr($val) . '" class="'.($key == $value ? 'active' : '').'" /></label>';
                }
                return "<div class='page_option_field_thumbs'>$html</div>";
                break;
            case 'image':
                $html = '';
                $html .= '<div class="pmeta_item_browse">
                            <input type="text" ' . $gatts . ' value="' . esc_attr($value) . '" />
                            <a href="javascript:;" class="button pmeta_button_browse">'.esc_html__('Browse...', 'lagom').'</a>
                            <div class="browse_preview">' . ($value != '' ? '<img src="' . $value . '" /><a href="javascript:;">'.esc_html__('Remove', 'lagom').'</a>' : '') . '</div>
                        </div>';
                return $html;
                break;
            case 'metro':
                $html = '<div id="metro_style_container">
                                <a href="javascript:;" class="small1"><img src="' . trailingslashit(get_template_directory_uri()) . 'framework/post-type/images/post-format/small-icon-title.png" /></a>
                                <a href="javascript:;" class="small2"><img src="' . trailingslashit(get_template_directory_uri()) . 'framework/post-type/images/post-format/small-title.png" /></a>
                                <a href="javascript:;" class="small3"><img src="' . trailingslashit(get_template_directory_uri()) . 'framework/post-type/images/post-format/small-image.png" /></a>
                                <a href="javascript:;" class="small4"><img src="' . trailingslashit(get_template_directory_uri()) . 'framework/post-type/images/post-format/small-icon.png" /></a>
                                <a href="javascript:;" class="hor1"><img src="' . trailingslashit(get_template_directory_uri()) . 'framework/post-type/images/post-format/big-icon-title.png" /></a>
                                <a href="javascript:;" class="hor2"><img src="' . trailingslashit(get_template_directory_uri()) . 'framework/post-type/images/post-format/big-icon.png" /></a>
                                <a href="javascript:;" class="hor3"><img src="' . trailingslashit(get_template_directory_uri()) . 'framework/post-type/images/post-format/big-image.png" /></a>
                                <a href="javascript:;" class="hor4"><img src="' . trailingslashit(get_template_directory_uri()) . 'framework/post-type/images/post-format/big-title.png" /></a>
                                <a href="javascript:;" class="large1"><img src="' . trailingslashit(get_template_directory_uri()) . 'framework/post-type/images/post-format/large-icon-title.png" /></a>
                                <a href="javascript:;" class="large2"><img src="' . trailingslashit(get_template_directory_uri()) . 'framework/post-type/images/post-format/large-icon.png" /></a>
                                <a href="javascript:;" class="large3"><img src="' . trailingslashit(get_template_directory_uri()) . 'framework/post-type/images/post-format/large-image-stitle.png" /></a>
                                <a href="javascript:;" class="large4"><img src="' . trailingslashit(get_template_directory_uri()) . 'framework/post-type/images/post-format/large-image-title.png" /></a>
                                <a href="javascript:;" class="large5"><img src="' . trailingslashit(get_template_directory_uri()) . 'framework/post-type/images/post-format/large-image.png" /></a>
                                <a href="javascript:;" class="large6"><img src="' . trailingslashit(get_template_directory_uri()) . 'framework/post-type/images/post-format/large-title.png" /></a>
                                <a href="javascript:;" class="ver1"><img src="' . trailingslashit(get_template_directory_uri()) . 'framework/post-type/images/post-format/large-ver-title.png" /></a>
                                <a href="javascript:;" class="ver2"><img src="' . trailingslashit(get_template_directory_uri()) . 'framework/post-type/images/post-format/large-ver-icon.png" /></a>
                        </div>';

                $html .= '<input type="hidden" ' . $gatts . ' value="' . esc_attr($value) . '"/>';
                return $html;
                break;
            case 'font_icon':
                $html = '';
                $html .= '<div class="pmeta_item_font">
                                    <input type="text" ' . $gatts . ' value="' . esc_attr($value) . '"/>
                                    <a href="javascript:;" class="button pmeta_button_font">'.esc_html__('Font Icon...', 'lagom').'</a>
                            </div>';
                return $html;
                break;
            case 'onepage':
                $html = '';

                $html .= '<select id="onpage_allpages">';
                $html .= '<option value="0">' . esc_attr__('Choose page...', 'lagom') . '</option>';
                $pages = get_pages();
                foreach ($pages as $page) {
                    if( get_post_meta( $page->ID, '_wp_page_template', true )!='page-one-page.php' ){
                        $html .= '<option value="' . esc_attr($page->ID) . '" data-link="' . get_permalink($page->ID) . '">' . $page->post_title . '</option>';
                    }
                }
                $html .= '</select>';
                $html .= '&nbsp;&nbsp;<a href="javascript:;" class="button" id="button_onepage_add">'.esc_html__('Add Page', 'lagom').'</a>';
                $html .= '&nbsp;&nbsp;<a href="javascript:;" class="button" id="button_op_custom_link">'.esc_html__('Custom Link', 'lagom').'</a>';

                $html .= '<div id="onepage_container"></div>';

                $html .= '<input type="hidden" ' . $gatts . ' value="' . esc_attr($value) . '" />';
                return $html;
                break;
            case 'checkbox':
                return '<span class="blox_switcher '.($value == '1' ? 'on' : '').'">
                            <span class="handle"></span>
                            <input type="hidden" ' . $gatts . ' value="' . ($value == '1' ? '1' : '0') . '" />
                        </span>';
                break;
            case 'customlink':
                return '<input type="text" ' . $gatts . ' value="' . esc_attr($value) . '" /><input type="checkbox" value="1"/> Open in a new tab?';
                break;
            case 'video':
                $html = '<div class="pmeta_video">
                            <input type="text" ' . $gatts . ' value="' . esc_attr($value) . '" />
                            <a href="javascript:;" class="button pmeta_button_browse">'.esc_html__('Browse...', 'lagom').'</a>
                        </div>';
                return $html;
                break;

            case 'gallery':
                $imgs = '';
                $arr = explode(',', trim($value));
                foreach ($arr as $uri) {
                    if( $uri!='' ){
                        $imgs .= '<span style="background-image: url('.esc_url(wp_get_attachment_url($uri)).');"></span>';
                    }
                }
                $html = '<div class="pmeta_gallery">
                            <a href="javascript:;" class="button pmeta_button_browse">'.esc_html__('Insert/Update Gallery...', 'lagom').'</a>
                            <a href="javascript:;" class="pmeta_remove" title="'.esc_attr__('Remove Gallery', 'lagom').'">(x)</a>
                            <input type="hidden" ' . $gatts . ' value="'.esc_attr(trim($value)).'" class="gallery_images" />
                            <div class="gallery_images_preview">'.$imgs.'</div>
                        </div>';
                return $html;
                break;

            case 'list_content':
                $imgs = '';
                $val = !empty($value) ? $value : '';
                $html = '<div class="pmeta_list_content">
                            <div class="pm_list_contents"></div>
                            <div class="pm-list-tpl">
                                <div class="pmlc-item">
                                    <input type="text" class="pmlc-item-text" placeholder="'.esc_attr__('Label', 'lagom').'">
                                    <textarea class="pmlc-item-content" placeholder="'.esc_attr__('Content', 'lagom').'"></textarea>
                                    <a href="javascript:;" class="pmeta_remove" title="'.esc_attr__('Remove', 'lagom').'"><i class="dashicons dashicons-no-alt"></i></a>
                                    <span class="pmeta_move"><i class="dashicons dashicons-move"></i></span>
                                </div>
                            </div>
                            <textarea ' . $gatts . ' class="pmlc-data" style="display:none;">'.$val.'</textarea>
                            <a href="javascript:;" class="button pmeta_button_browse">'.esc_html__('Add Item', 'lagom').'</a>
                        </div>';
                return $html;
                break;
            
            case 'background':
                $values = TTRenderMetaFields::get_bg_values($value);
                $html = '';
                $html .= '<div class="pmeta_item_background">
                                <input type="text" id="'.esc_attr($name).'_image" name="'.esc_attr($name).'_image" value="' . esc_attr($values['url']) . '" class="bg_image_url" />
                                <input type="hidden" ' . $gatts . ' value="'.esc_attr($value).'" class="bg_hidden_value" />
                                <a href="javascript:;" class="button pmeta_button_browse">'.esc_html__('Browse...', 'lagom').'</a>
                                <div class="browse_preview" style="'.($values['url']=='' ? 'display:none;' : '').'">
                                    <div class="preview_sample" style="background-image:url('.esc_url($values['url']).');"></div>
                                    <a href="javascript:;">'.esc_html__('Remove', 'lagom').'</a>
                                </div>
                                <div class="background-controlls" style="'.($values['url']=='' ? 'display:none;' : '').'">
                                    <select id="'.esc_attr($name).'_repeat" name="'.esc_attr($name).'_repeat" default-value="'.esc_attr($values['repeat']).'" class="lagom_wpselectbox bg_image_repeat">
                                        <option value="repeat">Repeat</option>
                                        <option value="repeat-x">Repeat-X</option>
                                        <option value="repeat-y">Repeat-Y</option>
                                        <option value="no-repeat">No Repeat</option>
                                        <option value="cover">Cover</option>
                                    </select>
                                    <select id="'.esc_attr($name).'_position" name="'.esc_attr($name).'_position" default-value="'.esc_attr($values['position']).'" class="lagom_wpselectbox bg_image_position">
                                        <option value="top left">Top &amp; Left</option>
                                        <option value="top center">Top &amp; Center</option>
                                        <option value="top right">Top &amp; Right</option>
                                        <option value="center left">Center &amp; Left</option>
                                        <option value="center center">Center &amp; Center</option>
                                        <option value="center right">Center &amp; Right</option>
                                        <option value="bottom left">Bottom &amp; Left</option>
                                        <option value="bottom center">Bottom &amp; Center</option>
                                        <option value="bottom right">Bottom &amp; Right</option>
                                    </select>
                                    <select id="'.esc_attr($name).'_attach" name="'.esc_attr($name).'_attach" default-value="'.esc_attr($values['attach']).'" class="lagom_wpselectbox bg_image_attach">
                                        <option value="scroll">Scroll</option>
                                        <option value="fixed">Fixed</option>
                                        <option value="parallax">Parallax</option>
                                    </select>
                                </div>
                          </div>';
                return $html;
                break;
            default:
                return esc_html__('Option type does not prepared!', 'lagom');
                break;
        }

    }

    public static function get_bg_values($value){
        $exp = explode('$', $value);
        if( count($exp) > 3 ){
            return array(
                    'url'=>$exp[0],
                    'repeat'=>$exp[1],
                    'position'=>$exp[2],
                    'attach'=>$exp[3]
                );
        }
        return array(
                    'url'=>'',
                    'repeat'=>'',
                    'position'=>'',
                    'attach'=>''
                );
    }

}
}


//******************* Themeton Render Meta *******************//
if( !class_exists('TTRenderMeta')) {
class TTRenderMeta{
    public $items;

    function __construct(){
        $this->items = $this->items();
        add_action('admin_enqueue_scripts', array($this, 'print_admin_scripts'));
        add_action('add_meta_boxes', array($this, 'add_custom_meta'), 1);
        add_action('edit_post', array($this, 'save_post'), 99);
    }

    // admin enqueue scripts
    public function print_admin_scripts(){
        global $post_type;
        if ($post_type == '' || $post_type == NULL) {
            return;
        }
        wp_enqueue_style('render-meta', get_template_directory_uri() . '/framework/admin-assets/render.meta.css');
        wp_enqueue_script('render-meta', get_template_directory_uri() . '/framework/admin-assets/render.meta.js', array('jquery', 'jquery-ui-sortable'), false, true);
    }

    // meta items
    public function items(){
        return array();
    }

    // register meta items
    public function add_custom_meta(){
        foreach ($this->items as $key => $value) {
            $position = 'advanced';
            $priority = 'core';

            $posttype = (array)$value['post_type'];
            if( in_array('post', $posttype) ){
                $position = 'normal';
                $priority = 'high';
            }
            foreach ($posttype as $val) {
                add_meta_box(
                    'pmeta_' . $key, $value['label'], array($this, 'render_meta_section'), $val, $position, $priority, $value['items']
                );
            }
        }
    }

    // rendering meta sections
    public function render_meta_section($post, $metabox){
        global $post;
        foreach ($metabox['args'] as $value) {
            
            if ($value['type'] == 'start_group') {
                $style = '';
                if(isset($value['visible']) && $value['visible'] == false){
                    $style = 'style="display:none;"';
                }
                echo '<div id="'.$value['name'].'" class="'.$value['name'].'" '.$style.'>';
            }
            elseif ($value['type'] == 'end_group') {
                echo '</div><!-- #'.$value['name'].' -->';
            }
            else {
                
                $data_dep = "";
                if( isset($value['dependency']) && is_array($value['dependency']) ){
                    $dep = $value['dependency'];
                    if( isset($dep['element'], $dep['value']) && !empty($dep['element']) && !empty($dep['value']) ){
                        $dep_el = $dep['element'];
                        $dep_val = is_array($dep['value']) ? implode(' ', $dep['value']) : $dep['value'];
                        $data_dep = "data-dependency='$dep_el' data-dep-value='$dep_val'";
                    }
                }

                echo "<div id='option_wrapper_" . $value['name'] . "' class='page_option_fieldset' $data_dep>";

                echo '<div class="meta-option-field">';
                    if( isset($value['label']) && $value['label'] != '' && !in_array($value['type'], array('checkbox1', 'colorpicker1', 'number1')) ){
                        echo "<div><label for='" . $value['name'] . "'>" . $value['label'] . "</label>";
                            if(isset($value['desc']) && !empty($value['desc'])) {
                                echo '<div class="field_description" style="max-width:90%">'.$value['desc'].'</div>';
                            }
                        echo "</div>";
                    }
                    echo "<div>";
                        echo "<div class='page_option_field'>".TTRenderMetaFields::getField($value)."</div>";
                    echo "</div>";
                echo '</div>';
                echo "<div style='clear:both;'></div></div>";
            }
        }
    }


    // save meta fields when saving post
    public function save_post($post_id){

        if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE){
            return $post_id;
        }

        if (isset($_GET['post_type']) && 'page' == $_GET['post_type']) {
            if (!current_user_can('edit_page', $post_id)){
                return $post_id;
            }
        }
        else {
            if (!current_user_can('edit_post', $post_id)){
                return $post_id;
            }
        }

        $field_name = array();
        if( !empty($this->items) && is_array($this->items) ){
            foreach ($this->items as $key => $value) {
                foreach ($value['items'] as $item) {
                    $field_name[] = $item['name'];
                }
            }
        }


        foreach ($field_name as $field) {
            if (isset($_POST[$field])) {
                $data_field = '_' . $field;
                $data_value = $_POST[$field];

                if (count(get_post_meta($post_id, $data_field)) == 0) {
                    add_post_meta($post_id, $data_field, trim($data_value), true);
                } elseif ($data_value != get_post_meta($post_id, $data_field, true)) {
                    update_post_meta($post_id, $data_field, trim($data_value));
                } elseif ($data_value == "") {
                    delete_post_meta($post_id, $data_field, trim(get_post_meta($post_id, $data_field, true)));
                }
            }
        }
    }
}
}