function WalkontableScrollbars(instance) {
  switch (instance.getSetting('scrollbarModelV')) {
    case 'dragdealer':
      this.vertical = new WalkontableVerticalScrollbar(instance);
      break;

    case 'native':
      this.vertical = new WalkontableVerticalScrollbarNative(instance);
      break;
  }

  switch (instance.getSetting('scrollbarModelH')) {
    case 'dragdealer':
      this.horizontal = new WalkontableHorizontalScrollbar(instance);
      break;

    case 'native':
      this.horizontal = new WalkontableHorizontalScrollbarNative(instance);
      break;
  }
}

WalkontableScrollbars.prototype.destroy = function () {
  this.vertical.destroy();
  this.horizontal.destroy();
};

WalkontableScrollbars.prototype.refresh = function () {
  this.horizontal.readSettings();
  this.vertical.readSettings();
  this.horizontal.prepare();
  this.vertical.prepare();
  this.horizontal.refresh();
  this.vertical.refresh();
};