<?php
/**
 * File with Live Composer module registration
 *
 * @package Live Composer - Contact Form 7
 */

// Prevent direct access to the file.
if ( ! defined( 'ABSPATH' ) ) {
	header( 'HTTP/1.0 403 Forbidden' );
	exit;
}

/**
 * Module Class
 */
class LCPROEXT_Contact_Form_7 extends DSLC_Module {

	/**
	 * Unique module id
	 *
	 * @var string
	 */
	var $module_id;

	/**
	 * Module label to show in the page builder
	 *
	 * @var string
	 */
	var $module_title;

	/**
	 * Module icon name (FontAwesome)
	 *
	 * @var string
	 */
	var $module_icon;

	/**
	 * Section in the modules panel that includes this module
	 * Live Composer Extensions should use 'Extensions'
	 *
	 * @var string
	 */
	var $module_category;

	/**
	 * Construct
	 */
	function __construct() {
		$this->module_id = 'LCPROEXT_Contact_Form_7';
		$this->module_title = __( 'Contact Form 7', 'lcproext' );
		$this->module_icon = 'envelope';
		$this->module_category = 'Extensions';
	}

	/**
	 * Options
	 */
	function options() {

		$contact_form_choices = array();

		$contact_form_choices[] = array(
			'label' => __( '-- Select --', 'lcproext' ),
			'value' => 'not_set',
		);

		/**
		 * ----------------------------------------------------------------------
		 * Get all the forms available
		 */

		$args = array(
			'post_type' => 'wpcf7_contact_form', 
			'posts_per_page' => -1
		);

		$cf7Forms = get_posts( $args );
		$all_forms = wp_list_pluck( $cf7Forms , 'post_title', 'ID' );

		if ( is_array( $all_forms ) && ! empty( $all_forms ) ) {

			foreach ( $all_forms as $form_id => $form_title ) {
				$contact_form_choices[] = array(
					'label' => $form_title,
					'value' => $form_id,
				);
			}
		}

		$dslc_options = array(

			array(
				'label'   => __( 'Show On', 'lcproext' ),
				'id'      => 'css_show_on',
				'std'     => 'desktop tablet phone',
				'type'    => 'checkbox',
				'choices' => array(
					array(
						'label' => __( 'Desktop', 'lcproext' ),
						'value' => 'desktop',
					),
					array(
						'label' => __( 'Tablet', 'lcproext' ),
						'value' => 'tablet',
					),
					array(
						'label' => __( 'Phone', 'lcproext' ),
						'value' => 'phone',
					),
				),
			),
			array(
				'label'   => __( 'Form Name', 'lcproext' ),
				'id'      => 'contact_form',
				'std'     => 'not_set',
				'type'    => 'select',
				'choices' => $contact_form_choices,
			),

			/**
			 * Styling Options
			 */

			array(
				'label'                 => __( ' BG Color', 'lcproext' ),
				'id'                    => 'css_main_bg_color',
				'std'                   => '',
				'type'                  => 'color',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7',
				'affect_on_change_rule' => 'background-color',
				'section'               => 'styling',
			),
			array(
				'label'                 => __( 'Border Color', 'lcproext' ),
				'id'                    => 'css_main_border_color',
				'std'                   => '',
				'type'                  => 'color',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7',
				'affect_on_change_rule' => 'border-color',
				'section'               => 'styling',
			),
			array(
				'label'                 => __( 'Border Width', 'lcproext' ),
				'id'                    => 'css_main_border_width',
				'std'                   => '', // 'std' => '0',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7',
				'affect_on_change_rule' => 'border-width',
				'section'               => 'styling',
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Borders', 'lcproext' ),
				'id'                    => 'css_main_border_trbl',
				'std'                   => 'top right bottom left',
				'type'                  => 'checkbox',
				'choices'               => array(
					array(
						'label' => __( 'Top', 'lcproext' ),
						'value' => 'top',
					),
					array(
						'label' => __( 'Right', 'lcproext' ),
						'value' => 'right',
					),
					array(
						'label' => __( 'Bottom', 'lcproext' ),
						'value' => 'bottom',
					),
					array(
						'label' => __( 'Left', 'lcproext' ),
						'value' => 'left',
					),
				),
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7',
				'affect_on_change_rule' => 'border-style',
				'section'               => 'styling',
			),
			array(
				'label'                 => __( 'Border Radius - Top', 'lcproext' ),
				'id'                    => 'css_main_border_radius_top',
				'std'                   => '', // 'std' => '0',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7',
				'affect_on_change_rule' => 'border-top-left-radius,border-top-right-radius',
				'section'               => 'styling',
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Border Radius - Bottom', 'lcproext' ),
				'id'                    => 'css_main_border_radius_bottom',
				'std'                   => '', // 'std' => '0',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7',
				'affect_on_change_rule' => 'border-bottom-left-radius,border-bottom-right-radius',
				'section'               => 'styling',
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Margin Bottom', 'lcproext' ),
				'id'                    => 'css_margin_bottom',
				'std'                   => '', // 'std' => '0',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7',
				'affect_on_change_rule' => 'margin-bottom',
				'section'               => 'styling',
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Padding Vertical', 'lcproext' ),
				'id'                    => 'css_main_padding_vertical',
				'std'                   => '', // 'std' => '0',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7',
				'affect_on_change_rule' => 'padding-top,padding-bottom',
				'section'               => 'styling',
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Padding Horizontal', 'lcproext' ),
				'id'                    => 'css_main_padding_horizontal',
				'std'                   => '', // 'std' => '0',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7',
				'affect_on_change_rule' => 'padding-left,padding-right',
				'section'               => 'styling',
				'ext'                   => 'px',
			),

			/**
			 * Label
			 */

			array(
				'label'                 => __( 'Color', 'lcproext' ),
				'id'                    => 'css_labels_color',
				'std'                   => '',
				'type'                  => 'color',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'label',
				'affect_on_change_rule' => 'color',
				'section'               => 'styling',
				'tab'                   => __( 'Label', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Font Size', 'lcproext' ),
				'id'                    => 'css_labels_font_size',
				'std'                   => '', // 'std' => '16',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'label',
				'affect_on_change_rule' => 'font-size',
				'section'               => 'styling',
				'tab'                   => __( 'Label', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Font Weight', 'lcproext' ),
				'id'                    => 'css_labels_font_weight',
				'std'                   => '', // 'std' => '300',
				'type' 					=> 'select',
				'choices' => array(
					array(
						'label' => '100 - Thin',
						'value' => '100',
					),
					array(
						'label' => '200 - Extra Light',
						'value' => '200',
					),
					array(
						'label' => '300 - Light',
						'value' => '300',
					),
					array(
						'label' => '400 - Normal',
						'value' => '400',
					),
					array(
						'label' => '500 - Medium',
						'value' => '500',
					),
					array(
						'label' => '600 - Semi Bold',
						'value' => '600',
					),
					array(
						'label' => '700 - Bold',
						'value' => '700',
					),
					array(
						'label' => '800 - Extra Bold',
						'value' => '800',
					),
					array(
						'label' => '900 - Black',
						'value' => '900',
					),
				),
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'label',
				'affect_on_change_rule' => 'font-weight',
				'section'               => 'styling',
				'tab'                   => __( 'Label', 'lcproext' ),
				'ext'                   => '',
			),
			array(
				'label'                 => __( 'Font Family', 'lcproext' ),
				'id'                    => 'css_labels_font_family',
				'std'                   => '',
				'type'                  => 'font',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'label',
				'affect_on_change_rule' => 'font-family',
				'section'               => 'styling',
				'tab'                   => __( 'Label', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Line Height', 'lcproext' ),
				'id'                    => 'css_labels_line_height',
				'std'                   => '', // 'std' => '24',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'label',
				'affect_on_change_rule' => 'line-height',
				'section'               => 'styling',
				'tab'                   => __( 'Label', 'lcproext' ),
				'ext'                   => 'px',
			),

			/**
			 * Textbox / Textarea
			 */

			array(
				'label'                 => __( 'BG Color', 'lcproext' ),
				'id'                    => 'css_inputs_bg_color',
				'std'                   => 'rgba(0,0,0,0)',
				'type'                  => 'color',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'input[type=text],input[type=email],textarea,input[type=password],input[type=number],input[type=tel],input[type=url],input[type=date]',
				'affect_on_change_rule' => 'background-color',
				'section'               => 'styling',
				'tab'                   => __( 'Textbox / Textarea', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Border Color', 'lcproext' ),
				'id'                    => 'css_inputs_border_color',
				'std'                   => '', // 'std' => '#ddd',
				'type'                  => 'color',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'input[type=text],input[type=email],textarea,input[type=password],input[type=number],input[type=tel],input[type=url],input[type=date]',
				'affect_on_change_rule' => 'border-color',
				'section'               => 'styling',
				'tab'                   => __( 'Textbox / Textarea', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Text Color', 'lcproext' ),
				'id'                    => 'css_inputs_color',
				'std'                   => '', // 'std' => '#4d4d4d',
				'type'                  => 'color',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'input[type=text],input[type=email],textarea,input[type=password],input[type=number],input[type=tel],input[type=url],input[type=date]',
				'affect_on_change_rule' => 'color',
				'section'               => 'styling',
				'tab'                   => __( 'Textbox / Textarea', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Focused: BG Color', 'lcproext' ),
				'id'                    => 'css_inputs_focus_bg_color',
				'std'                   => '', // 'std' => '#fff',
				'type'                  => 'color',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'input[type=text]:focus,input[type=email]:focus,textarea:focus,input[type=password]:focus,input[type=number]:focus,input[type=tel]:focus,input[type=url]:focus,input[type=date]:focus',
				'affect_on_change_rule' => 'background-color',
				'section'               => 'styling',
				'tab'                   => __( 'Textbox / Textarea', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Focused: Border Color', 'lcproext' ),
				'id'                    => 'css_inputs_focus_border_color',
				'std'                   => '', // 'std' => '#eee',
				'type'                  => 'color',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'input[type=text]:focus,input[type=email]:focus,textarea:focus,input[type=password]:focus,input[type=number]:focus,input[type=tel]:focus,input[type=url]:focus,input[type=date]:focus',
				'affect_on_change_rule' => 'border-color',
				'section'               => 'styling',
				'tab'                   => __( 'Textbox / Textarea', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Focused: Text Color', 'lcproext' ),
				'id'                    => 'css_inputs_focus_txt_color',
				'std'                   => '', // 'std' => '#eee',
				'type'                  => 'color',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'input[type=text]:focus,input[type=email]:focus,textarea:focus,input[type=password]:focus,input[type=number]:focus,input[type=tel]:focus,input[type=url]:focus,input[type=date]:focus',
				'affect_on_change_rule' => 'color',
				'section'               => 'styling',
				'tab'                   => __( 'Textbox / Textarea', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Border Width', 'lcproext' ),
				'id'                    => 'css_inputs_border_width',
				'std'                   => '', // 'std' => '1',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'input[type=text],input[type=email],textarea,input[type=password],input[type=number], input[type=tel],input[type=url],input[type=date]',
				'affect_on_change_rule' => 'border-width',
				'section'               => 'styling',
				'ext'                   => 'px',
				'tab'                   => __( 'Textbox / Textarea', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Borders', 'lcproext' ),
				'id'                    => 'css_inputs_border_trbl',
				'std'                   => '', // 'std' => 'top right bottom left',
				'type'                  => 'checkbox',
				'choices'               => array(
					array(
						'label' => __( 'Top', 'lcproext' ),
						'value' => 'top',
					),
					array(
						'label' => __( 'Right', 'lcproext' ),
						'value' => 'right',
					),
					array(
						'label' => __( 'Bottom', 'lcproext' ),
						'value' => 'bottom',
					),
					array(
						'label' => __( 'Left', 'lcproext' ),
						'value' => 'left',
					),
				),
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'input[type=text],input[type=email],textarea,input[type=password],input[type=number], input[type=tel],input[type=url],input[type=date]',
				'affect_on_change_rule' => 'border-style',
				'section'               => 'styling',
				'tab'                   => __( 'Textbox / Textarea', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Border Radius', 'lcproext' ),
				'id'                    => 'css_inputs_border_radius',
				'std'                   => '', // 'std' => '4',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'input[type=text],input[type=email],textarea,input[type=password],input[type=number], input[type=tel],input[type=url],input[type=date]',
				'affect_on_change_rule' => 'border-radius',
				'section'               => 'styling',
				'ext'                   => 'px',
				'tab'                   => __( 'Textbox / Textarea', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Font Size', 'lcproext' ),
				'id'                    => 'css_inputs_font_size',
				'std'                   => '', // 'std' => '13',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'input[type=text],input[type=email],textarea,input[type=password],input[type=number], input[type=tel],input[type=url],input[type=date]',
				'affect_on_change_rule' => 'font-size',
				'section'               => 'styling',
				'tab'                   => __( 'Textbox / Textarea', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Font Weight', 'lcproext' ),
				'id'                    => 'css_inputs_font_weight',
				'std'                   => '', // 'std' => '500',
				'type' 					=> 'select',
				'choices' => array(
					array(
						'label' => '100 - Thin',
						'value' => '100',
					),
					array(
						'label' => '200 - Extra Light',
						'value' => '200',
					),
					array(
						'label' => '300 - Light',
						'value' => '300',
					),
					array(
						'label' => '400 - Normal',
						'value' => '400',
					),
					array(
						'label' => '500 - Medium',
						'value' => '500',
					),
					array(
						'label' => '600 - Semi Bold',
						'value' => '600',
					),
					array(
						'label' => '700 - Bold',
						'value' => '700',
					),
					array(
						'label' => '800 - Extra Bold',
						'value' => '800',
					),
					array(
						'label' => '900 - Black',
						'value' => '900',
					),
				),
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'input[type=text],input[type=email],textarea,input[type=password],input[type=number], input[type=tel],input[type=url],input[type=date]',
				'affect_on_change_rule' => 'font-weight',
				'section'               => 'styling',
				'tab'                   => __( 'Textbox / Textarea', 'lcproext' ),
				'ext'                   => '',
			),
			array(
				'label'                 => __( 'Font Family', 'lcproext' ),
				'id'                    => 'css_inputs_font_family',
				'std'                   => '',
				'type'                  => 'font',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'input[type=text],input[type=email],textarea,input[type=password],input[type=number], input[type=tel],input[type=url],input[type=date]',
				'affect_on_change_rule' => 'font-family',
				'section'               => 'styling',
				'tab'                   => __( 'Textbox / Textarea', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Line Height Input', 'lcproext' ),
				'id'                    => 'css_inputs_line_height',
				'std'                   => '', // 'std' => '23',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'input[type=text],input[type=email],input[type=password],input[type=number], input[type=tel],input[type=url]',
				'affect_on_change_rule' => 'line-height',
				'section'               => 'styling',
				'tab'                   => __( 'Textbox / Textarea', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Line Height Textarea', 'lcproext' ),
				'id'                    => 'css_inputs_line_height',
				'std'                   => '', // 'std' => '23',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'textarea',
				'affect_on_change_rule' => 'line-height',
				'section'               => 'styling',
				'tab'                   => __( 'Textbox / Textarea', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Min-Height Textarea', 'lcproext' ),
				'id'                    => 'css_textarea_min_height',
				'std'                   => '', // 'std' => '100',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'textarea',
				'affect_on_change_rule' => 'height',
				'ext'                   => 'px',
				'min'                   => 0,
				'max'                   => 500,
				'section'               => 'styling',
				'tab'                   => __( 'Textbox / Textarea', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Margin Bottom', 'lcproext' ),
				'id'                    => 'css_inputs_margin_bottom',
				'std'                   => '', // 'std' => '15',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'input[type=text],input[type=email],textarea,input[type=password],input[type=number], input[type=tel], input[type=url],input[type=date]',
				'affect_on_change_rule' => 'margin-bottom',
				'section'               => 'styling',
				'ext'                   => 'px',
				'tab'                   => __( 'Textbox / Textarea', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Padding Vertical', 'lcproext' ),
				'id'                    => 'css_inputs_padding_vertical',
				'std'                   => '', // 'std' => '10',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'input[type=text],input[type=email],textarea,input[type=password],input[type=number], input[type=tel], input[type=url], input[type=date]',
				'affect_on_change_rule' => 'padding-top,padding-bottom',
				'section'               => 'styling',
				'ext'                   => 'px',
				'tab'                   => __( 'Textbox / Textarea', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Padding Horizontal', 'lcproext' ),
				'id'                    => 'css_inputs_padding_horizontal',
				'std'                   => '', // 'std' => '15',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'input[type=text],input[type=email],textarea,input[type=password],input[type=number], input[type=tel], input[type=url], input[type=date]',
				'affect_on_change_rule' => 'padding-left,padding-right',
				'section'               => 'styling',
				'ext'                   => 'px',
				'tab'                   => __( 'Textbox / Textarea', 'lcproext' ),
			),

			/**
			 * Selectors
			 */

			array(
				'label'                 => __( 'Color', 'lcproext' ),
				'id'                    => 'css_checkbox_labels_color',
				'std'                   => '',
				'type'                  => 'color',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-list-item-label',
				'affect_on_change_rule' => 'color',
				'section'               => 'styling',
				'tab'                   => __( 'List > Radio / Checkboxes', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Font Size', 'lcproext' ),
				'id'                    => 'css_checkbox_labels_font_size',
				'std'                   => '', // 'std' => '13',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-list-item-label',
				'affect_on_change_rule' => 'font-size',
				'section'               => 'styling',
				'tab'                   => __( 'List > Radio / Checkboxes', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Font Weight', 'lcproext' ),
				'id'                    => 'css_checkbox_labels_font_weight',
				'std'                   => '',
				'type' 					=> 'select',
				'choices' => array(
					array(
						'label' => '100 - Thin',
						'value' => '100',
					),
					array(
						'label' => '200 - Extra Light',
						'value' => '200',
					),
					array(
						'label' => '300 - Light',
						'value' => '300',
					),
					array(
						'label' => '400 - Normal',
						'value' => '400',
					),
					array(
						'label' => '500 - Medium',
						'value' => '500',
					),
					array(
						'label' => '600 - Semi Bold',
						'value' => '600',
					),
					array(
						'label' => '700 - Bold',
						'value' => '700',
					),
					array(
						'label' => '800 - Extra Bold',
						'value' => '800',
					),
					array(
						'label' => '900 - Black',
						'value' => '900',
					),
				),
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-list-item-label',
				'affect_on_change_rule' => 'font-weight',
				'section'               => 'styling',
				'tab'                   => __( 'List > Radio / Checkboxes', 'lcproext' ),
				'ext'                   => '',
			),
			array(
				'label'                 => __( 'Font Family', 'lcproext' ),
				'id'                    => 'css_checkbox_labels_font_family',
				'std'                   => '',
				'type'                  => 'font',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-list-item-label',
				'affect_on_change_rule' => 'font-family',
				'section'               => 'styling',
				'tab'                   => __( 'List > Radio / Checkboxes', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Line Height', 'lcproext' ),
				'id'                    => 'css_checkbox_labels_line_height',
				'std'                   => '', // 'std' => '23',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-list-item-label',
				'affect_on_change_rule' => 'line-height',
				'section'               => 'styling',
				'tab'                   => __( 'List > Radio / Checkboxes', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Input Margin Right', 'lcproext' ),
				'id'                    => 'css_checkbox_input_margin_right',
				'std'                   => '', // 'std' => '0',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => ".wpcf7-list-item-label",
				'affect_on_change_rule' => 'margin-right',
				'section'               => 'styling',
				'tab'                   => __( 'List > Radio / Checkboxes', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Padding Vertical', 'lcproext' ),
				'id'                    => 'css_checkbox_labels_padding_vertical',
				'std'                   => '', // 'std' => '0',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-list-item',
				'affect_on_change_rule' => 'padding-top,padding-bottom',
				'section'               => 'styling',
				'ext'                   => 'px',
				'tab'                   => __( 'List > Radio / Checkboxes', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Padding Horizontal', 'lcproext' ),
				'id'                    => 'css_checkbox_labels_padding_horizontal',
				'std'                   => '', // 'std' => '0',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-list-item',
				'affect_on_change_rule' => 'padding-left,padding-right',
				'section'               => 'styling',
				'ext'                   => 'px',
				'tab'                   => __( 'List > Radio / Checkboxes', 'lcproext' ),
			),

			/**
			 * Select
			 */

			array(
				'label'                 => __( 'BG Color', 'lcproext' ),
				'id'                    => 'css_select_bg_color',
				'std'                   => '', // 'std' => '#fff',
				'type'                  => 'color',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'select',
				'affect_on_change_rule' => 'background-color',
				'section'               => 'styling',
				'tab'                   => __( 'List > Dropdown', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Border Color', 'lcproext' ),
				'id'                    => 'css_select_border_color',
				'std'                   => '', // 'std' => '#ddd',
				'type'                  => 'color',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'select',
				'affect_on_change_rule' => 'border-color',
				'section'               => 'styling',
				'tab'                   => __( 'List > Dropdown', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Focused: BG Color', 'lcproext' ),
				'id'                    => 'css_select_focus_bg_color',
				'std'                   => '', // 'std' => '#fff',
				'type'                  => 'color',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'select:focus',
				'affect_on_change_rule' => 'background-color',
				'section'               => 'styling',
				'tab'                   => __( 'List > Dropdown', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Focused: Border Color', 'lcproext' ),
				'id'                    => 'css_select_focus_border_color',
				'std'                   => '', // 'std' => '#eee',
				'type'                  => 'color',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'select:focus',
				'affect_on_change_rule' => 'border-color',
				'section'               => 'styling',
				'tab'                   => __( 'List > Dropdown', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Focused: Text Color', 'lcproext' ),
				'id'                    => 'css_select_focus_txt_color',
				'std'                   => '', // 'std' => '#fff',
				'type'                  => 'color',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'select:focus',
				'affect_on_change_rule' => 'color',
				'section'               => 'styling',
				'tab'                   => __( 'List > Dropdown', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Border Width', 'lcproext' ),
				'id'                    => 'css_select_border_width',
				'std'                   => '', // 'std' => '1',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'select',
				'affect_on_change_rule' => 'border-width',
				'section'               => 'styling',
				'ext'                   => 'px',
				'tab'                   => __( 'List > Dropdown', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Borders', 'lcproext' ),
				'id'                    => 'css_select_border_trbl',
				'std'                   => '', // 'std' => 'top right bottom left',
				'type'                  => 'checkbox',
				'choices'               => array(
					array(
						'label' => __( 'Top', 'lcproext' ),
						'value' => 'top',
					),
					array(
						'label' => __( 'Right', 'lcproext' ),
						'value' => 'right',
					),
					array(
						'label' => __( 'Bottom', 'lcproext' ),
						'value' => 'bottom',
					),
					array(
						'label' => __( 'Left', 'lcproext' ),
						'value' => 'left',
					),
				),
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'select',
				'affect_on_change_rule' => 'border-style',
				'section'               => 'styling',
				'tab'                   => __( 'List > Dropdown', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Border Radius', 'lcproext' ),
				'id'                    => 'css_select_border_radius',
				'std'                   => '', // 'std' => '0',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'select',
				'affect_on_change_rule' => 'border-radius',
				'section'               => 'styling',
				'ext'                   => 'px',
				'tab'                   => __( 'List > Dropdown', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Color', 'lcproext' ),
				'id'                    => 'css_select_color',
				'std'                   => '', // 'std' => '#4d4d4d',
				'type'                  => 'color',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'select',
				'affect_on_change_rule' => 'color',
				'section'               => 'styling',
				'tab'                   => __( 'List > Dropdown', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Font Size', 'lcproext' ),
				'id'                    => 'css_select_font_size',
				'std'                   => '', // 'std' => '13',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'select',
				'affect_on_change_rule' => 'font-size',
				'section'               => 'styling',
				'tab'                   => __( 'List > Dropdown', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Font Weight', 'lcproext' ),
				'id'                    => 'css_select_font_weight',
				'std'                   => '', // 'std' => '500',
				'type' 					=> 'select',
				'choices' => array(
					array(
						'label' => '100 - Thin',
						'value' => '100',
					),
					array(
						'label' => '200 - Extra Light',
						'value' => '200',
					),
					array(
						'label' => '300 - Light',
						'value' => '300',
					),
					array(
						'label' => '400 - Normal',
						'value' => '400',
					),
					array(
						'label' => '500 - Medium',
						'value' => '500',
					),
					array(
						'label' => '600 - Semi Bold',
						'value' => '600',
					),
					array(
						'label' => '700 - Bold',
						'value' => '700',
					),
					array(
						'label' => '800 - Extra Bold',
						'value' => '800',
					),
					array(
						'label' => '900 - Black',
						'value' => '900',
					),
				),
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'select',
				'affect_on_change_rule' => 'font-weight',
				'section'               => 'styling',
				'tab'                   => __( 'List > Dropdown', 'lcproext' ),
				'ext'                   => '',
			),
			array(
				'label'                 => __( 'Font Family', 'lcproext' ),
				'id'                    => 'css_select_font_family',
				'std'                   => '',
				'type'                  => 'font',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'select',
				'affect_on_change_rule' => 'font-family',
				'section'               => 'styling',
				'tab'                   => __( 'List > Dropdown', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Line Height Input', 'lcproext' ),
				'id'                    => 'css_select_line_height',
				'std'                   => '', // 'std' => '23',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'select',
				'affect_on_change_rule' => 'line-height',
				'section'               => 'styling',
				'tab'                   => __( 'List > Dropdown', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Margin Bottom', 'lcproext' ),
				'id'                    => 'css_select_margin_bottom',
				'std'                   => '', // 'std' => '15',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'select',
				'affect_on_change_rule' => 'margin-bottom',
				'section'               => 'styling',
				'ext'                   => 'px',
				'tab'                   => __( 'List > Dropdown', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Padding Vertical', 'lcproext' ),
				'id'                    => 'css_select_padding_vertical',
				'std'                   => '', // 'std' => '10',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'select',
				'affect_on_change_rule' => 'padding-top,padding-bottom',
				'section'               => 'styling',
				'ext'                   => 'px',
				'tab'                   => __( 'List > Dropdown', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Padding Horizontal', 'lcproext' ),
				'id'                    => 'css_select_padding_horizontal',
				'std'                   => '', // 'std' => '15',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'select',
				'affect_on_change_rule' => 'padding-left,padding-right',
				'section'               => 'styling',
				'ext'                   => 'px',
				'tab'                   => __( 'List > Dropdown', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Width', 'lcproext' ),
				'id'                    => 'css_select_width',
				'std'                   => '',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'select',
				'affect_on_change_rule' => 'width',
				'section'               => 'styling',
				'ext'                   => '%',
				'tab'                   => __( 'List > Dropdown', 'lcproext' ),
			),

			/**
			 * Submit Button
			 */

			array(
				'label'                 => __( 'BG Color', 'lcproext' ),
				'id'                    => 'css_button_bg_color',
				'std'                   => '', // 'std' => '#5890e5',
				'type'                  => 'color',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'input[type=submit], button, input[type=button]',
				'affect_on_change_rule' => 'background-color',
				'section'               => 'styling',
				'tab'                   => __( 'Submit', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Border Color', 'lcproext' ),
				'id'                    => 'css_button_border_color',
				'std'                   => '', // 'std' => '#5890e5',
				'type'                  => 'color',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'input[type=submit], button, input[type=button]',
				'affect_on_change_rule' => 'border-color',
				'section'               => 'styling',
				'tab'                   => __( 'Submit', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Text Color', 'lcproext' ),
				'id'                    => 'css_button_color',
				'std'                   => '', // 'std' => '#fff',
				'type'                  => 'color',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'input[type=submit], button, input[type=button]',
				'affect_on_change_rule' => 'color',
				'section'               => 'styling',
				'tab'                   => __( 'Submit', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Hover: BG Color', 'lcproext' ),
				'id'                    => 'css_button_bg_color_hover',
				'std'                   => '', // 'std' => '#5890e5',
				'type'                  => 'color',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'input[type=submit]:hover, button:hover',
				'affect_on_change_rule' => 'background-color',
				'section'               => 'styling',
				'tab'                   => __( 'Submit', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Hover: Border Color', 'lcproext' ),
				'id'                    => 'css_button_border_color_hover',
				'std'                   => '', // 'std' => '#5890e5',
				'type'                  => 'color',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'input[type=submit]:hover, button:hover',
				'affect_on_change_rule' => 'border-color',
				'section'               => 'styling',
				'tab'                   => __( 'Submit', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Hover: Text Color', 'lcproext' ),
				'id'                    => 'css_button_color_hover',
				'std'                   => '', // 'std' => '#fff',
				'type'                  => 'color',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'input[type=submit]:hover, button:hover',
				'affect_on_change_rule' => 'color',
				'section'               => 'styling',
				'tab'                   => __( 'Submit', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Border Width', 'lcproext' ),
				'id'                    => 'css_button_border_width',
				'std'                   => '', // 'std' => '0',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'input[type=submit], button, input[type=button]',
				'affect_on_change_rule' => 'border-width',
				'section'               => 'styling',
				'ext'                   => 'px',
				'tab'                   => __( 'Submit', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Borders', 'lcproext' ),
				'id'                    => 'css_button_border_trbl',
				'std'                   => '', // 'std' => 'top right bottom left',
				'type'                  => 'checkbox',
				'choices'               => array(
					array(
						'label' => __( 'Top', 'lcproext' ),
						'value' => 'top',
					),
					array(
						'label' => __( 'Right', 'lcproext' ),
						'value' => 'right',
					),
					array(
						'label' => __( 'Bottom', 'lcproext' ),
						'value' => 'bottom',
					),
					array(
						'label' => __( 'Left', 'lcproext' ),
						'value' => 'left',
					),
				),
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'input[type=submit], button, input[type=button]',
				'affect_on_change_rule' => 'border-style',
				'section'               => 'styling',
				'tab'                   => __( 'Submit', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Border Radius', 'lcproext' ),
				'id'                    => 'css_button_border_radius',
				'std'                   => '', // 'std' => '3',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'input[type=submit], button, input[type=button]',
				'affect_on_change_rule' => 'border-radius',
				'section'               => 'styling',
				'ext'                   => 'px',
				'tab'                   => __( 'Submit', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Font Size', 'lcproext' ),
				'id'                    => 'css_button_font_size',
				'std'                   => '', // 'std' => '16',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'input[type=submit], button, input[type=button]',
				'affect_on_change_rule' => 'font-size',
				'section'               => 'styling',
				'tab'                   => __( 'Submit', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Font Weight', 'lcproext' ),
				'id'                    => 'css_button_font_weight',
				'std'                   => '', // 'std' => '300',
				'type' 					=> 'select',
				'choices' => array(
					array(
						'label' => '100 - Thin',
						'value' => '100',
					),
					array(
						'label' => '200 - Extra Light',
						'value' => '200',
					),
					array(
						'label' => '300 - Light',
						'value' => '300',
					),
					array(
						'label' => '400 - Normal',
						'value' => '400',
					),
					array(
						'label' => '500 - Medium',
						'value' => '500',
					),
					array(
						'label' => '600 - Semi Bold',
						'value' => '600',
					),
					array(
						'label' => '700 - Bold',
						'value' => '700',
					),
					array(
						'label' => '800 - Extra Bold',
						'value' => '800',
					),
					array(
						'label' => '900 - Black',
						'value' => '900',
					),
				),
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'input[type=submit], button, input[type=button]',
				'affect_on_change_rule' => 'font-weight',
				'section'               => 'styling',
				'tab'                   => __( 'Submit', 'lcproext' ),
				'ext'                   => '',
			),
			array(
				'label'                 => __( 'Font Family', 'lcproext' ),
				'id'                    => 'css_button_font_family',
				'std'                   => '',
				'type'                  => 'font',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'input[type=submit], button, input[type=button]',
				'affect_on_change_rule' => 'font-family',
				'section'               => 'styling',
				'tab'                   => __( 'Submit', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Line Height', 'lcproext' ),
				'id'                    => 'css_button_line_height',
				'std'                   => '', // 'std' => '21',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'input[type=submit], button, input[type=button]',
				'affect_on_change_rule' => 'line-height',
				'section'               => 'styling',
				'tab'                   => __( 'Submit', 'lcproext' ),
				'ext'                   => 'px',
			),

			array(
				'label' => __( 'Text Transform', 'lcproext' ),
				'id' => 'css_button_text_transform',
				'std' => 'none',
				'type' => 'select',
				'choices' => array(
					array(
						'label' => __( 'None', 'lcproext' ),
						'value' => 'none',
					),
					array(
						'label' => __( 'Capitalize', 'lcproext' ),
						'value' => 'capitalize',
					),
					array(
						'label' => __( 'Uppercase', 'lcproext' ),
						'value' => 'uppercase',
					),
					array(
						'label' => __( 'Lowercase', 'lcproext' ),
						'value' => 'lowercase',
					),
				),
				'refresh_on_change' => false,
				'affect_on_change_el'   => 'input[type=submit], button, input[type=button]',
				'affect_on_change_rule' => 'text-transform',
				'section' => 'styling',
				'tab'                   => __( 'Submit', 'lcproext' ),
			),
			array(
				'label' => __( 'Letter Spacing', 'lcproext' ),
				'id' => 'css_button_letter_spacing',
				'max' => 30,
				'std' => '0',
				'type' => 'slider',
				'refresh_on_change' => false,
				'affect_on_change_el'   => 'input[type=submit], button, input[type=button]',
				'affect_on_change_rule' => 'letter-spacing',
				'section' => 'styling',
				'tab'                   => __( 'Submit', 'lcproext' ),
				'ext' => 'px',
				'min' => -50,
				'max' => 50,
			),

			array(
				'label'                 => __( 'Padding Vertical', 'lcproext' ),
				'id'                    => 'css_button_padding_vertical',
				'std'                   => '', // 'std' => '14',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'input[type=submit], button, input[type=button]',
				'affect_on_change_rule' => 'padding-top,padding-bottom',
				'section'               => 'styling',
				'ext'                   => 'px',
				'tab'                   => __( 'Submit', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Padding Horizontal', 'lcproext' ),
				'id'                    => 'css_button_padding_horizontal',
				'std'                   => '', // 'std' => '18',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'input[type=submit], button, input[type=button]',
				'affect_on_change_rule' => 'padding-left,padding-right',
				'section'               => 'styling',
				'ext'                   => 'px',
				'tab'                   => __( 'Submit', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Margin Top', 'lcproext' ),
				'id'                    => 'css_button_margin_top',
				'std'                   => '', // 'std' => '20',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-submit',
				'affect_on_change_rule' => 'margin-top',
				'section'               => 'styling',
				'tab'                   => __( 'Submit', 'lcproext' ),
				'ext'                   => 'px',
				'min'                   => -50,
				'max'                   => 50,
				'increment'             => 1,
			),
			array(
				'label' => __( 'Button - Width', 'lcproext' ),
				'id' => 'css_button_width',
				'std' => 'auto',
				'type' => 'select',
				'choices' => array(
					array(
						'label' => __( 'Auto', 'lcproext' ),
						'value' => 'auto',
					),
					array(
						'label' => __( 'Full Width', 'lcproext' ),
						'value' => '100%',
					),
				),
				'refresh_on_change' => false,
				'affect_on_change_el'   => '.wpcf7-submit',
				'affect_on_change_rule' => 'width',
				'section' => 'styling',
				'tab' => __( 'Submit', 'lcproext' ),
			),
			/* array(
				'label' => __( 'Align', 'lcproext' ),
				'id' => 'css_button_align',
				'std' => 'none',
				'type' => 'text_align',
				'refresh_on_change' => false,
				'affect_on_change_el'   => '.wpcf7-submit',
				'affect_on_change_rule' => 'text-align',
				'section' => 'styling',
				'tab' => __( 'Submit', 'lcproext' ),
			), */

			/**
			 * Field > Required
			 */

			array(
				'label'                 => __( 'Color', 'lcproext' ),
				'id'                    => 'css_required_color',
				'std'                   => '',
				'type'                  => 'color',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-not-valid-tip',
				'affect_on_change_rule' => 'color',
				'section'               => 'styling',
				'tab'                   => __( 'Field > Required', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Font Size', 'lcproext' ),
				'id'                    => 'css_required_font_size',
				'std'                   => '', // 'std' => '14',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-not-valid-tip',
				'affect_on_change_rule' => 'font-size',
				'section'               => 'styling',
				'tab'                   => __( 'Field > Required', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Font Weight', 'lcproext' ),
				'id'                    => 'css_required_font_weight',
				'std'                   => '', // 'std' => '300',
				'type' 					=> 'select',
				'choices' => array(
					array(
						'label' => '100 - Thin',
						'value' => '100',
					),
					array(
						'label' => '200 - Extra Light',
						'value' => '200',
					),
					array(
						'label' => '300 - Light',
						'value' => '300',
					),
					array(
						'label' => '400 - Normal',
						'value' => '400',
					),
					array(
						'label' => '500 - Medium',
						'value' => '500',
					),
					array(
						'label' => '600 - Semi Bold',
						'value' => '600',
					),
					array(
						'label' => '700 - Bold',
						'value' => '700',
					),
					array(
						'label' => '800 - Extra Bold',
						'value' => '800',
					),
					array(
						'label' => '900 - Black',
						'value' => '900',
					),
				),
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-not-valid-tip',
				'affect_on_change_rule' => 'font-weight',
				'section'               => 'styling',
				'tab'                   => __( 'Field > Required', 'lcproext' ),
				'ext'                   => '',
			),
			array(
				'label'                 => __( 'Font Family', 'lcproext' ),
				'id'                    => 'css_required_font_family',
				'std'                   => '',
				'type'                  => 'font',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-not-valid-tip',
				'affect_on_change_rule' => 'font-family',
				'section'               => 'styling',
				'tab'                   => __( 'Field > Required', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Line Height', 'lcproext' ),
				'id'                    => 'css_required_line_height',
				'std'                   => '', // 'std' => '21',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-not-valid-tip',
				'affect_on_change_rule' => 'line-height',
				'section'               => 'styling',
				'tab'                   => __( 'Field > Required', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Margin Bottom', 'lcproext' ),
				'id'                    => 'css_required_margin_bottom',
				'std'                   => '', // 'std' => '20',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-not-valid-tip',
				'affect_on_change_rule' => 'margin-bottom',
				'section'               => 'styling',
				'tab'                   => __( 'Field > Required', 'lcproext' ),
				'ext'                   => 'px',
			),

			/**
			 * Form Error Message
			 */

			array(
				'label'                 => __( ' BG Color', 'lcproext' ),
				'id'                    => 'css_form_error_msg_bg_color',
				'std'                   => '',
				'type'                  => 'color',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-validation-errors',
				'affect_on_change_rule' => 'background-color',
				'section'               => 'styling',
				'tab'                   => __( 'Form Message > Error', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Border Color', 'lcproext' ),
				'id'                    => 'css_form_error_msg_border_color',
				'std'                   => '',
				'type'                  => 'color',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-validation-errors',
				'affect_on_change_rule' => 'border-color',
				'section'               => 'styling',
				'tab'                   => __( 'Form Message > Error', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Border Width', 'lcproext' ),
				'id'                    => 'css_form_error_msg_border_width',
				'std'                   => '', // 'std' => '0',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-validation-errors',
				'affect_on_change_rule' => 'border-width',
				'section'               => 'styling',
				'ext'                   => 'px',
				'tab'                   => __( 'Form Message > Error', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Borders', 'lcproext' ),
				'id'                    => 'css_form_error_msg_border_trbl',
				'std'                   => '', // 'std' => 'top right bottom left',
				'type'                  => 'checkbox',
				'choices'               => array(
					array(
						'label' => __( 'Top', 'lcproext' ),
						'value' => 'top',
					),
					array(
						'label' => __( 'Right', 'lcproext' ),
						'value' => 'right',
					),
					array(
						'label' => __( 'Bottom', 'lcproext' ),
						'value' => 'bottom',
					),
					array(
						'label' => __( 'Left', 'lcproext' ),
						'value' => 'left',
					),
				),
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-validation-errors',
				'affect_on_change_rule' => 'border-style',
				'section'               => 'styling',
				'tab'                   => __( 'Form Message > Error', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Border Radius - Top', 'lcproext' ),
				'id'                    => 'css_form_error_msg_border_radius_top',
				'std'                   => '', // 'std' => '0',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-validation-errors',
				'affect_on_change_rule' => 'border-top-left-radius,border-top-right-radius',
				'section'               => 'styling',
				'ext'                   => 'px',
				'tab'                   => __( 'Form Message > Error', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Border Radius - Bottom', 'lcproext' ),
				'id'                    => 'css_form_error_msg_border_radius_bottom',
				'std'                   => '', // 'std' => '0',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-validation-errors',
				'affect_on_change_rule' => 'border-bottom-left-radius,border-bottom-right-radius',
				'section'               => 'styling',
				'ext'                   => 'px',
				'tab'                   => __( 'Form Message > Error', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Text Color', 'lcproext' ),
				'id'                    => 'css_form_error_msg_color',
				'std'                   => 'rgb(65, 72, 77)',
				'type'                  => 'color',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-validation-errors',
				'affect_on_change_rule' => 'color',
				'section'               => 'styling',
				'tab'                   => __( 'Form Message > Error', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Font Size', 'lcproext' ),
				'id'                    => 'css_form_error_msg_font_size',
				'std'                   => '', // 'std' => '13',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-validation-errors',
				'affect_on_change_rule' => 'font-size',
				'section'               => 'styling',
				'tab'                   => __( 'Form Message > Error', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Font Weight', 'lcproext' ),
				'id'                    => 'css_form_error_msg_font_weight',
				'std'                   => '', // 'std' => '400',
				'type' 					=> 'select',
				'choices' => array(
					array(
						'label' => '100 - Thin',
						'value' => '100',
					),
					array(
						'label' => '200 - Extra Light',
						'value' => '200',
					),
					array(
						'label' => '300 - Light',
						'value' => '300',
					),
					array(
						'label' => '400 - Normal',
						'value' => '400',
					),
					array(
						'label' => '500 - Medium',
						'value' => '500',
					),
					array(
						'label' => '600 - Semi Bold',
						'value' => '600',
					),
					array(
						'label' => '700 - Bold',
						'value' => '700',
					),
					array(
						'label' => '800 - Extra Bold',
						'value' => '800',
					),
					array(
						'label' => '900 - Black',
						'value' => '900',
					),
				),
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-validation-errors',
				'affect_on_change_rule' => 'font-weight',
				'section'               => 'styling',
				'tab'                   => __( 'Form Message > Error', 'lcproext' ),
				'ext'                   => '',
			),
			array(
				'label'                 => __( 'Font Family', 'lcproext' ),
				'id'                    => 'css_form_error_msg_font_family',
				'std'                   => '',
				'type'                  => 'font',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-validation-errors',
				'affect_on_change_rule' => 'font-family',
				'section'               => 'styling',
				'tab'                   => __( 'Form Message > Error', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Line Height', 'lcproext' ),
				'id'                    => 'css_form_error_msg_line_height',
				'std'                   => '', // 'std' => '22',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-validation-errors',
				'affect_on_change_rule' => 'line-height',
				'section'               => 'styling',
				'tab'                   => __( 'Form Message > Error', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Margin Bottom', 'lcproext' ),
				'id'                    => 'css_form_error_msg_margin_bottom',
				'std'                   => '', // 'std' => '25',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-validation-errors',
				'affect_on_change_rule' => 'margin-bottom',
				'section'               => 'styling',
				'tab'                   => __( 'Form Message > Error', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Padding Vertical', 'lcproext' ),
				'id'                    => 'css_form_error_msg_padding_vertical',
				'std'                   => '', // 'std' => '10',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-validation-errors',
				'affect_on_change_rule' => 'padding-top,padding-bottom',
				'section'               => 'styling',
				'ext'                   => 'px',
				'tab'                   => __( 'Form Message > Error', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Padding Horizontal', 'lcproext' ),
				'id'                    => 'css_form_error_msg_padding_horizontal',
				'std'                   => '', // 'std' => '15',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-validation-errors',
				'affect_on_change_rule' => 'padding-left,padding-right',
				'section'               => 'styling',
				'ext'                   => 'px',
				'tab'                   => __( 'Form Message > Error', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Text Align', 'lcproext' ),
				'id'                    => 'css_form_error_msg_text_align',
				'std'                   => '', // 'std' => 'left',
				'type'                  => 'select',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-validation-errors',
				'affect_on_change_rule' => 'text-align',
				'section'               => 'styling',
				'tab'                   => __( 'Form Message > Error', 'lcproext' ),
				'choices'               => array(
					array(
						'label' => __( 'Left', 'lcproext' ),
						'value' => 'left',
					),
					array(
						'label' => __( 'Center', 'lcproext' ),
						'value' => 'center',
					),
					array(
						'label' => __( 'Right', 'lcproext' ),
						'value' => 'right',
					),
					array(
						'label' => __( 'Justify', 'lcproext' ),
						'value' => 'justify',
					),
				),
			),

			/**
			 * Form Success Message
			 */

			array(
				'label'                 => __( ' BG Color', 'lcproext' ),
				'id'                    => 'css_form_success_msg_bg_color',
				'std'                   => '',
				'type'                  => 'color',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-mail-sent-ok',
				'affect_on_change_rule' => 'background-color',
				'section'               => 'styling',
				'tab'                   => __( 'Form Message > Success', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Border Color', 'lcproext' ),
				'id'                    => 'css_form_success_msg_border_color',
				'std'                   => '',
				'type'                  => 'color',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-mail-sent-ok',
				'affect_on_change_rule' => 'border-color',
				'section'               => 'styling',
				'tab'                   => __( 'Form Message > Success', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Border Width', 'lcproext' ),
				'id'                    => 'css_form_success_msg_border_width',
				'std'                   => '', // 'std' => '0',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-mail-sent-ok',
				'affect_on_change_rule' => 'border-width',
				'section'               => 'styling',
				'ext'                   => 'px',
				'tab'                   => __( 'Form Message > Success', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Borders', 'lcproext' ),
				'id'                    => 'css_form_success_msg_border_trbl',
				'std'                   => '', // 'std' => 'top right bottom left',
				'type'                  => 'checkbox',
				'choices'               => array(
					array(
						'label' => __( 'Top', 'lcproext' ),
						'value' => 'top',
					),
					array(
						'label' => __( 'Right', 'lcproext' ),
						'value' => 'right',
					),
					array(
						'label' => __( 'Bottom', 'lcproext' ),
						'value' => 'bottom',
					),
					array(
						'label' => __( 'Left', 'lcproext' ),
						'value' => 'left',
					),
				),
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-mail-sent-ok',
				'affect_on_change_rule' => 'border-style',
				'section'               => 'styling',
				'tab'                   => __( 'Form Message > Success', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Border Radius - Top', 'lcproext' ),
				'id'                    => 'css_form_success_msg_border_radius_top',
				'std'                   => '', // 'std' => '0',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-mail-sent-ok',
				'affect_on_change_rule' => 'border-top-left-radius,border-top-right-radius',
				'section'               => 'styling',
				'ext'                   => 'px',
				'tab'                   => __( 'Form Message > Success', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Border Radius - Bottom', 'lcproext' ),
				'id'                    => 'css_form_success_msg_border_radius_bottom',
				'std'                   => '', // 'std' => '0',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-mail-sent-ok',
				'affect_on_change_rule' => 'border-bottom-left-radius,border-bottom-right-radius',
				'section'               => 'styling',
				'ext'                   => 'px',
				'tab'                   => __( 'Form Message > Success', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Text Color', 'lcproext' ),
				'id'                    => 'css_form_success_msg_color',
				'std'                   => '',
				'type'                  => 'color',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-mail-sent-ok',
				'affect_on_change_rule' => 'color',
				'section'               => 'styling',
				'tab'                   => __( 'Form Message > Success', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Font Size', 'lcproext' ),
				'id'                    => 'css_form_success_msg_font_size',
				'std'                   => '', // 'std' => '13',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-mail-sent-ok',
				'affect_on_change_rule' => 'font-size',
				'section'               => 'styling',
				'tab'                   => __( 'Form Message > Success', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Font Weight', 'lcproext' ),
				'id'                    => 'css_form_success_msg_font_weight',
				'std'                   => '', // 'std' => '400',
				'type' 					=> 'select',
				'choices' => array(
					array(
						'label' => '100 - Thin',
						'value' => '100',
					),
					array(
						'label' => '200 - Extra Light',
						'value' => '200',
					),
					array(
						'label' => '300 - Light',
						'value' => '300',
					),
					array(
						'label' => '400 - Normal',
						'value' => '400',
					),
					array(
						'label' => '500 - Medium',
						'value' => '500',
					),
					array(
						'label' => '600 - Semi Bold',
						'value' => '600',
					),
					array(
						'label' => '700 - Bold',
						'value' => '700',
					),
					array(
						'label' => '800 - Extra Bold',
						'value' => '800',
					),
					array(
						'label' => '900 - Black',
						'value' => '900',
					),
				),
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-mail-sent-ok',
				'affect_on_change_rule' => 'font-weight',
				'section'               => 'styling',
				'tab'                   => __( 'Form Message > Success', 'lcproext' ),
				'ext'                   => '',
			),
			array(
				'label'                 => __( 'Font Family', 'lcproext' ),
				'id'                    => 'css_form_success_msg_font_family',
				'std'                   => '',
				'type'                  => 'font',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-mail-sent-ok',
				'affect_on_change_rule' => 'font-family',
				'section'               => 'styling',
				'tab'                   => __( 'Form Message > Success', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Line Height', 'lcproext' ),
				'id'                    => 'css_form_success_msg_line_height',
				'std'                   => '', // 'std' => '22',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-mail-sent-ok',
				'affect_on_change_rule' => 'line-height',
				'section'               => 'styling',
				'tab'                   => __( 'Form Message > Success', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Padding Vertical', 'lcproext' ),
				'id'                    => 'css_form_success_msg_padding_vertical',
				'std'                   => '', // 'std' => '10',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-mail-sent-ok',
				'affect_on_change_rule' => 'padding-top,padding-bottom',
				'section'               => 'styling',
				'ext'                   => 'px',
				'tab'                   => __( 'Form Message > Success', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Padding Horizontal', 'lcproext' ),
				'id'                    => 'css_form_success_msg_padding_horizontal',
				'std'                   => '', // 'std' => '15',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-mail-sent-ok',
				'affect_on_change_rule' => 'padding-left,padding-right',
				'section'               => 'styling',
				'ext'                   => 'px',
				'tab'                   => __( 'Form Message > Success', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Text Align', 'lcproext' ),
				'id'                    => 'css_form_success_msg_text_align',
				'std'                   => '', // 'std' => 'left',
				'type'                  => 'select',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-mail-sent-ok',
				'affect_on_change_rule' => 'text-align',
				'section'               => 'styling',
				'tab'                   => __( 'Form Message > Success', 'lcproext' ),
				'choices'               => array(
					array(
						'label' => __( 'Left', 'lcproext' ),
						'value' => 'left',
					),
					array(
						'label' => __( 'Center', 'lcproext' ),
						'value' => 'center',
					),
					array(
						'label' => __( 'Right', 'lcproext' ),
						'value' => 'right',
					),
					array(
						'label' => __( 'Justify', 'lcproext' ),
						'value' => 'justify',
					),
				),
			),

			/**
			 * Responsive Tablet
			 */

			array(
				'label' => __( 'Responsive Styling', 'lcproext' ),
				'id' => 'css_res_t',
				'std' => 'disabled',
				'type' => 'select',
				'choices' => array(
					array(
						'label' => __( 'Disabled', 'lcproext' ),
						'value' => 'disabled',
					),
					array(
						'label' => __( 'Enabled', 'lcproext' ),
						'value' => 'enabled',
					),
				),
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Margin Bottom', 'lcproext' ),
				'id'                    => 'css_res_t_margin_bottom',
				'std'                   => '', // 'std' => '0',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7',
				'affect_on_change_rule' => 'margin-bottom',
				'section'               => 'responsive',
				'tab'                   => __( 'Tablet', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Padding Vertical', 'lcproext' ),
				'id'                    => 'css_res_t_main_padding_vertical',
				'std'                   => '', // 'std' => '0',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7',
				'affect_on_change_rule' => 'padding-top,padding-bottom',
				'section'               => 'responsive',
				'tab'                   => __( 'Tablet', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Padding Horizontal', 'lcproext' ),
				'id'                    => 'css_res_t_main_padding_horizontal',
				'std'                   => '', // 'std' => '0',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7',
				'affect_on_change_rule' => 'padding-left,padding-right',
				'section'               => 'responsive',
				'tab'                   => __( 'Tablet', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Label - Font Size', 'lcproext' ),
				'id'                    => 'css_res_t_labels_font_size',
				'std'                   => '', // 'std' => '16',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'label',
				'affect_on_change_rule' => 'font-size',
				'section'               => 'responsive',
				'tab'                   => __( 'Tablet', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Label - Line Height', 'lcproext' ),
				'id'                    => 'css_res_t_labels_line_height',
				'std'                   => '', // 'std' => '24',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'label',
				'affect_on_change_rule' => 'line-height',
				'section'               => 'responsive',
				'tab'                   => __( 'Tablet', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Textbox / Textarea - Font Size', 'lcproext' ),
				'id'                    => 'css_res_t_inputs_font_size',
				'std'                   => '', // 'std' => '13',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'input[type=text],input[type=email],textarea,input[type=password],input[type=number], input[type=tel],input[type=url],input[type=date]',
				'affect_on_change_rule' => 'font-size',
				'section'               => 'responsive',
				'tab'                   => __( 'Tablet', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Textbox / Textarea - Line Height Input', 'lcproext' ),
				'id'                    => 'css_res_t_inputs_line_height',
				'std'                   => '', // 'std' => '23',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'input[type=text],input[type=email],input[type=password],input[type=number], input[type=tel],input[type=url]',
				'affect_on_change_rule' => 'line-height',
				'section'               => 'responsive',
				'tab'                   => __( 'Tablet', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Textbox / Textarea - Line Height Textarea', 'lcproext' ),
				'id'                    => 'css_res_t_inputs_line_height',
				'std'                   => '', // 'std' => '23',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'textarea',
				'affect_on_change_rule' => 'line-height',
				'section'               => 'responsive',
				'tab'                   => __( 'Tablet', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Textbox / Textarea - Margin Bottom', 'lcproext' ),
				'id'                    => 'css_res_t_inputs_margin_bottom',
				'std'                   => '', // 'std' => '15',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'input[type=text],input[type=email],textarea,input[type=password],input[type=number], input[type=tel], input[type=url],input[type=date]',
				'affect_on_change_rule' => 'margin-bottom',
				'section'               => 'responsive',
				'ext'                   => 'px',
				'tab'                   => __( 'Tablet', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Textbox / Textarea - Padding Vertical', 'lcproext' ),
				'id'                    => 'css_res_t_inputs_padding_vertical',
				'std'                   => '', // 'std' => '10',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'input[type=text],input[type=email],textarea,input[type=password],input[type=number], input[type=tel], input[type=url], input[type=date]',
				'affect_on_change_rule' => 'padding-top,padding-bottom',
				'section'               => 'responsive',
				'ext'                   => 'px',
				'tab'                   => __( 'Tablet', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Textbox / Textarea - Padding Horizontal', 'lcproext' ),
				'id'                    => 'css_res_t_inputs_padding_horizontal',
				'std'                   => '', // 'std' => '15',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'input[type=text],input[type=email],textarea,input[type=password],input[type=number], input[type=tel], input[type=url], input[type=date]',
				'affect_on_change_rule' => 'padding-left,padding-right',
				'section'               => 'responsive',
				'ext'                   => 'px',
				'tab'                   => __( 'Tablet', 'lcproext' ),
			),
			array(
				'label'                 => __( 'List > Radio / Checkboxes - Font Size', 'lcproext' ),
				'id'                    => 'css_res_t_checkbox_labels_font_size',
				'std'                   => '', // 'std' => '13',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-list-item-label',
				'affect_on_change_rule' => 'font-size',
				'section'               => 'responsive',
				'tab'                   => __( 'Tablet', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'List > Radio / Checkboxes - Line Height', 'lcproext' ),
				'id'                    => 'css_res_t_checkbox_labels_line_height',
				'std'                   => '', // 'std' => '23',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-list-item-label',
				'affect_on_change_rule' => 'line-height',
				'section'               => 'responsive',
				'tab'                   => __( 'Tablet', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'List > Radio / Checkboxes - Padding Vertical', 'lcproext' ),
				'id'                    => 'css_res_t_checkbox_labels_padding_vertical',
				'std'                   => '', // 'std' => '0',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-list-item',
				'affect_on_change_rule' => 'padding-top,padding-bottom',
				'section'               => 'responsive',
				'ext'                   => 'px',
				'tab'                   => __( 'Tablet', 'lcproext' ),
			),
			array(
				'label'                 => __( 'List > Radio / Checkboxes - Padding Horizontal', 'lcproext' ),
				'id'                    => 'css_res_t_checkbox_labels_padding_horizontal',
				'std'                   => '', // 'std' => '0',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-list-item',
				'affect_on_change_rule' => 'padding-left,padding-right',
				'section'               => 'responsive',
				'ext'                   => 'px',
				'tab'                   => __( 'Tablet', 'lcproext' ),
			),
			array(
				'label'                 => __( 'List > Dropdown - Font Size', 'lcproext' ),
				'id'                    => 'css_res_t_select_font_size',
				'std'                   => '', // 'std' => '13',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'select',
				'affect_on_change_rule' => 'font-size',
				'section'               => 'responsive',
				'tab'                   => __( 'Tablet', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'List > Dropdown - Line Height Input', 'lcproext' ),
				'id'                    => 'css_res_t_select_line_height',
				'std'                   => '', // 'std' => '23',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'select',
				'affect_on_change_rule' => 'line-height',
				'section'               => 'responsive',
				'tab'                   => __( 'Tablet', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'List > Dropdown - Margin Bottom', 'lcproext' ),
				'id'                    => 'css_res_t_select_margin_bottom',
				'std'                   => '', // 'std' => '15',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'select',
				'affect_on_change_rule' => 'margin-bottom',
				'section'               => 'responsive',
				'ext'                   => 'px',
				'tab'                   => __( 'Tablet', 'lcproext' ),
			),
			array(
				'label'                 => __( 'List > Dropdown - Padding Vertical', 'lcproext' ),
				'id'                    => 'css_res_t_select_padding_vertical',
				'std'                   => '', // 'std' => '10',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'select',
				'affect_on_change_rule' => 'padding-top,padding-bottom',
				'section'               => 'responsive',
				'ext'                   => 'px',
				'tab'                   => __( 'Tablet', 'lcproext' ),
			),
			array(
				'label'                 => __( 'List > Dropdown - Padding Horizontal', 'lcproext' ),
				'id'                    => 'css_res_t_select_padding_horizontal',
				'std'                   => '', // 'std' => '15',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'select',
				'affect_on_change_rule' => 'padding-left,padding-right',
				'section'               => 'responsive',
				'ext'                   => 'px',
				'tab'                   => __( 'Tablet', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Submit - Font Size', 'lcproext' ),
				'id'                    => 'css_res_t_button_font_size',
				'std'                   => '', // 'std' => '16',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'input[type=submit], button, input[type=button]',
				'affect_on_change_rule' => 'font-size',
				'section'               => 'responsive',
				'tab'                   => __( 'Tablet', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Submit - Line Height', 'lcproext' ),
				'id'                    => 'css_res_t_button_line_height',
				'std'                   => '', // 'std' => '21',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'input[type=submit], button, input[type=button]',
				'affect_on_change_rule' => 'line-height',
				'section'               => 'responsive',
				'tab'                   => __( 'Tablet', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Submit - Padding Vertical', 'lcproext' ),
				'id'                    => 'css_res_t_button_padding_vertical',
				'std'                   => '', // 'std' => '14',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'input[type=submit], button, input[type=button]',
				'affect_on_change_rule' => 'padding-top,padding-bottom',
				'section'               => 'responsive',
				'ext'                   => 'px',
				'tab'                   => __( 'Tablet', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Submit - Padding Horizontal', 'lcproext' ),
				'id'                    => 'css_res_t_button_padding_horizontal',
				'std'                   => '', // 'std' => '18',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'input[type=submit], button, input[type=button]',
				'affect_on_change_rule' => 'padding-left,padding-right',
				'section'               => 'responsive',
				'ext'                   => 'px',
				'tab'                   => __( 'Tablet', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Submit - Margin Top', 'lcproext' ),
				'id'                    => 'css_res_t_button_margin_top',
				'std'                   => '', // 'std' => '20',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-submit',
				'affect_on_change_rule' => 'margin-top',
				'section'               => 'responsive',
				'tab'                   => __( 'Tablet', 'lcproext' ),
				'ext'                   => 'px',
				'min'                   => -50,
				'max'                   => 50,
				'increment'             => 1,
			),
			array(
				'label'                 => __( 'Field > Required - Font Size', 'lcproext' ),
				'id'                    => 'css_res_t_required_font_size',
				'std'                   => '', // 'std' => '14',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-not-valid-tip',
				'affect_on_change_rule' => 'font-size',
				'section'               => 'responsive',
				'tab'                   => __( 'Tablet', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Field > Required - Line Height', 'lcproext' ),
				'id'                    => 'css_res_t_required_line_height',
				'std'                   => '', // 'std' => '21',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-not-valid-tip',
				'affect_on_change_rule' => 'line-height',
				'section'               => 'responsive',
				'tab'                   => __( 'Tablet', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Field > Required - Margin Bottom', 'lcproext' ),
				'id'                    => 'css_res_t_required_margin_bottom',
				'std'                   => '', // 'std' => '20',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-not-valid-tip',
				'affect_on_change_rule' => 'margin-bottom',
				'section'               => 'responsive',
				'tab'                   => __( 'Tablet', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Form Message > Error - Font Size', 'lcproext' ),
				'id'                    => 'css_res_t_form_error_msg_font_size',
				'std'                   => '', // 'std' => '13',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-validation-errors',
				'affect_on_change_rule' => 'font-size',
				'section'               => 'responsive',
				'tab'                   => __( 'Tablet', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Form Message > Error - Line Height', 'lcproext' ),
				'id'                    => 'css_res_t_form_error_msg_line_height',
				'std'                   => '', // 'std' => '22',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-validation-errors',
				'affect_on_change_rule' => 'line-height',
				'section'               => 'responsive',
				'tab'                   => __( 'Tablet', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Form Message > Error - Margin Bottom', 'lcproext' ),
				'id'                    => 'css_res_t_form_error_msg_margin_bottom',
				'std'                   => '', // 'std' => '25',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-validation-errors',
				'affect_on_change_rule' => 'margin-bottom',
				'section'               => 'responsive',
				'tab'                   => __( 'Tablet', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Form Message > Error - Padding Vertical', 'lcproext' ),
				'id'                    => 'css_res_t_form_error_msg_padding_vertical',
				'std'                   => '', // 'std' => '10',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-validation-errors',
				'affect_on_change_rule' => 'padding-top,padding-bottom',
				'section'               => 'responsive',
				'ext'                   => 'px',
				'tab'                   => __( 'Tablet', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Form Message > Error - Padding Horizontal', 'lcproext' ),
				'id'                    => 'css_res_t_form_error_msg_padding_horizontal',
				'std'                   => '', // 'std' => '15',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-validation-errors',
				'affect_on_change_rule' => 'padding-left,padding-right',
				'section'               => 'responsive',
				'ext'                   => 'px',
				'tab'                   => __( 'Tablet', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Form Message > Error - Text Align', 'lcproext' ),
				'id'                    => 'css_res_t_form_error_msg_text_align',
				'std'                   => '', // 'std' => 'left',
				'type'                  => 'select',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-validation-errors',
				'affect_on_change_rule' => 'text-align',
				'section'               => 'responsive',
				'tab'                   => __( 'Tablet', 'lcproext' ),
				'choices'               => array(
					array(
						'label' => __( 'Left', 'lcproext' ),
						'value' => 'left',
					),
					array(
						'label' => __( 'Center', 'lcproext' ),
						'value' => 'center',
					),
					array(
						'label' => __( 'Right', 'lcproext' ),
						'value' => 'right',
					),
					array(
						'label' => __( 'Justify', 'lcproext' ),
						'value' => 'justify',
					),
				),
			),
			array(
				'label'                 => __( 'Form Message > Success - Font Size', 'lcproext' ),
				'id'                    => 'css_res_t_form_success_msg_font_size',
				'std'                   => '', // 'std' => '13',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-mail-sent-ok',
				'affect_on_change_rule' => 'font-size',
				'section'               => 'responsive',
				'tab'                   => __( 'Tablet', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Form Message > Success - Line Height', 'lcproext' ),
				'id'                    => 'css_res_t_form_success_msg_line_height',
				'std'                   => '', // 'std' => '22',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-mail-sent-ok',
				'affect_on_change_rule' => 'line-height',
				'section'               => 'responsive',
				'tab'                   => __( 'Tablet', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Form Message > Success - Padding Vertical', 'lcproext' ),
				'id'                    => 'css_res_t_form_success_msg_padding_vertical',
				'std'                   => '', // 'std' => '10',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-mail-sent-ok',
				'affect_on_change_rule' => 'padding-top,padding-bottom',
				'section'               => 'responsive',
				'ext'                   => 'px',
				'tab'                   => __( 'Tablet', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Form Message > Success - Padding Horizontal', 'lcproext' ),
				'id'                    => 'css_res_t_form_success_msg_padding_horizontal',
				'std'                   => '', // 'std' => '15',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-mail-sent-ok',
				'affect_on_change_rule' => 'padding-left,padding-right',
				'section'               => 'responsive',
				'ext'                   => 'px',
				'tab'                   => __( 'Tablet', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Form Message > Success - Text Align', 'lcproext' ),
				'id'                    => 'css_res_t_form_success_msg_text_align',
				'std'                   => '', // 'std' => 'left',
				'type'                  => 'select',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-mail-sent-ok',
				'affect_on_change_rule' => 'text-align',
				'section'               => 'responsive',
				'tab'                   => __( 'Tablet', 'lcproext' ),
				'choices'               => array(
					array(
						'label' => __( 'Left', 'lcproext' ),
						'value' => 'left',
					),
					array(
						'label' => __( 'Center', 'lcproext' ),
						'value' => 'center',
					),
					array(
						'label' => __( 'Right', 'lcproext' ),
						'value' => 'right',
					),
					array(
						'label' => __( 'Justify', 'lcproext' ),
						'value' => 'justify',
					),
				),
			),

			/**
			 * Responsive Phone
			 */
		
			array(
				'label' => __( 'Responsive Styling', 'lcproext' ),
				'id' => 'css_res_p',
				'std' => 'disabled',
				'type' => 'select',
				'choices' => array(
					array(
						'label' => __( 'Disabled', 'lcproext' ),
						'value' => 'disabled',
					),
					array(
						'label' => __( 'Enabled', 'lcproext' ),
						'value' => 'enabled',
					),
				),
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Margin Bottom', 'lcproext' ),
				'id'                    => 'css_res_p_margin_bottom',
				'std'                   => '', // 'std' => '0',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7',
				'affect_on_change_rule' => 'margin-bottom',
				'section'               => 'responsive',
				'tab'                   => __( 'Phone', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Padding Vertical', 'lcproext' ),
				'id'                    => 'css_res_p_main_padding_vertical',
				'std'                   => '', // 'std' => '0',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7',
				'affect_on_change_rule' => 'padding-top,padding-bottom',
				'section'               => 'responsive',
				'tab'                   => __( 'Phone', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Padding Horizontal', 'lcproext' ),
				'id'                    => 'css_res_p_main_padding_horizontal',
				'std'                   => '', // 'std' => '0',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7',
				'affect_on_change_rule' => 'padding-left,padding-right',
				'section'               => 'responsive',
				'tab'                   => __( 'Phone', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Label - Font Size', 'lcproext' ),
				'id'                    => 'css_res_p_labels_font_size',
				'std'                   => '', // 'std' => '16',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'label',
				'affect_on_change_rule' => 'font-size',
				'section'               => 'responsive',
				'tab'                   => __( 'Phone', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Label - Line Height', 'lcproext' ),
				'id'                    => 'css_res_p_labels_line_height',
				'std'                   => '', // 'std' => '24',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'label',
				'affect_on_change_rule' => 'line-height',
				'section'               => 'responsive',
				'tab'                   => __( 'Phone', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Textbox / Textarea - Font Size', 'lcproext' ),
				'id'                    => 'css_res_p_inputs_font_size',
				'std'                   => '', // 'std' => '13',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'input[type=text],input[type=email],textarea,input[type=password],input[type=number], input[type=tel],input[type=url],input[type=date]',
				'affect_on_change_rule' => 'font-size',
				'section'               => 'responsive',
				'tab'                   => __( 'Phone', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Textbox / Textarea - Line Height Input', 'lcproext' ),
				'id'                    => 'css_res_p_inputs_line_height',
				'std'                   => '', // 'std' => '23',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'input[type=text],input[type=email],input[type=password],input[type=number], input[type=tel],input[type=url]',
				'affect_on_change_rule' => 'line-height',
				'section'               => 'responsive',
				'tab'                   => __( 'Phone', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Textbox / Textarea - Line Height Textarea', 'lcproext' ),
				'id'                    => 'css_res_p_inputs_line_height',
				'std'                   => '', // 'std' => '23',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'textarea',
				'affect_on_change_rule' => 'line-height',
				'section'               => 'responsive',
				'tab'                   => __( 'Phone', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Textbox / Textarea - Margin Bottom', 'lcproext' ),
				'id'                    => 'css_res_p_inputs_margin_bottom',
				'std'                   => '', // 'std' => '15',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'input[type=text],input[type=email],textarea,input[type=password],input[type=number], input[type=tel], input[type=url],input[type=date]',
				'affect_on_change_rule' => 'margin-bottom',
				'section'               => 'responsive',
				'ext'                   => 'px',
				'tab'                   => __( 'Phone', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Textbox / Textarea - Padding Vertical', 'lcproext' ),
				'id'                    => 'css_res_p_inputs_padding_vertical',
				'std'                   => '', // 'std' => '10',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'input[type=text],input[type=email],textarea,input[type=password],input[type=number], input[type=tel], input[type=url], input[type=date]',
				'affect_on_change_rule' => 'padding-top,padding-bottom',
				'section'               => 'responsive',
				'ext'                   => 'px',
				'tab'                   => __( 'Phone', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Textbox / Textarea - Padding Horizontal', 'lcproext' ),
				'id'                    => 'css_res_p_inputs_padding_horizontal',
				'std'                   => '', // 'std' => '15',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'input[type=text],input[type=email],textarea,input[type=password],input[type=number], input[type=tel], input[type=url], input[type=date]',
				'affect_on_change_rule' => 'padding-left,padding-right',
				'section'               => 'responsive',
				'ext'                   => 'px',
				'tab'                   => __( 'Phone', 'lcproext' ),
			),
			array(
				'label'                 => __( 'List > Radio / Checkboxes - Font Size', 'lcproext' ),
				'id'                    => 'css_res_p_checkbox_labels_font_size',
				'std'                   => '', // 'std' => '13',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-list-item-label',
				'affect_on_change_rule' => 'font-size',
				'section'               => 'responsive',
				'tab'                   => __( 'Phone', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'List > Radio / Checkboxes - Line Height', 'lcproext' ),
				'id'                    => 'css_res_p_checkbox_labels_line_height',
				'std'                   => '', // 'std' => '23',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-list-item-label',
				'affect_on_change_rule' => 'line-height',
				'section'               => 'responsive',
				'tab'                   => __( 'Phone', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'List > Radio / Checkboxes - Padding Vertical', 'lcproext' ),
				'id'                    => 'css_res_p_checkbox_labels_padding_vertical',
				'std'                   => '', // 'std' => '0',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-list-item',
				'affect_on_change_rule' => 'padding-top,padding-bottom',
				'section'               => 'responsive',
				'ext'                   => 'px',
				'tab'                   => __( 'Phone', 'lcproext' ),
			),
			array(
				'label'                 => __( 'List > Radio / Checkboxes - Padding Horizontal', 'lcproext' ),
				'id'                    => 'css_res_p_checkbox_labels_padding_horizontal',
				'std'                   => '', // 'std' => '0',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-list-item',
				'affect_on_change_rule' => 'padding-left,padding-right',
				'section'               => 'responsive',
				'ext'                   => 'px',
				'tab'                   => __( 'Phone', 'lcproext' ),
			),
			array(
				'label'                 => __( 'List > Dropdown - Font Size', 'lcproext' ),
				'id'                    => 'css_res_p_select_font_size',
				'std'                   => '', // 'std' => '13',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'select',
				'affect_on_change_rule' => 'font-size',
				'section'               => 'responsive',
				'tab'                   => __( 'Phone', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'List > Dropdown - Line Height Input', 'lcproext' ),
				'id'                    => 'css_res_p_select_line_height',
				'std'                   => '', // 'std' => '23',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'select',
				'affect_on_change_rule' => 'line-height',
				'section'               => 'responsive',
				'tab'                   => __( 'Phone', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'List > Dropdown - Margin Bottom', 'lcproext' ),
				'id'                    => 'css_res_p_select_margin_bottom',
				'std'                   => '', // 'std' => '15',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'select',
				'affect_on_change_rule' => 'margin-bottom',
				'section'               => 'responsive',
				'ext'                   => 'px',
				'tab'                   => __( 'Phone', 'lcproext' ),
			),
			array(
				'label'                 => __( 'List > Dropdown - Padding Vertical', 'lcproext' ),
				'id'                    => 'css_res_p_select_padding_vertical',
				'std'                   => '', // 'std' => '10',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'select',
				'affect_on_change_rule' => 'padding-top,padding-bottom',
				'section'               => 'responsive',
				'ext'                   => 'px',
				'tab'                   => __( 'Phone', 'lcproext' ),
			),
			array(
				'label'                 => __( 'List > Dropdown - Padding Horizontal', 'lcproext' ),
				'id'                    => 'css_res_p_select_padding_horizontal',
				'std'                   => '', // 'std' => '15',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'select',
				'affect_on_change_rule' => 'padding-left,padding-right',
				'section'               => 'responsive',
				'ext'                   => 'px',
				'tab'                   => __( 'Phone', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Submit - Font Size', 'lcproext' ),
				'id'                    => 'css_res_p_button_font_size',
				'std'                   => '', // 'std' => '16',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'input[type=submit], button, input[type=button]',
				'affect_on_change_rule' => 'font-size',
				'section'               => 'responsive',
				'tab'                   => __( 'Phone', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Submit - Line Height', 'lcproext' ),
				'id'                    => 'css_res_p_button_line_height',
				'std'                   => '', // 'std' => '21',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'input[type=submit], button, input[type=button]',
				'affect_on_change_rule' => 'line-height',
				'section'               => 'responsive',
				'tab'                   => __( 'Phone', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Submit - Padding Vertical', 'lcproext' ),
				'id'                    => 'css_res_p_button_padding_vertical',
				'std'                   => '', // 'std' => '14',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'input[type=submit], button, input[type=button]',
				'affect_on_change_rule' => 'padding-top,padding-bottom',
				'section'               => 'responsive',
				'ext'                   => 'px',
				'tab'                   => __( 'Phone', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Submit - Padding Horizontal', 'lcproext' ),
				'id'                    => 'css_res_p_button_padding_horizontal',
				'std'                   => '', // 'std' => '18',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => 'input[type=submit], button, input[type=button]',
				'affect_on_change_rule' => 'padding-left,padding-right',
				'section'               => 'responsive',
				'ext'                   => 'px',
				'tab'                   => __( 'Phone', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Submit - Margin Top', 'lcproext' ),
				'id'                    => 'css_res_p_button_margin_top',
				'std'                   => '', // 'std' => '20',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-submit',
				'affect_on_change_rule' => 'margin-top',
				'section'               => 'responsive',
				'tab'                   => __( 'Phone', 'lcproext' ),
				'ext'                   => 'px',
				'min'                   => -50,
				'max'                   => 50,
				'increment'             => 1,
			),
			array(
				'label'                 => __( 'Field > Required - Font Size', 'lcproext' ),
				'id'                    => 'css_res_p_required_font_size',
				'std'                   => '', // 'std' => '14',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-not-valid-tip',
				'affect_on_change_rule' => 'font-size',
				'section'               => 'responsive',
				'tab'                   => __( 'Phone', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Field > Required - Line Height', 'lcproext' ),
				'id'                    => 'css_res_p_required_line_height',
				'std'                   => '', // 'std' => '21',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-not-valid-tip',
				'affect_on_change_rule' => 'line-height',
				'section'               => 'responsive',
				'tab'                   => __( 'Phone', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Field > Required - Margin Bottom', 'lcproext' ),
				'id'                    => 'css_res_p_required_margin_bottom',
				'std'                   => '', // 'std' => '20',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-not-valid-tip',
				'affect_on_change_rule' => 'margin-bottom',
				'section'               => 'responsive',
				'tab'                   => __( 'Phone', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Form Message > Error - Font Size', 'lcproext' ),
				'id'                    => 'css_res_p_form_error_msg_font_size',
				'std'                   => '', // 'std' => '13',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-validation-errors',
				'affect_on_change_rule' => 'font-size',
				'section'               => 'responsive',
				'tab'                   => __( 'Phone', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Form Message > Error - Line Height', 'lcproext' ),
				'id'                    => 'css_res_p_form_error_msg_line_height',
				'std'                   => '', // 'std' => '22',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-validation-errors',
				'affect_on_change_rule' => 'line-height',
				'section'               => 'responsive',
				'tab'                   => __( 'Phone', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Form Message > Error - Margin Bottom', 'lcproext' ),
				'id'                    => 'css_res_p_form_error_msg_margin_bottom',
				'std'                   => '', // 'std' => '25',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-validation-errors',
				'affect_on_change_rule' => 'margin-bottom',
				'section'               => 'responsive',
				'tab'                   => __( 'Phone', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Form Message > Error - Padding Vertical', 'lcproext' ),
				'id'                    => 'css_res_p_form_error_msg_padding_vertical',
				'std'                   => '', // 'std' => '10',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-validation-errors',
				'affect_on_change_rule' => 'padding-top,padding-bottom',
				'section'               => 'responsive',
				'ext'                   => 'px',
				'tab'                   => __( 'Phone', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Form Message > Error - Padding Horizontal', 'lcproext' ),
				'id'                    => 'css_res_p_form_error_msg_padding_horizontal',
				'std'                   => '', // 'std' => '15',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-validation-errors',
				'affect_on_change_rule' => 'padding-left,padding-right',
				'section'               => 'responsive',
				'ext'                   => 'px',
				'tab'                   => __( 'Phone', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Form Message > Error - Text Align', 'lcproext' ),
				'id'                    => 'css_res_p_form_error_msg_text_align',
				'std'                   => '', // 'std' => 'left',
				'type'                  => 'select',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-validation-errors',
				'affect_on_change_rule' => 'text-align',
				'section'               => 'responsive',
				'tab'                   => __( 'Phone', 'lcproext' ),
				'choices'               => array(
					array(
						'label' => __( 'Left', 'lcproext' ),
						'value' => 'left',
					),
					array(
						'label' => __( 'Center', 'lcproext' ),
						'value' => 'center',
					),
					array(
						'label' => __( 'Right', 'lcproext' ),
						'value' => 'right',
					),
					array(
						'label' => __( 'Justify', 'lcproext' ),
						'value' => 'justify',
					),
				),
			),
			array(
				'label'                 => __( 'Form Message > Success - Font Size', 'lcproext' ),
				'id'                    => 'css_res_p_form_success_msg_font_size',
				'std'                   => '', // 'std' => '13',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-mail-sent-ok',
				'affect_on_change_rule' => 'font-size',
				'section'               => 'responsive',
				'tab'                   => __( 'Phone', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Form Message > Success - Line Height', 'lcproext' ),
				'id'                    => 'css_res_p_form_success_msg_line_height',
				'std'                   => '', // 'std' => '22',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-mail-sent-ok',
				'affect_on_change_rule' => 'line-height',
				'section'               => 'responsive',
				'tab'                   => __( 'Phone', 'lcproext' ),
				'ext'                   => 'px',
			),
			array(
				'label'                 => __( 'Form Message > Success - Padding Vertical', 'lcproext' ),
				'id'                    => 'css_res_p_form_success_msg_padding_vertical',
				'std'                   => '', // 'std' => '10',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-mail-sent-ok',
				'affect_on_change_rule' => 'padding-top,padding-bottom',
				'section'               => 'responsive',
				'ext'                   => 'px',
				'tab'                   => __( 'Phone', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Form Message > Success - Padding Horizontal', 'lcproext' ),
				'id'                    => 'css_res_p_form_success_msg_padding_horizontal',
				'std'                   => '', // 'std' => '15',
				'type'                  => 'slider',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-mail-sent-ok',
				'affect_on_change_rule' => 'padding-left,padding-right',
				'section'               => 'responsive',
				'ext'                   => 'px',
				'tab'                   => __( 'Phone', 'lcproext' ),
			),
			array(
				'label'                 => __( 'Form Message > Success - Text Align', 'lcproext' ),
				'id'                    => 'css_res_p_form_success_msg_text_align',
				'std'                   => '', // 'std' => 'left',
				'type'                  => 'select',
				'refresh_on_change'     => false,
				'affect_on_change_el'   => '.wpcf7-mail-sent-ok',
				'affect_on_change_rule' => 'text-align',
				'section'               => 'responsive',
				'tab'                   => __( 'Phone', 'lcproext' ),
				'choices'               => array(
					array(
						'label' => __( 'Left', 'lcproext' ),
						'value' => 'left',
					),
					array(
						'label' => __( 'Center', 'lcproext' ),
						'value' => 'center',
					),
					array(
						'label' => __( 'Right', 'lcproext' ),
						'value' => 'right',
					),
					array(
						'label' => __( 'Justify', 'lcproext' ),
						'value' => 'justify',
					),
				),
			),
		);

		return apply_filters( 'dslc_module_options', $dslc_options, $this->module_id );
	}

	/**
	 * Output the module render
	 *
	 * @param  array $options All the plugin options.
	 * @return void
	 */
	function output( $options ) {

		if ( ! isset( $options['contact_form'] ) || 'not_set' == $options['contact_form'] ) {
			echo '<div class="dslc-notification dslc-red dslca-module-edit-hook">' . __( 'Click here to choose the form.', 'lcproext' ) . '<span class="dslca-module-edit-hook dslc-icon dslc-icon-cog"></span></div>';
		} else {
			echo '[contact-form-7 id=' . $options['contact_form'] . ']';
		}
	}
}

/**
 * Set default values for Ninja Forms Module in the Live Composer
 *
 * @param  array  $options Module options to fill the module template.
 * @param  string $id      Module ID.
 */
function lcextpro_alter_cf_defaults_in_lc( $options, $id ) {
	// The array that will hold new defaults.
	$new_defaults = array();

	if ( 'LCPROEXT_Contact_Form_7' == $id ) {
		$new_defaults = array(
			'css_margin_bottom'             => '40',
			'css_main_border_width'         => '0',
			'css_form_field_padding_right'  => '30',
			'css_form_field_padding_bottom' => '20',

			'css_labels_font_size'   => '16',
			'css_labels_font_weight' => '300',

			'css_inputs_border_color'       => 'rgb(220, 221, 221)',
			'css_inputs_color'              => 'rgb(172, 174, 174)',
			'css_inputs_focus_border_color' => 'rgb(90, 173, 225)',
			'css_inputs_focus_txt_color'    => 'rgb(60, 60, 60)',
			'css_inputs_border_width'       => '1',
			'css_inputs_border_trbl'        => 'top right bottom left ',
			'css_inputs_border_radius'      => '4',
			'css_inputs_font_size'          => '16',
			'css_inputs_line_height'        => '24',
			'css_inputs_line_height'        => '24',
			'css_inputs_padding_vertical'   => '10',
			'css_inputs_padding_horizontal' => '12',
			'css_inputs_margin_bottom'      => '15',

			'css_button_bg_color'           => 'rgb(90, 173, 225)',
			'css_button_color'              => 'rgb(255, 255, 255)',
			'css_button_bg_color_hover'     => 'rgb(77, 125, 192)',
			'css_button_border_width'       => '0',
			'css_button_border_trbl'        => 'top right bottom left ',
			'css_button_border_radius'      => '4',
			'css_button_font_size'          => '18',
			'css_button_font_weight'        => '300',
			'css_button_line_height'        => '21',
			'css_button_padding_vertical'   => '14',
			'css_button_padding_horizontal' => '20',
			'css_button_margin_top'         => '15',

			'css_req_items_color'            => 'rgb(165, 165, 165)',
			'css_req_items_font_size'        => '14',
			'css_req_items_line_height'      => '21',
			'css_req_items_margin_bottom'    => '30',
			'css_req_items_padding_vertical' => '15',
			'css_symbol_color'               => 'rgb(244, 133, 27)',

			'css_text_color'       => 'rgb(165, 165, 165)',
			'css_text_font_size'   => '14',
			'css_text_line_height' => '21',

			'css_description_color'       => 'rgb(165, 165, 165)',
			'css_description_font_size'   => '12',
			'css_description_line_height' => '18',
			'css_description_margin_top'  => '10',

			'css_form_error_bg_color'             => 'rgb(252, 9, 27)',
			'css_form_error_border_radius_top'    => '0',
			'css_form_error_border_radius_bottom' => '4',
			'css_form_error_color'                => 'rgb(255, 255, 255)',
			'css_form_error_font_size'            => '12',
			'css_form_error_line_height'          => '14',
			'css_form_error_bottom'               => '0',
			'css_form_error_padding_vertical'     => '4',
			'css_form_error_padding_horizontal'   => '12',

			'css_form_success_msg_bg_color'             => 'rgb(245, 248, 235)',
			'css_form_success_msg_border_color'         => 'rgb(217, 223, 195)',
			'css_form_success_msg_border_width'         => '1',
			'css_form_success_msg_border_trbl'          => 'bottom ',
			'css_form_success_msg_border_radius_top'    => '4',
			'css_form_success_msg_border_radius_bottom' => '4',
			'css_form_success_msg_color'                => 'rgb(145, 177, 40)',
			'css_form_success_msg_font_size'            => '21',
			'css_form_success_msg_line_height'          => '30',
			'css_form_success_msg_padding_vertical'     => '30',
			'css_form_success_msg_text_align'           => 'center',

			'css_checkbox_labels_font_size'   => '16',
			'css_checkbox_labels_font_weight' => '300',
			'css_checkbox_input_margin_right' => '6',

			'css_select_border_color'       => 'rgb(220, 221, 221)',
			'css_select_border_width'       => '1',
			'css_select_border_trbl'        => 'top right bottom left ',
			'css_select_padding_vertical'   => '9',
			'css_select_padding_horizontal' => '14',

			'css_hr_bg_color'      => 'rgba(220, 221, 221, 0.48)',
			'css_hr_height'        => '1',
			'css_hr_margin_top'    => '20',
			'css_hr_margin_bottom' => '15',

		);
	}

	// Call the function that alters the defaults and return.
	return dslc_set_defaults( $new_defaults, $options );
}
add_filter( 'dslc_module_options', 'lcextpro_alter_cf_defaults_in_lc', 10, 2 );

/**
 * Register Module
 */
function lcextpro_contact_forms_init_module() {
	return dslc_register_module( 'LCPROEXT_Contact_Form_7' );
}
add_action( 'dslc_hook_register_modules', 'lcextpro_contact_forms_init_module' );
