<?php
/**
 * Single Event Template
 * A single event. This displays the event title, description, meta, and
 * optionally, the Google map for the event.
 *
 * Override this template in your own theme by creating a file at [your-theme]/tribe-events/single-event.php
 *
 * @package TribeEventsCalendar
 * @version  4.3
 *
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

$events_label_singular = tribe_get_event_label_singular();
$events_label_plural = tribe_get_event_label_plural();

$event_id = get_the_ID();
$thumb = '';
if( has_post_thumbnail() ){
    $thumb = tribe_event_featured_image( $event_id, 'full', false );
}

$time_format = get_option( 'time_format', Tribe__Date_Utils::TIMEFORMAT );
$time_range_separator = tribe_get_option( 'timeRangeSeparator', ' - ' );

$start_datetime = tribe_get_start_date(); 
 
$start_date = tribe_get_start_date( null, false );
$start_time = tribe_get_start_date( null, false, $time_format ); 
$start_ts = tribe_get_start_date( null, false, 'd F Y');

$end_datetime = tribe_get_end_date();
$end_date = tribe_get_display_end_date( null, false );
$end_time = tribe_get_end_date( null, false, $time_format );
$end_ts = tribe_get_end_date( null, false, Tribe__Date_Utils::DBDATEFORMAT );

$end_datetimed = tribe_get_end_date(null,true,'Y-m-j');

$end_datetitle = tribe_get_end_date(null,true,'j M');
$venue_id = get_the_ID();

?>
<?php if (Themeton_Std::getopt('lagom_skin')=='church'): ?>
		<?php while ( have_posts() ) :  the_post(); ?>
		<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
			<!-- Event featured image, but exclude link -->
			<div class='event_content'>
	            <?php the_title( '<h2 class="tribe-events-single-event-title uk-text-capitalize uk-text-center">', '</h2>' ); ?>
				<!-- Event content -->
				<div class='entry-meta uk-flex uk-flex-center mt1 mb3 '>
					<i class='pr1 uk-icon'><svg width="20" height="20" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg"> <circle fill="none" stroke="#000" stroke-width="1.1" cx="10" cy="10" r="9"></circle> <rect x="9" y="4" width="1" height="7"></rect> <path fill="none" stroke="#000" stroke-width="1.1" d="M13.018,14.197 L9.445,10.625"></path></svg></i><span class='date'><?php echo esc_html($start_ts) ?></span>
					<?php
					// This location's country.
						if ( tribe_get_address( $venue_id ) ) : ?>
							<span class="tribe-country-name pl3" ><i class='pr1 uk-icon'><svg width='20' height='20' viewBox='0 0 20 20' xmlns='http://www.w3.org/2000/svg'> <path fill='none' stroke='#000' stroke-width='1.01' d='M10,0.5 C6.41,0.5 3.5,3.39 3.5,6.98 C3.5,11.83 10,19 10,19 C10,19 16.5,11.83 16.5,6.98 C16.5,3.39 13.59,0.5 10,0.5 L10,0.5 Z'></path> <circle fill='none' stroke='#000' cx='10' cy='6.8' r='2.3'></circle></svg></i><?php echo tribe_get_address( $venue_id ); ?></span>
					<?php endif; ?>
					
				</div>
				<?php do_action( ' tribe_events_single_event_before_the_content' ) ?>
				<div class=" tribe-events-single-event-description tribe-events-content pr10 pl10 pr10@s pl10@s">
					<?php the_content(); ?>
				</div>
				<!-- .tribe-events-single-event-description -->
			</div>
		</div> <!-- #post-x -->
		<?php if ( get_post_type() == Tribe__Events__Main::POSTTYPE && tribe_get_option( 'showComments', false ) ) comments_template() ?>
	    <?php endwhile; ?>
<?php elseif (Themeton_Std::getopt('lagom_skin')=='nightclub'): ?>
		<?php while ( have_posts() ) :  the_post(); ?>
				<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
					<!-- Event featured image, but exclude link -->
					<div class='event_content'>
						<!-- Event content -->
						<?php do_action( ' tribe_events_single_event_before_the_content' ) ?>
						<div class=" tribe-events-single-event-description tribe-events-content pr10 pl10 pr10@s pl10@s">
							<?php the_content(); ?>
						</div>
						<!-- .tribe-events-single-event-description -->
					</div>

				</div> <!-- #post-x -->
				<?php if ( get_post_type() == Tribe__Events__Main::POSTTYPE && tribe_get_option( 'showComments', false ) ) comments_template() ?>
	    <?php endwhile; ?>
<?php else: ?>
	<div id="tribe-events-content" class="tribe-events-single">
	<!-- Notices -->
	<!-- #tribe-events-header -->
	<?php tribe_the_notices() ?>

		<?php while ( have_posts() ) :  the_post(); ?>
			<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
				<!-- Event featured image, but exclude link -->
				<div class='event_content'>
					<div class="feature_image">
						<ul class="metadate">
							<li class="mount"><?php echo esc_html( $end_datetitle ) ?></li>
							<li class="date"><?php echo esc_html( $start_time ) ?> <?php echo esc_html( $time_range_separator ) ?><?php echo esc_html( $end_time ) ?></li>
						</ul>
						<?php printf($thumb); ?>
					</div>

					<?php the_title( '<h2 class="tribe-events-single-event-title pr8 pl8 pt2">', '</h2>' ); ?>
					<!-- Event content -->
					<?php do_action( 'tribe_events_single_event_before_the_content' ) ?>
					<div class=" tribe-events-single-event-description tribe-events-content">
						<?php the_content(); ?>
					</div>
					<!-- .tribe-events-single-event-description -->
				</div>

				<!-- Event meta -->
				
					<?php do_action( 'tribe_events_single_event_before_the_meta' ) ?>
					<?php tribe_get_template_part( 'modules/meta' ); ?>
					<?php do_action( 'tribe_events_single_event_after_the_meta' ) ?>
			</div> <!-- #post-x -->
			<?php if ( get_post_type() == Tribe__Events__Main::POSTTYPE && tribe_get_option( 'showComments', false ) ) comments_template() ?>
			<?php endwhile; ?>

		<!-- Event footer -->
		<div id="tribe-events-footer" class=' uk-position-relative'>
		<div  class="uk-grid event-footer" >
				<div class='uk-width-auto@m uk-width-1-1@s' >
					<div data-uk-countdown="date: <?php echo esc_html( $end_datetimed ) ?>" class='countdown'>
						<ul>
							<li><span class="uk-countdown-number uk-countdown-days"></span><i>day</i></li>
							<li><span class="uk-countdown-number uk-countdown-hours"></span><i>hours</i></li>
							<li><span class="uk-countdown-number uk-countdown-minutes"></span><i>minuts</i></li>
							<li><span class="uk-countdown-number uk-countdown-seconds"></span><i>seconds</i></li>
						</ul>
					</div>
				</div>
				<div class="uk-width-expand@m uk-width-1-1@s uk-flex-middle uk-flex uk-flex-right pr4">
					<a href="javascript:;" class="uk-button-default uk-button">buy ticket</a>
				</div>
			</div>
			<!-- .tribe-events-sub-nav -->
		</div>
		<!-- #tribe-events-footer -->

	</div><!-- #tribe-events-content -->
<?php endif; ?>