<?php
/*
 * @package     Primary MenuPrimary MenuPrimary Menu - Extension for Importing demo content
 * @author      Webcreations907
 * @version     1.0
 */


/************************************************************************
* Importer will auto load, there is no settings required to put in your
* Reduxframework config file.
*
* BUT- If you want to put the demo importer in a different position on 
* the panel, use the below within your config for Redux.
*************************************************************************/

/************************************************************************
* Example functions/filters
*************************************************************************/
if ( !function_exists( 'wbc_after_content_import' ) ) {

	/**
	 * Function/action ran after import of content.xml file
	 *
	 * @param (array) $demo_active_import       Example below
	 * [wbc-import-1] => Array
	 *      (
	 *            [directory] => current demo data folder name
	 *            [content_file] => content.xml
	 *            [image] => screen-image.png
	 *            [theme_options] => theme-options.txt
	 *            [widgets] => widgets.json
	 *            [imported] => imported
	 *        )
	 * @param (string) $demo_data_directory_path path to current demo folder being imported.
	 *
	 */

	function wbc_after_content_import( $demo_active_import , $demo_data_directory_path ) {
		//Do something
	}

	// Uncomment the below
	// add_action( 'wbc_importer_after_content_import', 'wbc_after_content_import', 10, 2 );
}

if ( !function_exists( 'wbc_filter_title' ) ) {

	/**
	 * Filter for changing demo title in options panel so it's not folder name.
	 *
	 * @param [string] $title name of demo data folder
	 *
	 * @return [string] return title for demo name.
	 */

	function wbc_filter_title( $title ) {
		return trim( ucfirst( str_replace( "-", " ", $title ) ) );
	}

	// Uncomment the below
	// add_filter( 'wbc_importer_directory_title', 'wbc_filter_title', 10 );
}

if ( !function_exists( 'wbc_importer_description_text' ) ) {

	/**
	 * Filter for changing importer description info in options panel
	 * when not setting in Redux config file.
	 *
	 * @param [string] $title description above demos
	 *
	 * @return [string] return.
	 */

	function wbc_importer_description_text( $description ) {

		$message = '<p>'. esc_html__( 'Best if used on new WordPress install.', 'lagom' ) .'</p>';
		$message .= '<p>'. esc_html__( 'Images are for demo purpose only.', 'lagom' ) .'</p>';

		return $message;
	}

	// Uncomment the below
	// add_filter( 'wbc_importer_description', 'wbc_importer_description_text', 10 );
}

if ( !function_exists( 'wbc_importer_label_text' ) ) {

	/**
	 * Filter for changing importer label/tab for redux section in options panel
	 * when not setting in Redux config file.
	 *
	 * @param [string] $title label above demos
	 *
	 * @return [string] return no html
	 */

	function wbc_importer_label_text( $label_text ) {

		$label_text = 'WBC Importer';

		return $label_text;
	}

	// Uncomment the below
	// add_filter( 'wbc_importer_label', 'wbc_importer_label_text', 10 );
}

if ( !function_exists( 'wbc_change_demo_directory_path' ) ) {

	/**
	 * Change the path to the directory that contains demo data folders.
	 *
	 * @param [string] $demo_directory_path
	 *
	 * @return [string]
	 */

	function wbc_change_demo_directory_path( $demo_directory_path ) {

		return $demo_directory_path;

	}

	// Uncomment the below
	// add_filter('wbc_importer_dir_path', 'wbc_change_demo_directory_path' );
}

if ( !function_exists( 'wbc_importer_before_widget' ) ) {

	/**
	 * Function/action ran before widgets get imported
	 *
	 * @param (array) $demo_active_import       Example below
	 * [wbc-import-1] => Array
	 *      (
	 *            [directory] => current demo data folder name
	 *            [content_file] => content.xml
	 *            [image] => screen-image.png
	 *            [theme_options] => theme-options.txt
	 *            [widgets] => widgets.json
	 *            [imported] => imported
	 *        )
	 * @param (string) $demo_data_directory_path path to current demo folder being imported.
	 *
	 * @return nothing
	 */

	function wbc_importer_before_widget( $demo_active_import , $demo_data_directory_path ) {

		//Do Something

	}

	// Uncomment the below
	// add_action('wbc_importer_before_widget_import', 'wbc_importer_before_widget', 10, 2 );
}

if ( !function_exists( 'wbc_after_theme_options' ) ) {

	/**
	 * Function/action ran after theme options set
	 *
	 * @param (array) $demo_active_import       Example below
	 * [wbc-import-1] => Array
	 *      (
	 *            [directory] => current demo data folder name
	 *            [content_file] => content.xml
	 *            [image] => screen-image.png
	 *            [theme_options] => theme-options.txt
	 *            [widgets] => widgets.json
	 *            [imported] => imported
	 *        )
	 * @param (string) $demo_data_directory_path path to current demo folder being imported.
	 *
	 * @return nothing
	 */

	function wbc_after_theme_options( $demo_active_import , $demo_data_directory_path ) {

		//Do Something

	}

	// Uncomment the below
	// add_action('wbc_importer_after_theme_options_import', 'wbc_after_theme_options', 10, 2 );
}


/************************************************************************
* Extended Example:
* Way to set menu, import revolution slider, and set home page.
*************************************************************************/

if ( !function_exists( 'wbc_extended_example' ) ) {
	function wbc_extended_example( $demo_active_import , $demo_directory_path ) {

		reset( $demo_active_import );
		$current_key = key( $demo_active_import );

		/************************************************************************
		* Import slider(s) for the current demo being imported
		*************************************************************************/

		if ( class_exists( 'RevSlider' ) ) {

			$wbc_sliders_array = array(
				'agency' => array(
					'http://themeton.com/oneclick/lagom/agency/head.zip',
					'http://themeton.com/oneclick/lagom/agency/agency-portfolio.zip'
				),
				'carrental' => array(
					'http://themeton.com/oneclick/lagom/carrental/carrental-home.zip'
				),
				'charity' => array(
					'http://themeton.com/oneclick/lagom/charity/charity-home.zip'
				),
				'church' => array(
					'http://themeton.com/oneclick/lagom/church/church-home.zip',
					'http://themeton.com/oneclick/lagom/church/church-portfolio.zip'
				),
				'construction' => array(
					'http://themeton.com/oneclick/lagom/construction/construction-home.zip'
				),
				'hosting' => array(
					'http://themeton.com/oneclick/lagom/hosting/hosting-home.zip'
				),
				'hotel' => array(
					'http://themeton.com/oneclick/lagom/hotel/hotel-home.zip'
				),
				'jewelry' => array(
					'http://themeton.com/oneclick/lagom/jewelry/jewelry-home.zip'
				),
				'laundry' => array(
					'http://themeton.com/oneclick/lagom/laundry/laundry-home.zip'
				),
				'logistics' => array(
					'http://themeton.com/oneclick/lagom/logistics/logistics-home.zip'
				),
				'medical' => array(
					'http://themeton.com/oneclick/lagom/medical/medical-home.zip'
				),
				'model' => array(
					'http://themeton.com/oneclick/lagom/model/model-home.zip'
				),
				'fitness' => array(
					'http://themeton.com/oneclick/lagom/fitness/fitness-home.zip'
				),
				'singleproduct' => array(
					'http://themeton.com/oneclick/lagom/singleproduct/singleproduct-home.zip'
				),
				'yoga' => array(
					'http://themeton.com/oneclick/lagom/yoga/home-yoga.zip'
				),
				'nightclub' => array(
					'http://themeton.com/oneclick/lagom/nightclub/nightclub.zip'
				),
				'finag' => array(
					'http://themeton.com/oneclick/lagom/finag/finag-home.zip'
				),
			);
			 if ( isset( $demo_active_import[$current_key]['directory'] ) && !empty( $demo_active_import[$current_key]['directory'] ) && array_key_exists( $demo_active_import[$current_key]['directory'], $wbc_sliders_array ) ) {
		        $wbc_slider_import = $wbc_sliders_array[$demo_active_import[$current_key]['directory']];

		        if( is_array( $wbc_slider_import ) ){
		            foreach ($wbc_slider_import as $slider_zip) {
		                $slider = new RevSlider();
	                    $temp_file = download_url($slider_zip);
	                    $slider->importSliderFromPost( true, true, $temp_file );
		            }
		        }
		    }
		}


		/************************************************************************
		* Setting Menus
		*************************************************************************/

		$wbc_menu_array = array( 'agency', 'carrental', 'charity', 'church', 'construction', 'hosting','hotel','jewelry','laundry','logistics','medical','model','realestate','fitness','singleproduct' );

		if ( isset( $demo_active_import[$current_key]['directory'] ) && !empty( $demo_active_import[$current_key]['directory'] ) && in_array( $demo_active_import[$current_key]['directory'], $wbc_menu_array ) ) {
			$top_menu = get_term_by( 'main', 'main-menu', 'nav_menu' );

			if ( isset( $top_menu->term_id ) ) {
				set_theme_mod( 'nav_menu_locations', array(
						'primary' => $top_menu->term_id,
						'footer_menu'  => $top_menu->term_id
					)
				);
			}
		}

		/************************************************************************
		* Set HomePage
		*************************************************************************/

		// array of demos/homepages to check/select from
		$wbc_home_pages = array(
			'agency' => 'Home Agency',
			'carrental' => 'Home CarRental',
			'charity' => 'Home Charity',
			'church' => 'Home Church',
			'construction' => 'Home Construction',
			'hosting' => 'Home Hosting',
			'hotel' => 'Home Hotel',
			'jewelry' => 'Home Jewelry',
			'laundry' => 'Home Laundry',
			'logistics' => 'Home Logistics',
			'medical' => 'Home Medical',
			'model' => 'Home Model',
			'realestate' => 'Home Real Estate',
			'fitness' => 'Home Fitness',
			'singleproduct' => 'Home Single Product',
		);

		if ( isset( $demo_active_import[$current_key]['directory'] ) && !empty( $demo_active_import[$current_key]['directory'] ) && array_key_exists( $demo_active_import[$current_key]['directory'], $wbc_home_pages ) ) {
			$page = get_page_by_title( $wbc_home_pages[$demo_active_import[$current_key]['directory']] );
			if ( isset( $page->ID ) ) {
				update_option( 'page_on_front', $page->ID );
				update_option( 'show_on_front', 'page' );
			}
		}

	}


	add_action( 'wbc_importer_after_content_import', 'wbc_extended_example', 10, 2 );
}

?>
