<?php
/**
 * More icons for LiveComposer
 *
 * @package    SEOWP WordPress Theme
 * @author     Vlad Mitkovsky <info@lumbermandesigns.com>
 * @copyright  2014 Lumberman Designs
 * @license    GNU GPL, Version 3
 * @link       http://themeforest.net/user/lumbermandesigns
 *
 * -------------------------------------------------------------------
 *
 * Send your ideas on code improvement or new hook requests using
 * contact form on http://themeforest.net/user/lumbermandesigns
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

if ( defined( 'DS_LIVE_COMPOSER_URL' ) ) {

	/**
	 * Add cusotm icons into the array of all icons available in LC
	 *
	 * @param  array $icons List of icons to filter/modify.
	 * @return array        Modified list of icons.
	 */
	function lbmn_extra_icons_for_lc( $icons ) {
		// Open json file generated by iconmoon in /theme/iconfont/selection.json.
		/* ✅ Read JSON with icons via file_get_contents. ➡️ WP_Filesystem isn't for that. See: https://wordpress.stackexchange.com/a/166172 */
		$string          = file_get_contents( get_template_directory() . '/iconfont/selection.json' );
		$json_a          = json_decode( $string, true );
		$json_a['icons'] = array_reverse( $json_a['icons'] );

		$extra_icons = array();

		// Add these icons into the list of all icons.
		foreach ( $json_a['icons'] as $k => $v ) {

			$icon_name = $v['properties']['name'];
			$extra_icons[] = 'ext-' . $icon_name;
		}

		$icons_to_add = array();
		$icons_to_add['ext'] = $extra_icons;

		// Disable fontawesome icons set for better page loading time.
		unset( $icons['fontawesome'] );
		$icons = array_values( $icons );

		// Add custom icons in the head of the icons array.
		$icons = array_merge( $icons_to_add, $icons );

		// Remove fontawesome icons in our theme for better site loading times.
		unset( $icons['fontawesome'] );

		return $icons;

	} add_filter( 'dslc_available_icons', 'lbmn_extra_icons_for_lc' );

	/**
	 * Add all the extra icon css files required.
	 *
	 * @return void
	 */
	function lbmn_extraicons_add_files( $icon_fonts ) {
		$icon_fonts['ext'] = array(
			'font_path' => get_template_directory_uri() . '/iconfont/style.css',
			'version' => SEOWP_THEME_VER,
		);

		$icon_fonts['social'] = array(
			'font_path' => get_template_directory_uri() .  '/iconfont/social-share-icons.css',
			'version' => SEOWP_THEME_VER,
		);

		return $icon_fonts;

	} add_filter( 'dslc_icon_fonts', 'lbmn_extraicons_add_files' );
}
