<?php
/**
 * Module Textarea
 *
 * @package Live Composer - ACF integration
 */

// Prevent direct access to the file.
if ( ! defined( 'ABSPATH' ) ) {
	header( 'HTTP/1.0 403 Forbidden' );
	exit;
}

/**
 * Module Class
 */
class ACF_Textarea extends DSLC_Module {

	/**
	 * Unique module id
	 *
	 * @var string
	 */
	var $module_id;

	/**
	 * Module label to show in the page builder
	 *
	 * @var string
	 */
	var $module_title;

	/**
	 * Module icon name (FontAwesome)
	 *
	 * @var string
	 */
	var $module_icon;

	/**
	 * Section in the modules panel that includes this module
	 *
	 * @var string
	 */
	var $module_category;

	/**
	 * Exclude from main listing
	 *
	 * @var string
	 */
	var $exclude_from_main_listing;

	/**
	 * Construct
	 */
	function __construct() {

		$this->module_id = 'ACF_Textarea';
		$this->module_title = __( 'Textarea', 'lc-acf-integration' );
		$this->module_icon = 'align-left';
		$this->module_category = 'ACF - Basic';
		$this->exclude_from_main_listing = true;
	}

	/**
	 * Module options.
	 * Function build array with all the module functionality and styling options.
	 * Based on this array Live Composer builds module settings panel.
	 * – Every array inside $dslc_options means one option = one control.
	 * – Every option should have unique (for this module) id.
	 * – Options divides on "Functionality" and "Styling".
	 * – Styling options start with css_XXXXXXX
	 * – Responsive options start with css_res_t_ (Tablet) or css_res_p_ (Phone)
	 * – Options can be hidden.
	 * – Options can have a default value.
	 * – Options can request refresh from server on change or do live refresh via CSS.
	 *
	 * @return array All the module options in array.
	 */
	function options() {

		if ( isset( $_POST['post_id'] ) ) {

			$post_id = $_POST['post_id'];
			$type = get_post_type( $post_id );

			if ( 'dslc_templates' === $type ) {

				if ( isset( $_POST['dslc_url_vars']['preview_id'] ) ) {
					$id = $_POST['dslc_url_vars']['preview_id'];
				} else {
					$id = '';
				}
			} else {
				$id = $post_id;
			}
		} else {
			$id = '';
		}

		$choices = array();
		$choices[] = array(
			'label' => __( 'Choose field', 'lc-acf-integration' ),
			'value' => 'not_set',
		);

		if ( ! empty( $id ) ) {

			$fields = lcacf_get_all_fields( $id, 'textarea' );

			if ( ! empty( $fields ) ) {

				foreach ( $fields as $field ) {

					$choices[] = array(
						'label' => $field['label'],
						'value' => $field['value'],
					);
				}
			}
		} else {

			$fields = lcacf_get_all_fields_by_group( 'textarea' );

			if ( ! empty( $fields ) ) {

				foreach ( $fields as $field ) {

					$choices[] = array(
						'label' => $field['label'],
						'value' => $field['value'],
					);
				}
			}
		}

		$dslc_options = array(

			array(
				'label' => __( 'Show On', 'lc-acf-integration' ),
				'id' => 'css_show_on',
				'std' => 'desktop tablet phone',
				'type' => 'checkbox',
				'choices' => array(
					array(
						'label' => __( 'Desktop', 'lc-acf-integration' ),
						'value' => 'desktop',
					),
					array(
						'label' => __( 'Tablet', 'lc-acf-integration' ),
						'value' => 'tablet',
					),
					array(
						'label' => __( 'Phone', 'lc-acf-integration' ),
						'value' => 'phone',
					),
				),
			),
			array(
				'label' => __( 'ACF Field to Display', 'lc-acf-integration' ),
				'id' => 'select_field',
				'std' => 'not_set',
				'type' => 'select',
				'choices' => $choices,
			),

			/**
			 * Styling Options
			 */

			array(
				'label' => __( 'Background', 'lc-acf-integration' ),
				'id' => 'css_background_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'styling',
			),
				array(
					'label' => __( 'BG Color', 'lc-acf-integration' ),
					'id' => 'css_main_bg_color',
					'std' => '',
					'type' => 'color',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea',
					'affect_on_change_rule' => 'background-color',
					'section' => 'styling',
				),
				array(
					'label' => __( 'BG Image', 'lc-acf-integration' ),
					'id' => 'css_main_bg_img',
					'std' => '',
					'type' => 'image',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea',
					'affect_on_change_rule' => 'background-image',
					'section' => 'styling',
				),
				array(
					'label' => __( 'BG Image Repeat', 'lc-acf-integration' ),
					'id' => 'css_main_bg_img_repeat',
					'std' => 'repeat',
					'type' => 'select',
					'choices' => array(
						array(
							'label' => __( 'Repeat', 'lc-acf-integration' ),
							'value' => 'repeat',
						),
						array(
							'label' => __( 'Repeat Horizontal', 'lc-acf-integration' ),
							'value' => 'repeat-x',
						),
						array(
							'label' => __( 'Repeat Vertical', 'lc-acf-integration' ),
							'value' => 'repeat-y',
						),
						array(
							'label' => __( 'Do NOT Repeat', 'lc-acf-integration' ),
							'value' => 'no-repeat',
						),
					),
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea',
					'affect_on_change_rule' => 'background-repeat',
					'section' => 'styling',
				),
				array(
					'label' => __( 'BG Image Attachment', 'lc-acf-integration' ),
					'id' => 'css_main_bg_img_attch',
					'std' => 'scroll',
					'type' => 'select',
					'choices' => array(
						array(
							'label' => __( 'Scroll', 'lc-acf-integration' ),
							'value' => 'scroll',
						),
						array(
							'label' => __( 'Fixed', 'lc-acf-integration' ),
							'value' => 'fixed',
						),
					),
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea',
					'affect_on_change_rule' => 'background-attachment',
					'section' => 'styling',
				),
				array(
					'label' => __( 'BG Image Position', 'lc-acf-integration' ),
					'id' => 'css_main_bg_img_pos',
					'std' => 'top left',
					'type' => 'select',
					'choices' => array(
						array(
							'label' => __( 'Top Left', 'lc-acf-integration' ),
							'value' => 'left top',
						),
						array(
							'label' => __( 'Top Right', 'lc-acf-integration' ),
							'value' => 'right top',
						),
						array(
							'label' => __( 'Top Center', 'lc-acf-integration' ),
							'value' => 'Center Top',
						),
						array(
							'label' => __( 'Center Left', 'lc-acf-integration' ),
							'value' => 'left center',
						),
						array(
							'label' => __( 'Center Right', 'lc-acf-integration' ),
							'value' => 'right center',
						),
						array(
							'label' => __( 'Center', 'lc-acf-integration' ),
							'value' => 'center center',
						),
						array(
							'label' => __( 'Bottom Left', 'lc-acf-integration' ),
							'value' => 'left bottom',
						),
						array(
							'label' => __( 'Bottom Right', 'lc-acf-integration' ),
							'value' => 'right bottom',
						),
						array(
							'label' => __( 'Bottom Center', 'lc-acf-integration' ),
							'value' => 'center bottom',
						),
					),
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea',
					'affect_on_change_rule' => 'background-position',
					'section' => 'styling',
				),
			array(
				'id' => 'css_background_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'styling',
			),
			array(
				'label' => __( 'Border', 'lc-acf-integration' ),
				'id' => 'css_border_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'styling',
			),
				array(
					'label' => __( 'Color', 'lc-acf-integration' ),
					'id' => 'css_border_color',
					'std' => '',
					'type' => 'color',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea',
					'affect_on_change_rule' => 'border-color',
					'section' => 'styling',
				),
				array(
					'label' => __( 'Width', 'lc-acf-integration' ),
					'id' => 'css_border_width',
					'onlypositive' => true,
					'max' => 10,
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea',
					'affect_on_change_rule' => 'border-width',
					'section' => 'styling',
					'ext' => 'px',
				),
				array(
					'label' => __( 'Borders', 'lc-acf-integration' ),
					'id' => 'css_border_trbl',
					'std' => 'top right bottom left',
					'type' => 'checkbox',
					'choices' => array(
						array(
							'label' => __( 'Top', 'lc-acf-integration' ),
							'value' => 'top',
						),
						array(
							'label' => __( 'Right', 'lc-acf-integration' ),
							'value' => 'right',
						),
						array(
							'label' => __( 'Bottom', 'lc-acf-integration' ),
							'value' => 'bottom',
						),
						array(
							'label' => __( 'Left', 'lc-acf-integration' ),
							'value' => 'left',
						),
					),
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea',
					'affect_on_change_rule' => 'border-style',
					'section' => 'styling',
				),
				array(
					'label' => __( 'Radius - Top', 'lc-acf-integration' ),
					'id' => 'css_border_radius_top',
					'onlypositive' => true,
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea',
					'affect_on_change_rule' => 'border-top-left-radius,border-top-right-radius',
					'section' => 'styling',
					'ext' => 'px',
				),
				array(
					'label' => __( 'Radius - Bottom', 'lc-acf-integration' ),
					'id' => 'css_border_radius_bottom',
					'onlypositive' => true,
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea',
					'affect_on_change_rule' => 'border-bottom-left-radius,border-bottom-right-radius',
					'section' => 'styling',
					'ext' => 'px',
				),
			array(
				'id' => 'css_border_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'styling',
			),
			array(
				'label' => __( 'Margin', 'lc-acf-integration' ),
				'id' => 'css_margin_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'styling',
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_margin_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea',
					'affect_on_change_rule' => 'margin-top',
					'section' => 'styling',
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_margin_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea',
					'affect_on_change_rule' => 'margin-right',
					'section' => 'styling',
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_margin_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea',
					'affect_on_change_rule' => 'margin-bottom',
					'section' => 'styling',
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_margin_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea',
					'affect_on_change_rule' => 'margin-left',
					'section' => 'styling',
					'ext' => 'px',
				),
			array(
				'id' => 'css_margin_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'styling',
			),
			array(
				'label' => __( 'Padding', 'lc-acf-integration' ),
				'id' => 'css_padding_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'styling',
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_padding_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea',
					'affect_on_change_rule' => 'padding-top',
					'section' => 'styling',
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_padding_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea',
					'affect_on_change_rule' => 'padding-right',
					'section' => 'styling',
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_padding_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea',
					'affect_on_change_rule' => 'padding-bottom',
					'section' => 'styling',
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_padding_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea',
					'affect_on_change_rule' => 'padding-left',
					'section' => 'styling',
					'ext' => 'px',
				),
			array(
				'id' => 'css_padding_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'styling',
			),
			array(
				'label' => __( 'Minimum Height', 'lc-acf-integration' ),
				'id' => 'css_min_height',
				'std' => '0',
				'type' => 'slider',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea',
				'affect_on_change_rule' => 'min-height',
				'section' => 'styling',
				'ext' => 'px',
				'min' => 0,
				'max' => 1000,
				'increment' => 5,
			),
			array(
				'label' => __( 'Box Shadow', 'lc-acf-integration' ),
				'id' => 'css_main_box_shadow',
				'std' => '',
				'type' => 'box_shadow',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea',
				'affect_on_change_rule' => 'box-shadow',
				'section' => 'styling',
			),

			/**
			 * Content
			 */

			array(
				'label' => __( 'Text Align', 'lc-acf-integration' ),
				'id' => 'css_content_text_align',
				'std' => 'left',
				'type' => 'text_align',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea, .lc-acf-module-textarea p',
				'affect_on_change_rule' => 'text-align',
				'section' => 'styling',
				'tab' => __( 'Content', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'Font', 'lc-acf-integration' ),
				'id' => 'css_content_font_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'styling',
				'tab' => __( 'Content', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Color', 'lc-acf-integration' ),
					'id' => 'css_content_color',
					'std' => '',
					'type' => 'color',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea, .lc-acf-module-textarea p',
					'affect_on_change_rule' => 'color',
					'section' => 'styling',
					'tab' => __( 'Content', 'lc-acf-integration' ),
				),
				array(
					'label' => __( 'Font Size', 'lc-acf-integration' ),
					'id' => 'css_content_font_size',
					'std' => '13',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea, .lc-acf-module-textarea p',
					'affect_on_change_rule' => 'font-size',
					'section' => 'styling',
					'tab' => __( 'Content', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Line Height', 'lc-acf-integration' ),
					'id' => 'css_content_line_height',
					'std' => '22',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea, .lc-acf-module-textarea p',
					'affect_on_change_rule' => 'line-height',
					'section' => 'styling',
					'tab' => __( 'Content', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Font Weight', 'lc-acf-integration' ),
					'id' => 'css_content_font_weight',
					'std' => '400',
					'type' => 'select',
					'choices' => array(
						array(
							'label' => '100 - Thin',
							'value' => '100',
						),
						array(
							'label' => '200 - Extra Light',
							'value' => '200',
						),
						array(
							'label' => '300 - Light',
							'value' => '300',
						),
						array(
							'label' => '400 - Normal',
							'value' => '400',
						),
						array(
							'label' => '500 - Medium',
							'value' => '500',
						),
						array(
							'label' => '600 - Semi Bold',
							'value' => '600',
						),
						array(
							'label' => '700 - Bold',
							'value' => '700',
						),
						array(
							'label' => '800 - Extra Bold',
							'value' => '800',
						),
						array(
							'label' => '900 - Black',
							'value' => '900',
						),
					),
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea, .lc-acf-module-textarea p',
					'affect_on_change_rule' => 'font-weight',
					'section' => 'styling',
					'tab' => __( 'Content', 'lc-acf-integration' ),
					'ext' => '',
				),
				array(
					'label' => __( 'Font Family', 'lc-acf-integration' ),
					'id' => 'css_content_font_family',
					'std' => 'Open Sans',
					'type' => 'font',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea, .lc-acf-module-textarea p',
					'affect_on_change_rule' => 'font-family',
					'section' => 'styling',
					'tab' => __( 'Content', 'lc-acf-integration' ),
				),
				array(
					'label' => __( 'Font Style', 'lc-acf-integration' ),
					'id' => 'css_content_font_style',
					'std' => 'normal',
					'type' => 'select',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea, .lc-acf-module-textarea p',
					'affect_on_change_rule' => 'font-style',
					'section' => 'styling',
					'tab' => __( 'Content', 'lc-acf-integration' ),
					'choices' => array(
						array(
							'label' => __( 'Normal', 'lc-acf-integration' ),
							'value' => 'normal',
						),
						array(
							'label' => __( 'Italic', 'lc-acf-integration' ),
							'value' => 'italic',
						),
					),
				),
				array(
					'label' => __( 'Letter Spacing', 'lc-acf-integration' ),
					'id' => 'css_content_letter_spacing',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea, .lc-acf-module-textarea p',
					'affect_on_change_rule' => 'letter-spacing',
					'section' => 'styling',
					'tab' => __( 'Content', 'lc-acf-integration' ),
					'ext' => 'px',
					'min' => -50,
					'max' => 50,
				),
			array(
				'id' => 'css_content_font_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'styling',
			),
			array(
				'label' => __( 'Margin ( paragraph )', 'lc-acf-integration' ),
				'id' => 'css_content_margin_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'styling',
				'tab' => __( 'Content', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_content_margin_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea p',
					'affect_on_change_rule' => 'margin-top',
					'section' => 'styling',
					'tab' => __( 'Content', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_content_margin_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea p',
					'affect_on_change_rule' => 'margin-right',
					'section' => 'styling',
					'tab' => __( 'Content', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_content_margin_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea p',
					'affect_on_change_rule' => 'margin-bottom',
					'section' => 'styling',
					'tab' => __( 'Content', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_content_margin_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea p',
					'affect_on_change_rule' => 'margin-left',
					'section' => 'styling',
					'tab' => __( 'Content', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_content_margin_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'styling',
			),
			array(
				'label' => __( 'Padding ( paragraph )', 'lc-acf-integration' ),
				'id' => 'css_content_padding_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'styling',
				'tab' => __( 'Content', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_content_padding_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea p',
					'affect_on_change_rule' => 'padding-top',
					'section' => 'styling',
					'tab' => __( 'Content', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_content_padding_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea p',
					'affect_on_change_rule' => 'padding-right',
					'section' => 'styling',
					'tab' => __( 'Content', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_content_padding_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea p',
					'affect_on_change_rule' => 'padding-bottom',
					'section' => 'styling',
					'tab' => __( 'Content', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_content_padding_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea p',
					'affect_on_change_rule' => 'padding-left',
					'section' => 'styling',
					'tab' => __( 'Content', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_content_padding_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'styling',
			),
			array(
				'label' => __( 'Text Shadow', 'lc-acf-integration' ),
				'id' => 'css_main_text_shadow',
				'std' => '',
				'type' => 'text_shadow',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea p',
				'affect_on_change_rule' => 'text-shadow',
				'section' => 'styling',
				'tab' => __( 'Content', 'lc-acf-integration' ),
			),

			/**
			 * Heading 1
			 */

			array(
				'label' => __( 'Text Align', 'lc-acf-integration' ),
				'id' => 'css_h1_text_align',
				'std' => 'left',
				'type' => 'text_align',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea h1',
				'affect_on_change_rule' => 'text-align',
				'section' => 'styling',
				'tab' => __( 'H1', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'BG Color', 'lc-acf-integration' ),
				'id' => 'css_h1_bg_color',
				'std' => '',
				'type' => 'color',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea h1',
				'affect_on_change_rule' => 'background-color',
				'section' => 'styling',
				'tab' => __( 'H1', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'Border', 'lc-acf-integration' ),
				'id' => 'css_h1_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'styling',
				'tab' => __( 'H1', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Color', 'lc-acf-integration' ),
					'id' => 'css_h1_color',
					'std' => '',
					'type' => 'color',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h1',
					'affect_on_change_rule' => 'border-color',
					'section' => 'styling',
					'tab' => __( 'H1', 'lc-acf-integration' ),
				),
				array(
					'label' => __( 'Width', 'lc-acf-integration' ),
					'id' => 'css_h1_width',
					'onlypositive' => true,
					'max' => 10,
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h1',
					'affect_on_change_rule' => 'border-width',
					'section' => 'styling',
					'ext' => 'px',
					'tab' => __( 'H1', 'lc-acf-integration' ),
				),
				array(
					'label' => __( 'Borders', 'lc-acf-integration' ),
					'id' => 'css_h1_trbl',
					'std' => 'top right bottom left',
					'type' => 'checkbox',
					'choices' => array(
						array(
							'label' => __( 'Top', 'lc-acf-integration' ),
							'value' => 'top',
						),
						array(
							'label' => __( 'Right', 'lc-acf-integration' ),
							'value' => 'right',
						),
						array(
							'label' => __( 'Bottom', 'lc-acf-integration' ),
							'value' => 'bottom',
						),
						array(
							'label' => __( 'Left', 'lc-acf-integration' ),
							'value' => 'left',
						),
					),
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h1',
					'affect_on_change_rule' => 'border-style',
					'section' => 'styling',
					'tab' => __( 'H1', 'lc-acf-integration' ),
				),
				array(
					'label' => __( 'Radius - Top', 'lc-acf-integration' ),
					'id' => 'css_h1_radius_top',
					'onlypositive' => true,
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h1',
					'affect_on_change_rule' => 'border-top-left-radius,border-top-right-radius',
					'section' => 'styling',
					'tab' => __( 'H1', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Radius - Bottom', 'lc-acf-integration' ),
					'id' => 'css_h1_radius_bottom',
					'onlypositive' => true,
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h1',
					'affect_on_change_rule' => 'border-bottom-left-radius,border-bottom-right-radius',
					'section' => 'styling',
					'tab' => __( 'H1', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_h1_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'styling',
			),
			array(
				'label' => __( 'Font', 'lc-acf-integration' ),
				'id' => 'css_h1_font_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'styling',
				'tab' => __( 'H1', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Color', 'lc-acf-integration' ),
					'id' => 'css_h1_color',
					'std' => '',
					'type' => 'color',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h1',
					'affect_on_change_rule' => 'color',
					'section' => 'styling',
					'tab' => __( 'H1', 'lc-acf-integration' ),
				),
				array(
					'label' => __( 'Font Size', 'lc-acf-integration' ),
					'id' => 'css_h1_font_size',
					'std' => '13',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h1',
					'affect_on_change_rule' => 'font-size',
					'section' => 'styling',
					'tab' => __( 'H1', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Line Height', 'lc-acf-integration' ),
					'id' => 'css_h1_line_height',
					'std' => '22',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h1',
					'affect_on_change_rule' => 'line-height',
					'section' => 'styling',
					'tab' => __( 'H1', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Font Weight', 'lc-acf-integration' ),
					'id' => 'css_h1_font_weight',
					'std' => '400',
					'type' => 'select',
					'choices' => array(
						array(
							'label' => '100 - Thin',
							'value' => '100',
						),
						array(
							'label' => '200 - Extra Light',
							'value' => '200',
						),
						array(
							'label' => '300 - Light',
							'value' => '300',
						),
						array(
							'label' => '400 - Normal',
							'value' => '400',
						),
						array(
							'label' => '500 - Medium',
							'value' => '500',
						),
						array(
							'label' => '600 - Semi Bold',
							'value' => '600',
						),
						array(
							'label' => '700 - Bold',
							'value' => '700',
						),
						array(
							'label' => '800 - Extra Bold',
							'value' => '800',
						),
						array(
							'label' => '900 - Black',
							'value' => '900',
						),
					),
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h1',
					'affect_on_change_rule' => 'font-weight',
					'section' => 'styling',
					'tab' => __( 'H1', 'lc-acf-integration' ),
					'ext' => '',
				),
				array(
					'label' => __( 'Font Family', 'lc-acf-integration' ),
					'id' => 'css_h1_font_family',
					'std' => 'Open Sans',
					'type' => 'font',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h1',
					'affect_on_change_rule' => 'font-family',
					'section' => 'styling',
					'tab' => __( 'H1', 'lc-acf-integration' ),
				),
				array(
					'label' => __( 'Font Style', 'lc-acf-integration' ),
					'id' => 'css_h1_font_style',
					'std' => 'normal',
					'type' => 'select',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h1',
					'affect_on_change_rule' => 'font-style',
					'section' => 'styling',
					'tab' => __( 'H1', 'lc-acf-integration' ),
					'choices' => array(
						array(
							'label' => __( 'Normal', 'lc-acf-integration' ),
							'value' => 'normal',
						),
						array(
							'label' => __( 'Italic', 'lc-acf-integration' ),
							'value' => 'italic',
						),
					),
				),
				array(
					'label' => __( 'Letter Spacing', 'lc-acf-integration' ),
					'id' => 'css_h1_letter_spacing',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h1',
					'affect_on_change_rule' => 'letter-spacing',
					'section' => 'styling',
					'tab' => __( 'H1', 'lc-acf-integration' ),
					'ext' => 'px',
					'min' => -50,
					'max' => 50,
				),
			array(
				'id' => 'css_h1_font_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'styling',
			),
			array(
				'label' => __( 'Margin', 'lc-acf-integration' ),
				'id' => 'css_h1_margin_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'styling',
				'tab' => __( 'H1', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_h1_margin_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h1',
					'affect_on_change_rule' => 'margin-top',
					'section' => 'styling',
					'tab' => __( 'H1', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_h1_margin_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h1',
					'affect_on_change_rule' => 'margin-right',
					'section' => 'styling',
					'tab' => __( 'H1', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_h1_margin_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h1',
					'affect_on_change_rule' => 'margin-bottom',
					'section' => 'styling',
					'tab' => __( 'H1', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_h1_margin_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h1',
					'affect_on_change_rule' => 'margin-left',
					'section' => 'styling',
					'tab' => __( 'H1', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_h1_margin_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'styling',
			),
			array(
				'label' => __( 'Padding', 'lc-acf-integration' ),
				'id' => 'css_h1_padding_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'styling',
				'tab' => __( 'H1', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_h1_padding_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h1',
					'affect_on_change_rule' => 'padding-top',
					'section' => 'styling',
					'tab' => __( 'H1', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_h1_padding_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h1',
					'affect_on_change_rule' => 'padding-right',
					'section' => 'styling',
					'tab' => __( 'H1', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_h1_padding_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h1',
					'affect_on_change_rule' => 'padding-bottom',
					'section' => 'styling',
					'tab' => __( 'H1', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_h1_padding_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h1',
					'affect_on_change_rule' => 'padding-left',
					'section' => 'styling',
					'tab' => __( 'H1', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_h1_padding_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'styling',
			),
			array(
				'label' => __( 'Text Shadow', 'lc-acf-integration' ),
				'id' => 'css_h1_text_shadow',
				'std' => '',
				'type' => 'text_shadow',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea h1',
				'affect_on_change_rule' => 'text-shadow',
				'section' => 'styling',
				'tab' => __( 'H1', 'lc-acf-integration' ),
			),

			/**
			 * Heading 2
			 */

			array(
				'label' => __( 'Text Align', 'lc-acf-integration' ),
				'id' => 'css_h2_text_align',
				'std' => 'left',
				'type' => 'text_align',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea h2',
				'affect_on_change_rule' => 'text-align',
				'section' => 'styling',
				'tab' => __( 'H2', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'BG Color', 'lc-acf-integration' ),
				'id' => 'css_h2_bg_color',
				'std' => '',
				'type' => 'color',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea h2',
				'affect_on_change_rule' => 'background-color',
				'section' => 'styling',
				'tab' => __( 'H2', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'Border', 'lc-acf-integration' ),
				'id' => 'css_h2_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'styling',
				'tab' => __( 'H2', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Color', 'lc-acf-integration' ),
					'id' => 'css_h2_color',
					'std' => '',
					'type' => 'color',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h2',
					'affect_on_change_rule' => 'border-color',
					'section' => 'styling',
					'tab' => __( 'H2', 'lc-acf-integration' ),
				),
				array(
					'label' => __( 'Width', 'lc-acf-integration' ),
					'id' => 'css_h2_width',
					'onlypositive' => true,
					'max' => 10,
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h2',
					'affect_on_change_rule' => 'border-width',
					'section' => 'styling',
					'ext' => 'px',
					'tab' => __( 'H2', 'lc-acf-integration' ),
				),
				array(
					'label' => __( 'Borders', 'lc-acf-integration' ),
					'id' => 'css_h2_trbl',
					'std' => 'top right bottom left',
					'type' => 'checkbox',
					'choices' => array(
						array(
							'label' => __( 'Top', 'lc-acf-integration' ),
							'value' => 'top',
						),
						array(
							'label' => __( 'Right', 'lc-acf-integration' ),
							'value' => 'right',
						),
						array(
							'label' => __( 'Bottom', 'lc-acf-integration' ),
							'value' => 'bottom',
						),
						array(
							'label' => __( 'Left', 'lc-acf-integration' ),
							'value' => 'left',
						),
					),
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h2',
					'affect_on_change_rule' => 'border-style',
					'section' => 'styling',
					'tab' => __( 'H2', 'lc-acf-integration' ),
				),
				array(
					'label' => __( 'Radius - Top', 'lc-acf-integration' ),
					'id' => 'css_h2_radius_top',
					'onlypositive' => true,
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h2',
					'affect_on_change_rule' => 'border-top-left-radius,border-top-right-radius',
					'section' => 'styling',
					'tab' => __( 'H2', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Radius - Bottom', 'lc-acf-integration' ),
					'id' => 'css_h2_radius_bottom',
					'onlypositive' => true,
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h2',
					'affect_on_change_rule' => 'border-bottom-left-radius,border-bottom-right-radius',
					'section' => 'styling',
					'tab' => __( 'H2', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_h2_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'styling',
			),
			array(
				'label' => __( 'Font', 'lc-acf-integration' ),
				'id' => 'css_h2_font_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'styling',
				'tab' => __( 'H2', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Color', 'lc-acf-integration' ),
					'id' => 'css_h2_color',
					'std' => '',
					'type' => 'color',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h2',
					'affect_on_change_rule' => 'color',
					'section' => 'styling',
					'tab' => __( 'H2', 'lc-acf-integration' ),
				),
				array(
					'label' => __( 'Font Size', 'lc-acf-integration' ),
					'id' => 'css_h2_font_size',
					'std' => '13',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h2',
					'affect_on_change_rule' => 'font-size',
					'section' => 'styling',
					'tab' => __( 'H2', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Line Height', 'lc-acf-integration' ),
					'id' => 'css_h2_line_height',
					'std' => '22',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h2',
					'affect_on_change_rule' => 'line-height',
					'section' => 'styling',
					'tab' => __( 'H2', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Font Weight', 'lc-acf-integration' ),
					'id' => 'css_h2_font_weight',
					'std' => '400',
					'type' => 'select',
					'choices' => array(
						array(
							'label' => '100 - Thin',
							'value' => '100',
						),
						array(
							'label' => '200 - Extra Light',
							'value' => '200',
						),
						array(
							'label' => '300 - Light',
							'value' => '300',
						),
						array(
							'label' => '400 - Normal',
							'value' => '400',
						),
						array(
							'label' => '500 - Medium',
							'value' => '500',
						),
						array(
							'label' => '600 - Semi Bold',
							'value' => '600',
						),
						array(
							'label' => '700 - Bold',
							'value' => '700',
						),
						array(
							'label' => '800 - Extra Bold',
							'value' => '800',
						),
						array(
							'label' => '900 - Black',
							'value' => '900',
						),
					),
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h2',
					'affect_on_change_rule' => 'font-weight',
					'section' => 'styling',
					'tab' => __( 'H2', 'lc-acf-integration' ),
					'ext' => '',
				),
				array(
					'label' => __( 'Font Family', 'lc-acf-integration' ),
					'id' => 'css_h2_font_family',
					'std' => 'Open Sans',
					'type' => 'font',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h2',
					'affect_on_change_rule' => 'font-family',
					'section' => 'styling',
					'tab' => __( 'H2', 'lc-acf-integration' ),
				),
				array(
					'label' => __( 'Font Style', 'lc-acf-integration' ),
					'id' => 'css_h2_font_style',
					'std' => 'normal',
					'type' => 'select',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h2',
					'affect_on_change_rule' => 'font-style',
					'section' => 'styling',
					'tab' => __( 'H2', 'lc-acf-integration' ),
					'choices' => array(
						array(
							'label' => __( 'Normal', 'lc-acf-integration' ),
							'value' => 'normal',
						),
						array(
							'label' => __( 'Italic', 'lc-acf-integration' ),
							'value' => 'italic',
						),
					),
				),
				array(
					'label' => __( 'Letter Spacing', 'lc-acf-integration' ),
					'id' => 'css_h2_letter_spacing',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h2',
					'affect_on_change_rule' => 'letter-spacing',
					'section' => 'styling',
					'tab' => __( 'H2', 'lc-acf-integration' ),
					'ext' => 'px',
					'min' => -50,
					'max' => 50,
				),
			array(
				'id' => 'css_h2_font_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'styling',
			),
			array(
				'label' => __( 'Margin', 'lc-acf-integration' ),
				'id' => 'css_h2_margin_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'styling',
				'tab' => __( 'H2', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_h2_margin_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h2',
					'affect_on_change_rule' => 'margin-top',
					'section' => 'styling',
					'tab' => __( 'H2', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_h2_margin_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h2',
					'affect_on_change_rule' => 'margin-right',
					'section' => 'styling',
					'tab' => __( 'H2', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_h2_margin_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h2',
					'affect_on_change_rule' => 'margin-bottom',
					'section' => 'styling',
					'tab' => __( 'H2', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_h2_margin_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h2',
					'affect_on_change_rule' => 'margin-left',
					'section' => 'styling',
					'tab' => __( 'H2', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_h2_margin_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'styling',
			),
			array(
				'label' => __( 'Padding', 'lc-acf-integration' ),
				'id' => 'css_h2_padding_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'styling',
				'tab' => __( 'H2', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_h2_padding_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h2',
					'affect_on_change_rule' => 'padding-top',
					'section' => 'styling',
					'tab' => __( 'H2', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_h2_padding_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h2',
					'affect_on_change_rule' => 'padding-right',
					'section' => 'styling',
					'tab' => __( 'H2', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_h2_padding_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h2',
					'affect_on_change_rule' => 'padding-bottom',
					'section' => 'styling',
					'tab' => __( 'H2', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_h2_padding_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h2',
					'affect_on_change_rule' => 'padding-left',
					'section' => 'styling',
					'tab' => __( 'H2', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_h2_padding_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'styling',
			),
			array(
				'label' => __( 'Text Shadow', 'lc-acf-integration' ),
				'id' => 'css_h2_text_shadow',
				'std' => '',
				'type' => 'text_shadow',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea h2',
				'affect_on_change_rule' => 'text-shadow',
				'section' => 'styling',
				'tab' => __( 'H2', 'lc-acf-integration' ),
			),

			/**
			 * Heading 3
			 */

			array(
				'label' => __( 'Text Align', 'lc-acf-integration' ),
				'id' => 'css_h3_text_align',
				'std' => 'left',
				'type' => 'text_align',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea h3',
				'affect_on_change_rule' => 'text-align',
				'section' => 'styling',
				'tab' => __( 'H3', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'BG Color', 'lc-acf-integration' ),
				'id' => 'css_h3_bg_color',
				'std' => '',
				'type' => 'color',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea h3',
				'affect_on_change_rule' => 'background-color',
				'section' => 'styling',
				'tab' => __( 'H3', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'Border', 'lc-acf-integration' ),
				'id' => 'css_h3_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'styling',
				'tab' => __( 'H3', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Color', 'lc-acf-integration' ),
					'id' => 'css_h3_color',
					'std' => '',
					'type' => 'color',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h3',
					'affect_on_change_rule' => 'border-color',
					'section' => 'styling',
					'tab' => __( 'H3', 'lc-acf-integration' ),
				),
				array(
					'label' => __( 'Width', 'lc-acf-integration' ),
					'id' => 'css_h3_width',
					'onlypositive' => true,
					'max' => 10,
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h3',
					'affect_on_change_rule' => 'border-width',
					'section' => 'styling',
					'ext' => 'px',
					'tab' => __( 'H3', 'lc-acf-integration' ),
				),
				array(
					'label' => __( 'Borders', 'lc-acf-integration' ),
					'id' => 'css_h3_trbl',
					'std' => 'top right bottom left',
					'type' => 'checkbox',
					'choices' => array(
						array(
							'label' => __( 'Top', 'lc-acf-integration' ),
							'value' => 'top',
						),
						array(
							'label' => __( 'Right', 'lc-acf-integration' ),
							'value' => 'right',
						),
						array(
							'label' => __( 'Bottom', 'lc-acf-integration' ),
							'value' => 'bottom',
						),
						array(
							'label' => __( 'Left', 'lc-acf-integration' ),
							'value' => 'left',
						),
					),
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h3',
					'affect_on_change_rule' => 'border-style',
					'section' => 'styling',
					'tab' => __( 'H3', 'lc-acf-integration' ),
				),
				array(
					'label' => __( 'Radius - Top', 'lc-acf-integration' ),
					'id' => 'css_h3_radius_top',
					'onlypositive' => true,
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h3',
					'affect_on_change_rule' => 'border-top-left-radius,border-top-right-radius',
					'section' => 'styling',
					'tab' => __( 'H3', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Radius - Bottom', 'lc-acf-integration' ),
					'id' => 'css_h3_radius_bottom',
					'onlypositive' => true,
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h3',
					'affect_on_change_rule' => 'border-bottom-left-radius,border-bottom-right-radius',
					'section' => 'styling',
					'tab' => __( 'H3', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_h3_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'styling',
			),
			array(
				'label' => __( 'Font', 'lc-acf-integration' ),
				'id' => 'css_h3_font_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'styling',
				'tab' => __( 'H3', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Color', 'lc-acf-integration' ),
					'id' => 'css_h3_color',
					'std' => '',
					'type' => 'color',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h3',
					'affect_on_change_rule' => 'color',
					'section' => 'styling',
					'tab' => __( 'H3', 'lc-acf-integration' ),
				),
				array(
					'label' => __( 'Font Size', 'lc-acf-integration' ),
					'id' => 'css_h3_font_size',
					'std' => '13',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h3',
					'affect_on_change_rule' => 'font-size',
					'section' => 'styling',
					'tab' => __( 'H3', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Line Height', 'lc-acf-integration' ),
					'id' => 'css_h3_line_height',
					'std' => '22',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h3',
					'affect_on_change_rule' => 'line-height',
					'section' => 'styling',
					'tab' => __( 'H3', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Font Weight', 'lc-acf-integration' ),
					'id' => 'css_h3_font_weight',
					'std' => '400',
					'type' => 'select',
					'choices' => array(
						array(
							'label' => '100 - Thin',
							'value' => '100',
						),
						array(
							'label' => '200 - Extra Light',
							'value' => '200',
						),
						array(
							'label' => '300 - Light',
							'value' => '300',
						),
						array(
							'label' => '400 - Normal',
							'value' => '400',
						),
						array(
							'label' => '500 - Medium',
							'value' => '500',
						),
						array(
							'label' => '600 - Semi Bold',
							'value' => '600',
						),
						array(
							'label' => '700 - Bold',
							'value' => '700',
						),
						array(
							'label' => '800 - Extra Bold',
							'value' => '800',
						),
						array(
							'label' => '900 - Black',
							'value' => '900',
						),
					),
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h3',
					'affect_on_change_rule' => 'font-weight',
					'section' => 'styling',
					'tab' => __( 'H3', 'lc-acf-integration' ),
					'ext' => '',
				),
				array(
					'label' => __( 'Font Family', 'lc-acf-integration' ),
					'id' => 'css_h3_font_family',
					'std' => 'Open Sans',
					'type' => 'font',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h3',
					'affect_on_change_rule' => 'font-family',
					'section' => 'styling',
					'tab' => __( 'H3', 'lc-acf-integration' ),
				),
				array(
					'label' => __( 'Font Style', 'lc-acf-integration' ),
					'id' => 'css_h3_font_style',
					'std' => 'normal',
					'type' => 'select',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h3',
					'affect_on_change_rule' => 'font-style',
					'section' => 'styling',
					'tab' => __( 'H3', 'lc-acf-integration' ),
					'choices' => array(
						array(
							'label' => __( 'Normal', 'lc-acf-integration' ),
							'value' => 'normal',
						),
						array(
							'label' => __( 'Italic', 'lc-acf-integration' ),
							'value' => 'italic',
						),
					),
				),
				array(
					'label' => __( 'Letter Spacing', 'lc-acf-integration' ),
					'id' => 'css_h3_letter_spacing',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h3',
					'affect_on_change_rule' => 'letter-spacing',
					'section' => 'styling',
					'tab' => __( 'H3', 'lc-acf-integration' ),
					'ext' => 'px',
					'min' => -50,
					'max' => 50,
				),
			array(
				'id' => 'css_h3_font_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'styling',
			),
			array(
				'label' => __( 'Margin', 'lc-acf-integration' ),
				'id' => 'css_h3_margin_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'styling',
				'tab' => __( 'H3', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_h3_margin_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h3',
					'affect_on_change_rule' => 'margin-top',
					'section' => 'styling',
					'tab' => __( 'H3', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_h3_margin_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h3',
					'affect_on_change_rule' => 'margin-right',
					'section' => 'styling',
					'tab' => __( 'H3', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_h3_margin_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h3',
					'affect_on_change_rule' => 'margin-bottom',
					'section' => 'styling',
					'tab' => __( 'H3', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_h3_margin_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h3',
					'affect_on_change_rule' => 'margin-left',
					'section' => 'styling',
					'tab' => __( 'H3', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_h3_margin_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'styling',
			),
			array(
				'label' => __( 'Padding', 'lc-acf-integration' ),
				'id' => 'css_h3_padding_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'styling',
				'tab' => __( 'H3', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_h3_padding_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h3',
					'affect_on_change_rule' => 'padding-top',
					'section' => 'styling',
					'tab' => __( 'H3', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_h3_padding_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h3',
					'affect_on_change_rule' => 'padding-right',
					'section' => 'styling',
					'tab' => __( 'H3', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_h3_padding_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h3',
					'affect_on_change_rule' => 'padding-bottom',
					'section' => 'styling',
					'tab' => __( 'H3', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_h3_padding_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h3',
					'affect_on_change_rule' => 'padding-left',
					'section' => 'styling',
					'tab' => __( 'H3', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_h3_padding_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'styling',
			),
			array(
				'label' => __( 'Text Shadow', 'lc-acf-integration' ),
				'id' => 'css_h3_text_shadow',
				'std' => '',
				'type' => 'text_shadow',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea h3',
				'affect_on_change_rule' => 'text-shadow',
				'section' => 'styling',
				'tab' => __( 'H3', 'lc-acf-integration' ),
			),

			/**
			 * Heading 4
			 */

			array(
				'label' => __( 'Text Align', 'lc-acf-integration' ),
				'id' => 'css_h4_text_align',
				'std' => 'left',
				'type' => 'text_align',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea h4',
				'affect_on_change_rule' => 'text-align',
				'section' => 'styling',
				'tab' => __( 'H4', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'BG Color', 'lc-acf-integration' ),
				'id' => 'css_h4_bg_color',
				'std' => '',
				'type' => 'color',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea h4',
				'affect_on_change_rule' => 'background-color',
				'section' => 'styling',
				'tab' => __( 'H4', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'Border', 'lc-acf-integration' ),
				'id' => 'css_h4_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'styling',
				'tab' => __( 'H4', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Color', 'lc-acf-integration' ),
					'id' => 'css_h4_color',
					'std' => '',
					'type' => 'color',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h4',
					'affect_on_change_rule' => 'border-color',
					'section' => 'styling',
					'tab' => __( 'H4', 'lc-acf-integration' ),
				),
				array(
					'label' => __( 'Width', 'lc-acf-integration' ),
					'id' => 'css_h4_width',
					'onlypositive' => true,
					'max' => 10,
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h4',
					'affect_on_change_rule' => 'border-width',
					'section' => 'styling',
					'ext' => 'px',
					'tab' => __( 'H4', 'lc-acf-integration' ),
				),
				array(
					'label' => __( 'Borders', 'lc-acf-integration' ),
					'id' => 'css_h4_trbl',
					'std' => 'top right bottom left',
					'type' => 'checkbox',
					'choices' => array(
						array(
							'label' => __( 'Top', 'lc-acf-integration' ),
							'value' => 'top',
						),
						array(
							'label' => __( 'Right', 'lc-acf-integration' ),
							'value' => 'right',
						),
						array(
							'label' => __( 'Bottom', 'lc-acf-integration' ),
							'value' => 'bottom',
						),
						array(
							'label' => __( 'Left', 'lc-acf-integration' ),
							'value' => 'left',
						),
					),
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h4',
					'affect_on_change_rule' => 'border-style',
					'section' => 'styling',
					'tab' => __( 'H4', 'lc-acf-integration' ),
				),
				array(
					'label' => __( 'Radius - Top', 'lc-acf-integration' ),
					'id' => 'css_h4_radius_top',
					'onlypositive' => true,
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h4',
					'affect_on_change_rule' => 'border-top-left-radius,border-top-right-radius',
					'section' => 'styling',
					'tab' => __( 'H4', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Radius - Bottom', 'lc-acf-integration' ),
					'id' => 'css_h4_radius_bottom',
					'onlypositive' => true,
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h4',
					'affect_on_change_rule' => 'border-bottom-left-radius,border-bottom-right-radius',
					'section' => 'styling',
					'tab' => __( 'H4', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_h4_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'styling',
			),
			array(
				'label' => __( 'Font', 'lc-acf-integration' ),
				'id' => 'css_h4_font_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'styling',
				'tab' => __( 'H4', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Color', 'lc-acf-integration' ),
					'id' => 'css_h4_color',
					'std' => '',
					'type' => 'color',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h4',
					'affect_on_change_rule' => 'color',
					'section' => 'styling',
					'tab' => __( 'H4', 'lc-acf-integration' ),
				),
				array(
					'label' => __( 'Font Size', 'lc-acf-integration' ),
					'id' => 'css_h4_font_size',
					'std' => '13',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h4',
					'affect_on_change_rule' => 'font-size',
					'section' => 'styling',
					'tab' => __( 'H4', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Line Height', 'lc-acf-integration' ),
					'id' => 'css_h4_line_height',
					'std' => '22',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h4',
					'affect_on_change_rule' => 'line-height',
					'section' => 'styling',
					'tab' => __( 'H4', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Font Weight', 'lc-acf-integration' ),
					'id' => 'css_h4_font_weight',
					'std' => '400',
					'type' => 'select',
					'choices' => array(
						array(
							'label' => '100 - Thin',
							'value' => '100',
						),
						array(
							'label' => '200 - Extra Light',
							'value' => '200',
						),
						array(
							'label' => '300 - Light',
							'value' => '300',
						),
						array(
							'label' => '400 - Normal',
							'value' => '400',
						),
						array(
							'label' => '500 - Medium',
							'value' => '500',
						),
						array(
							'label' => '600 - Semi Bold',
							'value' => '600',
						),
						array(
							'label' => '700 - Bold',
							'value' => '700',
						),
						array(
							'label' => '800 - Extra Bold',
							'value' => '800',
						),
						array(
							'label' => '900 - Black',
							'value' => '900',
						),
					),
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h4',
					'affect_on_change_rule' => 'font-weight',
					'section' => 'styling',
					'tab' => __( 'H4', 'lc-acf-integration' ),
					'ext' => '',
				),
				array(
					'label' => __( 'Font Family', 'lc-acf-integration' ),
					'id' => 'css_h4_font_family',
					'std' => 'Open Sans',
					'type' => 'font',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h4',
					'affect_on_change_rule' => 'font-family',
					'section' => 'styling',
					'tab' => __( 'H4', 'lc-acf-integration' ),
				),
				array(
					'label' => __( 'Font Style', 'lc-acf-integration' ),
					'id' => 'css_h4_font_style',
					'std' => 'normal',
					'type' => 'select',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h4',
					'affect_on_change_rule' => 'font-style',
					'section' => 'styling',
					'tab' => __( 'H4', 'lc-acf-integration' ),
					'choices' => array(
						array(
							'label' => __( 'Normal', 'lc-acf-integration' ),
							'value' => 'normal',
						),
						array(
							'label' => __( 'Italic', 'lc-acf-integration' ),
							'value' => 'italic',
						),
					),
				),
				array(
					'label' => __( 'Letter Spacing', 'lc-acf-integration' ),
					'id' => 'css_h4_letter_spacing',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h4',
					'affect_on_change_rule' => 'letter-spacing',
					'section' => 'styling',
					'tab' => __( 'H4', 'lc-acf-integration' ),
					'ext' => 'px',
					'min' => -50,
					'max' => 50,
				),
			array(
				'id' => 'css_h4_font_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'styling',
			),
			array(
				'label' => __( 'Margin', 'lc-acf-integration' ),
				'id' => 'css_h4_margin_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'styling',
				'tab' => __( 'H4', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_h4_margin_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h4',
					'affect_on_change_rule' => 'margin-top',
					'section' => 'styling',
					'tab' => __( 'H4', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_h4_margin_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h4',
					'affect_on_change_rule' => 'margin-right',
					'section' => 'styling',
					'tab' => __( 'H4', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_h4_margin_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h4',
					'affect_on_change_rule' => 'margin-bottom',
					'section' => 'styling',
					'tab' => __( 'H4', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_h4_margin_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h4',
					'affect_on_change_rule' => 'margin-left',
					'section' => 'styling',
					'tab' => __( 'H4', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_h4_margin_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'styling',
			),
			array(
				'label' => __( 'Padding', 'lc-acf-integration' ),
				'id' => 'css_h4_padding_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'styling',
				'tab' => __( 'H4', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_h4_padding_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h4',
					'affect_on_change_rule' => 'padding-top',
					'section' => 'styling',
					'tab' => __( 'H4', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_h4_padding_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h4',
					'affect_on_change_rule' => 'padding-right',
					'section' => 'styling',
					'tab' => __( 'H4', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_h4_padding_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h4',
					'affect_on_change_rule' => 'padding-bottom',
					'section' => 'styling',
					'tab' => __( 'H4', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_h4_padding_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h4',
					'affect_on_change_rule' => 'padding-left',
					'section' => 'styling',
					'tab' => __( 'H4', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_h4_padding_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'styling',
			),
			array(
				'label' => __( 'Text Shadow', 'lc-acf-integration' ),
				'id' => 'css_h4_text_shadow',
				'std' => '',
				'type' => 'text_shadow',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea h4',
				'affect_on_change_rule' => 'text-shadow',
				'section' => 'styling',
				'tab' => __( 'H4', 'lc-acf-integration' ),
			),

			/**
			 * Heading 5
			 */

			array(
				'label' => __( 'Text Align', 'lc-acf-integration' ),
				'id' => 'css_h5_text_align',
				'std' => 'left',
				'type' => 'text_align',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea h5',
				'affect_on_change_rule' => 'text-align',
				'section' => 'styling',
				'tab' => __( 'H5', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'BG Color', 'lc-acf-integration' ),
				'id' => 'css_h5_bg_color',
				'std' => '',
				'type' => 'color',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea h5',
				'affect_on_change_rule' => 'background-color',
				'section' => 'styling',
				'tab' => __( 'H5', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'Border', 'lc-acf-integration' ),
				'id' => 'css_h5_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'styling',
				'tab' => __( 'H5', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Color', 'lc-acf-integration' ),
					'id' => 'css_h5_color',
					'std' => '',
					'type' => 'color',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h5',
					'affect_on_change_rule' => 'border-color',
					'section' => 'styling',
					'tab' => __( 'H5', 'lc-acf-integration' ),
				),
				array(
					'label' => __( 'Width', 'lc-acf-integration' ),
					'id' => 'css_h5_width',
					'onlypositive' => true,
					'max' => 10,
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h5',
					'affect_on_change_rule' => 'border-width',
					'section' => 'styling',
					'ext' => 'px',
					'tab' => __( 'H5', 'lc-acf-integration' ),
				),
				array(
					'label' => __( 'Borders', 'lc-acf-integration' ),
					'id' => 'css_h5_trbl',
					'std' => 'top right bottom left',
					'type' => 'checkbox',
					'choices' => array(
						array(
							'label' => __( 'Top', 'lc-acf-integration' ),
							'value' => 'top',
						),
						array(
							'label' => __( 'Right', 'lc-acf-integration' ),
							'value' => 'right',
						),
						array(
							'label' => __( 'Bottom', 'lc-acf-integration' ),
							'value' => 'bottom',
						),
						array(
							'label' => __( 'Left', 'lc-acf-integration' ),
							'value' => 'left',
						),
					),
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h5',
					'affect_on_change_rule' => 'border-style',
					'section' => 'styling',
					'tab' => __( 'H5', 'lc-acf-integration' ),
				),
				array(
					'label' => __( 'Radius - Top', 'lc-acf-integration' ),
					'id' => 'css_h5_radius_top',
					'onlypositive' => true,
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h5',
					'affect_on_change_rule' => 'border-top-left-radius,border-top-right-radius',
					'section' => 'styling',
					'tab' => __( 'H5', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Radius - Bottom', 'lc-acf-integration' ),
					'id' => 'css_h5_radius_bottom',
					'onlypositive' => true,
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h5',
					'affect_on_change_rule' => 'border-bottom-left-radius,border-bottom-right-radius',
					'section' => 'styling',
					'tab' => __( 'H5', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_h5_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'styling',
			),
			array(
				'label' => __( 'Font', 'lc-acf-integration' ),
				'id' => 'css_h5_font_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'styling',
				'tab' => __( 'H5', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Color', 'lc-acf-integration' ),
					'id' => 'css_h5_color',
					'std' => '',
					'type' => 'color',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h5',
					'affect_on_change_rule' => 'color',
					'section' => 'styling',
					'tab' => __( 'H5', 'lc-acf-integration' ),
				),
				array(
					'label' => __( 'Font Size', 'lc-acf-integration' ),
					'id' => 'css_h5_font_size',
					'std' => '13',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h5',
					'affect_on_change_rule' => 'font-size',
					'section' => 'styling',
					'tab' => __( 'H5', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Line Height', 'lc-acf-integration' ),
					'id' => 'css_h5_line_height',
					'std' => '22',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h5',
					'affect_on_change_rule' => 'line-height',
					'section' => 'styling',
					'tab' => __( 'H5', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Font Weight', 'lc-acf-integration' ),
					'id' => 'css_h5_font_weight',
					'std' => '400',
					'type' => 'select',
					'choices' => array(
						array(
							'label' => '100 - Thin',
							'value' => '100',
						),
						array(
							'label' => '200 - Extra Light',
							'value' => '200',
						),
						array(
							'label' => '300 - Light',
							'value' => '300',
						),
						array(
							'label' => '400 - Normal',
							'value' => '400',
						),
						array(
							'label' => '500 - Medium',
							'value' => '500',
						),
						array(
							'label' => '600 - Semi Bold',
							'value' => '600',
						),
						array(
							'label' => '700 - Bold',
							'value' => '700',
						),
						array(
							'label' => '800 - Extra Bold',
							'value' => '800',
						),
						array(
							'label' => '900 - Black',
							'value' => '900',
						),
					),
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h5',
					'affect_on_change_rule' => 'font-weight',
					'section' => 'styling',
					'tab' => __( 'H5', 'lc-acf-integration' ),
					'ext' => '',
				),
				array(
					'label' => __( 'Font Family', 'lc-acf-integration' ),
					'id' => 'css_h5_font_family',
					'std' => 'Open Sans',
					'type' => 'font',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h5',
					'affect_on_change_rule' => 'font-family',
					'section' => 'styling',
					'tab' => __( 'H5', 'lc-acf-integration' ),
				),
				array(
					'label' => __( 'Font Style', 'lc-acf-integration' ),
					'id' => 'css_h5_font_style',
					'std' => 'normal',
					'type' => 'select',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h5',
					'affect_on_change_rule' => 'font-style',
					'section' => 'styling',
					'tab' => __( 'H5', 'lc-acf-integration' ),
					'choices' => array(
						array(
							'label' => __( 'Normal', 'lc-acf-integration' ),
							'value' => 'normal',
						),
						array(
							'label' => __( 'Italic', 'lc-acf-integration' ),
							'value' => 'italic',
						),
					),
				),
				array(
					'label' => __( 'Letter Spacing', 'lc-acf-integration' ),
					'id' => 'css_h5_letter_spacing',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h5',
					'affect_on_change_rule' => 'letter-spacing',
					'section' => 'styling',
					'tab' => __( 'H5', 'lc-acf-integration' ),
					'ext' => 'px',
					'min' => -50,
					'max' => 50,
				),
			array(
				'id' => 'css_h5_font_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'styling',
			),
			array(
				'label' => __( 'Margin', 'lc-acf-integration' ),
				'id' => 'css_h5_margin_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'styling',
				'tab' => __( 'H5', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_h5_margin_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h5',
					'affect_on_change_rule' => 'margin-top',
					'section' => 'styling',
					'tab' => __( 'H5', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_h5_margin_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h5',
					'affect_on_change_rule' => 'margin-right',
					'section' => 'styling',
					'tab' => __( 'H5', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_h5_margin_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h5',
					'affect_on_change_rule' => 'margin-bottom',
					'section' => 'styling',
					'tab' => __( 'H5', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_h5_margin_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h5',
					'affect_on_change_rule' => 'margin-left',
					'section' => 'styling',
					'tab' => __( 'H5', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_h5_margin_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'styling',
			),
			array(
				'label' => __( 'Padding', 'lc-acf-integration' ),
				'id' => 'css_h5_padding_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'styling',
				'tab' => __( 'H5', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_h5_padding_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h5',
					'affect_on_change_rule' => 'padding-top',
					'section' => 'styling',
					'tab' => __( 'H5', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_h5_padding_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h5',
					'affect_on_change_rule' => 'padding-right',
					'section' => 'styling',
					'tab' => __( 'H5', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_h5_padding_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h5',
					'affect_on_change_rule' => 'padding-bottom',
					'section' => 'styling',
					'tab' => __( 'H5', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_h5_padding_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h5',
					'affect_on_change_rule' => 'padding-left',
					'section' => 'styling',
					'tab' => __( 'H5', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_h5_padding_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'styling',
			),
			array(
				'label' => __( 'Text Shadow', 'lc-acf-integration' ),
				'id' => 'css_h5_text_shadow',
				'std' => '',
				'type' => 'text_shadow',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea h5',
				'affect_on_change_rule' => 'text-shadow',
				'section' => 'styling',
				'tab' => __( 'H5', 'lc-acf-integration' ),
			),

			/**
			 * Heading 6
			 */

			array(
				'label' => __( 'Text Align', 'lc-acf-integration' ),
				'id' => 'css_h6_text_align',
				'std' => 'left',
				'type' => 'text_align',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea h6',
				'affect_on_change_rule' => 'text-align',
				'section' => 'styling',
				'tab' => __( 'H6', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'BG Color', 'lc-acf-integration' ),
				'id' => 'css_h6_bg_color',
				'std' => '',
				'type' => 'color',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea h6',
				'affect_on_change_rule' => 'background-color',
				'section' => 'styling',
				'tab' => __( 'H6', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'Border', 'lc-acf-integration' ),
				'id' => 'css_h6_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'styling',
				'tab' => __( 'H6', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Color', 'lc-acf-integration' ),
					'id' => 'css_h6_color',
					'std' => '',
					'type' => 'color',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h6',
					'affect_on_change_rule' => 'border-color',
					'section' => 'styling',
					'tab' => __( 'H6', 'lc-acf-integration' ),
				),
				array(
					'label' => __( 'Width', 'lc-acf-integration' ),
					'id' => 'css_h6_width',
					'onlypositive' => true,
					'max' => 10,
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h6',
					'affect_on_change_rule' => 'border-width',
					'section' => 'styling',
					'ext' => 'px',
					'tab' => __( 'H6', 'lc-acf-integration' ),
				),
				array(
					'label' => __( 'Borders', 'lc-acf-integration' ),
					'id' => 'css_h6_trbl',
					'std' => 'top right bottom left',
					'type' => 'checkbox',
					'choices' => array(
						array(
							'label' => __( 'Top', 'lc-acf-integration' ),
							'value' => 'top',
						),
						array(
							'label' => __( 'Right', 'lc-acf-integration' ),
							'value' => 'right',
						),
						array(
							'label' => __( 'Bottom', 'lc-acf-integration' ),
							'value' => 'bottom',
						),
						array(
							'label' => __( 'Left', 'lc-acf-integration' ),
							'value' => 'left',
						),
					),
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h6',
					'affect_on_change_rule' => 'border-style',
					'section' => 'styling',
					'tab' => __( 'H6', 'lc-acf-integration' ),
				),
				array(
					'label' => __( 'Radius - Top', 'lc-acf-integration' ),
					'id' => 'css_h6_radius_top',
					'onlypositive' => true,
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h6',
					'affect_on_change_rule' => 'border-top-left-radius,border-top-right-radius',
					'section' => 'styling',
					'tab' => __( 'H6', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Radius - Bottom', 'lc-acf-integration' ),
					'id' => 'css_h6_radius_bottom',
					'onlypositive' => true,
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h6',
					'affect_on_change_rule' => 'border-bottom-left-radius,border-bottom-right-radius',
					'section' => 'styling',
					'tab' => __( 'H6', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_h6_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'styling',
			),
			array(
				'label' => __( 'Font', 'lc-acf-integration' ),
				'id' => 'css_h6_font_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'styling',
				'tab' => __( 'H6', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Color', 'lc-acf-integration' ),
					'id' => 'css_h6_color',
					'std' => '',
					'type' => 'color',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h6',
					'affect_on_change_rule' => 'color',
					'section' => 'styling',
					'tab' => __( 'H6', 'lc-acf-integration' ),
				),
				array(
					'label' => __( 'Font Size', 'lc-acf-integration' ),
					'id' => 'css_h6_font_size',
					'std' => '13',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h6',
					'affect_on_change_rule' => 'font-size',
					'section' => 'styling',
					'tab' => __( 'H6', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Line Height', 'lc-acf-integration' ),
					'id' => 'css_h6_line_height',
					'std' => '22',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h6',
					'affect_on_change_rule' => 'line-height',
					'section' => 'styling',
					'tab' => __( 'H6', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Font Weight', 'lc-acf-integration' ),
					'id' => 'css_h6_font_weight',
					'std' => '400',
					'type' => 'select',
					'choices' => array(
						array(
							'label' => '100 - Thin',
							'value' => '100',
						),
						array(
							'label' => '200 - Extra Light',
							'value' => '200',
						),
						array(
							'label' => '300 - Light',
							'value' => '300',
						),
						array(
							'label' => '400 - Normal',
							'value' => '400',
						),
						array(
							'label' => '500 - Medium',
							'value' => '500',
						),
						array(
							'label' => '600 - Semi Bold',
							'value' => '600',
						),
						array(
							'label' => '700 - Bold',
							'value' => '700',
						),
						array(
							'label' => '800 - Extra Bold',
							'value' => '800',
						),
						array(
							'label' => '900 - Black',
							'value' => '900',
						),
					),
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h6',
					'affect_on_change_rule' => 'font-weight',
					'section' => 'styling',
					'tab' => __( 'H6', 'lc-acf-integration' ),
					'ext' => '',
				),
				array(
					'label' => __( 'Font Family', 'lc-acf-integration' ),
					'id' => 'css_h6_font_family',
					'std' => 'Open Sans',
					'type' => 'font',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h6',
					'affect_on_change_rule' => 'font-family',
					'section' => 'styling',
					'tab' => __( 'H6', 'lc-acf-integration' ),
				),
				array(
					'label' => __( 'Font Style', 'lc-acf-integration' ),
					'id' => 'css_h6_font_style',
					'std' => 'normal',
					'type' => 'select',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h6',
					'affect_on_change_rule' => 'font-style',
					'section' => 'styling',
					'tab' => __( 'H6', 'lc-acf-integration' ),
					'choices' => array(
						array(
							'label' => __( 'Normal', 'lc-acf-integration' ),
							'value' => 'normal',
						),
						array(
							'label' => __( 'Italic', 'lc-acf-integration' ),
							'value' => 'italic',
						),
					),
				),
				array(
					'label' => __( 'Letter Spacing', 'lc-acf-integration' ),
					'id' => 'css_h6_letter_spacing',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h6',
					'affect_on_change_rule' => 'letter-spacing',
					'section' => 'styling',
					'tab' => __( 'H6', 'lc-acf-integration' ),
					'ext' => 'px',
					'min' => -50,
					'max' => 50,
				),
			array(
				'id' => 'css_h6_font_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'styling',
			),
			array(
				'label' => __( 'Margin', 'lc-acf-integration' ),
				'id' => 'css_h6_margin_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'styling',
				'tab' => __( 'H6', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_h6_margin_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h6',
					'affect_on_change_rule' => 'margin-top',
					'section' => 'styling',
					'tab' => __( 'H6', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_h6_margin_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h6',
					'affect_on_change_rule' => 'margin-right',
					'section' => 'styling',
					'tab' => __( 'H6', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_h6_margin_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h6',
					'affect_on_change_rule' => 'margin-bottom',
					'section' => 'styling',
					'tab' => __( 'H6', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_h6_margin_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h6',
					'affect_on_change_rule' => 'margin-left',
					'section' => 'styling',
					'tab' => __( 'H6', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_h6_margin_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'styling',
			),
			array(
				'label' => __( 'Padding', 'lc-acf-integration' ),
				'id' => 'css_h6_padding_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'styling',
				'tab' => __( 'H6', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_h6_padding_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h6',
					'affect_on_change_rule' => 'padding-top',
					'section' => 'styling',
					'tab' => __( 'H6', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_h6_padding_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h6',
					'affect_on_change_rule' => 'padding-right',
					'section' => 'styling',
					'tab' => __( 'H6', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_h6_padding_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h6',
					'affect_on_change_rule' => 'padding-bottom',
					'section' => 'styling',
					'tab' => __( 'H6', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_h6_padding_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h6',
					'affect_on_change_rule' => 'padding-left',
					'section' => 'styling',
					'tab' => __( 'H6', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_h6_padding_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'styling',
			),
			array(
				'label' => __( 'Text Shadow', 'lc-acf-integration' ),
				'id' => 'css_h6_text_shadow',
				'std' => '',
				'type' => 'text_shadow',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea h6',
				'affect_on_change_rule' => 'text-shadow',
				'section' => 'styling',
				'tab' => __( 'H6', 'lc-acf-integration' ),
			),

			/**
			 * Links
			 */

			array(
				'label' => __( 'Link Color', 'lc-acf-integration' ),
				'id' => 'css_link_color',
				'std' => '',
				'type' => 'color',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea a',
				'affect_on_change_rule' => 'color',
				'section' => 'styling',
				'tab' => __( 'Links', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'Link - Hover Color', 'lc-acf-integration' ),
				'id' => 'css_link_color_hover',
				'std' => '',
				'type' => 'color',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea a:hover',
				'affect_on_change_rule' => 'color',
				'section' => 'styling',
				'tab' => __( 'Links', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'Link - Text Shadow', 'lc-acf-integration' ),
				'id' => 'css_link_text_shadow',
				'std' => '',
				'type' => 'text_shadow',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea a',
				'affect_on_change_rule' => 'text-shadow',
				'section' => 'styling',
				'tab' => __( 'Links', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'Blockquote Link - Color', 'lc-acf-integration' ),
				'id' => 'css_blockquote_link_color',
				'std' => '',
				'type' => 'color',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea blockquote a',
				'affect_on_change_rule' => 'color',
				'section' => 'styling',
				'tab' => __( 'Links', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'Blockquote Link - Hover Color', 'lc-acf-integration' ),
				'id' => 'css_blockquote_link_color_hover',
				'std' => '',
				'type' => 'color',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea blockquote a:hover',
				'affect_on_change_rule' => 'color',
				'section' => 'styling',
				'tab' => __( 'Links', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'Blockquote Link - Text Shadow', 'lc-acf-integration' ),
				'id' => 'css_blockquote_link_text_shadow',
				'std' => '',
				'type' => 'text_shadow',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea blockquote a',
				'affect_on_change_rule' => 'text-shadow',
				'section' => 'styling',
				'tab' => __( 'Links', 'lc-acf-integration' ),
			),

			/**
			 * Lists
			 */

			array(
				'label' => __( 'Font', 'lc-acf-integration' ),
				'id' => 'css_lists_font_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'styling',
				'tab' => __( 'Lists', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Color', 'lc-acf-integration' ),
					'id' => 'css_lists_color',
					'std' => '',
					'type' => 'color',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea li',
					'affect_on_change_rule' => 'color',
					'section' => 'styling',
					'tab' => __( 'Lists', 'lc-acf-integration' ),
				),
				array(
					'label' => __( 'Font Size', 'lc-acf-integration' ),
					'id' => 'css_lists_font_size',
					'std' => '13',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea li',
					'affect_on_change_rule' => 'font-size',
					'section' => 'styling',
					'tab' => __( 'Lists', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Line Height', 'lc-acf-integration' ),
					'id' => 'css_lists_line_height',
					'std' => '22',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea li',
					'affect_on_change_rule' => 'line-height',
					'section' => 'styling',
					'tab' => __( 'Lists', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Font Weight', 'lc-acf-integration' ),
					'id' => 'css_lists_font_weight',
					'std' => '400',
					'type' => 'select',
					'choices' => array(
						array(
							'label' => '100 - Thin',
							'value' => '100',
						),
						array(
							'label' => '200 - Extra Light',
							'value' => '200',
						),
						array(
							'label' => '300 - Light',
							'value' => '300',
						),
						array(
							'label' => '400 - Normal',
							'value' => '400',
						),
						array(
							'label' => '500 - Medium',
							'value' => '500',
						),
						array(
							'label' => '600 - Semi Bold',
							'value' => '600',
						),
						array(
							'label' => '700 - Bold',
							'value' => '700',
						),
						array(
							'label' => '800 - Extra Bold',
							'value' => '800',
						),
						array(
							'label' => '900 - Black',
							'value' => '900',
						),
					),
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea li',
					'affect_on_change_rule' => 'font-weight',
					'section' => 'styling',
					'tab' => __( 'Lists', 'lc-acf-integration' ),
					'ext' => '',
				),
				array(
					'label' => __( 'Font Family', 'lc-acf-integration' ),
					'id' => 'css_lists_font_family',
					'std' => 'Open Sans',
					'type' => 'font',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea li',
					'affect_on_change_rule' => 'font-family',
					'section' => 'styling',
					'tab' => __( 'Lists', 'lc-acf-integration' ),
				),
				array(
					'label' => __( 'Font Style', 'lc-acf-integration' ),
					'id' => 'css_lists_font_style',
					'std' => 'normal',
					'type' => 'select',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea li',
					'affect_on_change_rule' => 'font-style',
					'section' => 'styling',
					'tab' => __( 'Lists', 'lc-acf-integration' ),
					'choices' => array(
						array(
							'label' => __( 'Normal', 'lc-acf-integration' ),
							'value' => 'normal',
						),
						array(
							'label' => __( 'Italic', 'lc-acf-integration' ),
							'value' => 'italic',
						),
					),
				),
				array(
					'label' => __( 'Letter Spacing', 'lc-acf-integration' ),
					'id' => 'css_lists_letter_spacing',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea li',
					'affect_on_change_rule' => 'letter-spacing',
					'section' => 'styling',
					'tab' => __( 'Lists', 'lc-acf-integration' ),
					'ext' => 'px',
					'min' => -50,
					'max' => 50,
				),
			array(
				'id' => 'css_lists_font_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'styling',
			),
			array(
				'label' => __( 'Margin', 'lc-acf-integration' ),
				'id' => 'css_lists_margin_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'styling',
				'tab' => __( 'Lists', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_lists_margin_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea ul,.lc-acf-module-textarea ol',
					'affect_on_change_rule' => 'margin-top',
					'section' => 'styling',
					'tab' => __( 'Lists', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_lists_margin_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea ul,.lc-acf-module-textarea ol',
					'affect_on_change_rule' => 'margin-right',
					'section' => 'styling',
					'tab' => __( 'Lists', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_lists_margin_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea ul,.lc-acf-module-textarea ol',
					'affect_on_change_rule' => 'margin-bottom',
					'section' => 'styling',
					'tab' => __( 'Lists', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_lists_margin_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea ul,.lc-acf-module-textarea ol',
					'affect_on_change_rule' => 'margin-left',
					'section' => 'styling',
					'tab' => __( 'Lists', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_lists_margin_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'styling',
			),
			array(
				'label' => __( 'Unordered Style', 'lc-acf-integration' ),
				'id' => 'css_lists_ul_style',
				'std' => 'disc',
				'type' => 'select',
				'choices' => array(
					array(
						'label' => __( 'Armenian', 'lc-acf-integration' ),
						'value' => 'armenian',
					),
					array(
						'label' => __( 'Circle', 'lc-acf-integration' ),
						'value' => 'circle',
					),
					array(
						'label' => __( 'Cjk-ideographic', 'lc-acf-integration' ),
						'value' => 'cjk-ideographic',
					),
					array(
						'label' => __( 'Decimal', 'lc-acf-integration' ),
						'value' => 'decimal',
					),
					array(
						'label' => __( 'Decimal Leading Zero', 'lc-acf-integration' ),
						'value' => 'decimal-leading-zero',
					),
					array(
						'label' => __( 'Hebrew', 'lc-acf-integration' ),
						'value' => 'hebrew',
					),
					array(
						'label' => __( 'Hiragana', 'lc-acf-integration' ),
						'value' => 'hiragana',
					),
					array(
						'label' => __( 'Hiragana Iroha', 'lc-acf-integration' ),
						'value' => 'hiragana-iroha',
					),
					array(
						'label' => __( 'Katakana', 'lc-acf-integration' ),
						'value' => 'katakana',
					),
					array(
						'label' => __( 'Katakana Iroha', 'lc-acf-integration' ),
						'value' => 'katakana-iroha',
					),
					array(
						'label' => __( 'Lower Alpha', 'lc-acf-integration' ),
						'value' => 'lower-alpha',
					),
					array(
						'label' => __( 'Lower Greek', 'lc-acf-integration' ),
						'value' => 'lower-greek',
					),
					array(
						'label' => __( 'Lower Latin', 'lc-acf-integration' ),
						'value' => 'lower-latin',
					),
					array(
						'label' => __( 'Lower Roman', 'lc-acf-integration' ),
						'value' => 'lower-roman',
					),
					array(
						'label' => __( 'None', 'lc-acf-integration' ),
						'value' => 'none',
					),
					array(
						'label' => __( 'Upper Alpha', 'lc-acf-integration' ),
						'value' => 'upper-alpha',
					),
					array(
						'label' => __( 'Upper Latin', 'lc-acf-integration' ),
						'value' => 'upper-latin',
					),
					array(
						'label' => __( 'Upper Roman', 'lc-acf-integration' ),
						'value' => 'upper-roman',
					),
					array(
						'label' => __( 'Inherit', 'lc-acf-integration' ),
						'value' => 'inherit',
					),
				),
				'section' => 'styling',
				'tab' => __( 'Lists', 'lc-acf-integration' ),
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea ul',
				'affect_on_change_rule' => 'list-style-type',
			),
			array(
				'label' => __( 'Ordered Style', 'lc-acf-integration' ),
				'id' => 'css_lists_ol_style',
				'std' => 'decimal',
				'type' => 'select',
				'choices' => array(
					array(
						'label' => __( 'Armenian', 'lc-acf-integration' ),
						'value' => 'armenian',
					),
					array(
						'label' => __( 'Circle', 'lc-acf-integration' ),
						'value' => 'circle',
					),
					array(
						'label' => __( 'Cjk-ideographic', 'lc-acf-integration' ),
						'value' => 'cjk-ideographic',
					),
					array(
						'label' => __( 'Decimal', 'lc-acf-integration' ),
						'value' => 'decimal',
					),
					array(
						'label' => __( 'Decimal Leading Zero', 'lc-acf-integration' ),
						'value' => 'decimal-leading-zero',
					),
					array(
						'label' => __( 'Hebrew', 'lc-acf-integration' ),
						'value' => 'hebrew',
					),
					array(
						'label' => __( 'Hiragana', 'lc-acf-integration' ),
						'value' => 'hiragana',
					),
					array(
						'label' => __( 'Hiragana Iroha', 'lc-acf-integration' ),
						'value' => 'hiragana-iroha',
					),
					array(
						'label' => __( 'Katakana', 'lc-acf-integration' ),
						'value' => 'katakana',
					),
					array(
						'label' => __( 'Katakana Iroha', 'lc-acf-integration' ),
						'value' => 'katakana-iroha',
					),
					array(
						'label' => __( 'Lower Alpha', 'lc-acf-integration' ),
						'value' => 'lower-alpha',
					),
					array(
						'label' => __( 'Lower Greek', 'lc-acf-integration' ),
						'value' => 'lower-greek',
					),
					array(
						'label' => __( 'Lower Latin', 'lc-acf-integration' ),
						'value' => 'lower-latin',
					),
					array(
						'label' => __( 'Lower Roman', 'lc-acf-integration' ),
						'value' => 'lower-roman',
					),
					array(
						'label' => __( 'None', 'lc-acf-integration' ),
						'value' => 'none',
					),
					array(
						'label' => __( 'Upper Alpha', 'lc-acf-integration' ),
						'value' => 'upper-alpha',
					),
					array(
						'label' => __( 'Upper Latin', 'lc-acf-integration' ),
						'value' => 'upper-latin',
					),
					array(
						'label' => __( 'Upper Roman', 'lc-acf-integration' ),
						'value' => 'upper-roman',
					),
					array(
						'label' => __( 'Inherit', 'lc-acf-integration' ),
						'value' => 'inherit',
					),
				),
				'section' => 'styling',
				'tab' => __( 'Lists', 'lc-acf-integration' ),
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea ol',
				'affect_on_change_rule' => 'list-style-type',
			),
			array(
				'label' => __( 'Spacing', 'lc-acf-integration' ),
				'id' => 'css_lists_spacing_margin_bottom',
				'std' => '10',
				'type' => 'slider',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea li',
				'affect_on_change_rule' => 'margin-bottom',
				'section' => 'styling',
				'tab' => __( 'Lists', 'lc-acf-integration' ),
				'ext' => 'px',
			),
			array(
				'label' => __( 'Item - BG Color', 'lc-acf-integration' ),
				'id' => 'css_item_bg_color',
				'std' => '',
				'type' => 'color',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea li',
				'affect_on_change_rule' => 'background-color',
				'section' => 'styling',
				'tab' => __( 'Lists', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'Item - Border', 'lc-acf-integration' ),
				'id' => 'css_item_border_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'styling',
				'tab' => __( 'Lists', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Color', 'lc-acf-integration' ),
					'id' => 'css_item_border_color',
					'std' => '',
					'type' => 'color',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea li',
					'affect_on_change_rule' => 'border-color',
					'section' => 'styling',
					'tab' => __( 'Lists', 'lc-acf-integration' ),
				),
				array(
					'label' => __( 'Width', 'lc-acf-integration' ),
					'id' => 'css_item_border_width',
					'onlypositive' => true,
					'max' => 10,
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea li',
					'affect_on_change_rule' => 'border-width',
					'section' => 'styling',
					'ext' => 'px',
					'tab' => __( 'Lists', 'lc-acf-integration' ),
				),
				array(
					'label' => __( 'Borders', 'lc-acf-integration' ),
					'id' => 'css_item_border_trbl',
					'std' => 'top right bottom left',
					'type' => 'checkbox',
					'choices' => array(
						array(
							'label' => __( 'Top', 'lc-acf-integration' ),
							'value' => 'top',
						),
						array(
							'label' => __( 'Right', 'lc-acf-integration' ),
							'value' => 'right',
						),
						array(
							'label' => __( 'Bottom', 'lc-acf-integration' ),
							'value' => 'bottom',
						),
						array(
							'label' => __( 'Left', 'lc-acf-integration' ),
							'value' => 'left',
						),
					),
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea li',
					'affect_on_change_rule' => 'border-style',
					'section' => 'styling',
					'tab' => __( 'Lists', 'lc-acf-integration' ),
				),
				array(
					'label' => __( 'Radius - Top', 'lc-acf-integration' ),
					'id' => 'css_item_border_radius_top',
					'onlypositive' => true,
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea li',
					'affect_on_change_rule' => 'border-top-left-radius,border-top-right-radius',
					'section' => 'styling',
					'tab' => __( 'Lists', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Radius - Bottom', 'lc-acf-integration' ),
					'id' => 'css_item_border_radius_bottom',
					'onlypositive' => true,
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea li',
					'affect_on_change_rule' => 'border-bottom-left-radius,border-bottom-right-radius',
					'section' => 'styling',
					'tab' => __( 'Lists', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_item_border_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'styling',
			),
			array(
				'label' => __( 'Item - Padding', 'lc-acf-integration' ),
				'id' => 'css_item_padding_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'styling',
				'tab' => __( 'Lists', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_item_padding_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea li',
					'affect_on_change_rule' => 'padding-top',
					'section' => 'styling',
					'tab' => __( 'Lists', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_item_padding_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea li',
					'affect_on_change_rule' => 'padding-right',
					'section' => 'styling',
					'tab' => __( 'Lists', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_item_padding_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea li',
					'affect_on_change_rule' => 'padding-bottom',
					'section' => 'styling',
					'tab' => __( 'Lists', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_item_padding_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea li',
					'affect_on_change_rule' => 'padding-left',
					'section' => 'styling',
					'tab' => __( 'Lists', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_item_padding_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'styling',
			),
			array(
				'label' => __( 'Text Shadow', 'lc-acf-integration' ),
				'id' => 'css_lists_text_shadow',
				'std' => '',
				'type' => 'text_shadow',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea li',
				'affect_on_change_rule' => 'text-shadow',
				'section' => 'styling',
				'tab' => __( 'Lists', 'lc-acf-integration' ),
			),

			/**
			 * Inputs
			 */

			array(
				'label' => __( 'BG Color', 'lc-acf-integration' ),
				'id' => 'css_inputs_bg_color',
				'std' => '#fff',
				'type' => 'color',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea input[type=text], .lc-acf-module-textarea input[type=password], .lc-acf-module-textarea input[type=number], .lc-acf-module-textarea input[type=email], .lc-acf-module-textarea input[type=tel], .lc-acf-module-textarea textarea, .lc-acf-module-textarea select',
				'affect_on_change_rule' => 'background-color',
				'section' => 'styling',
				'tab' => __( 'Inputs', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'Border', 'lc-acf-integration' ),
				'id' => 'css_inputs_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'styling',
				'tab' => __( 'Inputs', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Color', 'lc-acf-integration' ),
					'id' => 'css_inputs_color',
					'std' => '#ddd',
					'type' => 'color',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=text], .lc-acf-module-textarea input[type=password], .lc-acf-module-textarea input[type=number], .lc-acf-module-textarea input[type=email], .lc-acf-module-textarea input[type=tel], .lc-acf-module-textarea textarea, .lc-acf-module-textarea select',
					'affect_on_change_rule' => 'border-color',
					'section' => 'styling',
					'tab' => __( 'Inputs', 'lc-acf-integration' ),
				),
				array(
					'label' => __( 'Width', 'lc-acf-integration' ),
					'id' => 'css_inputs_width',
					'onlypositive' => true,
					'max' => 10,
					'std' => '1',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=text], .lc-acf-module-textarea input[type=password], .lc-acf-module-textarea input[type=number], .lc-acf-module-textarea input[type=email], .lc-acf-module-textarea input[type=tel], .lc-acf-module-textarea textarea, .lc-acf-module-textarea select',
					'affect_on_change_rule' => 'border-width',
					'section' => 'styling',
					'ext' => 'px',
					'tab' => __( 'Inputs', 'lc-acf-integration' ),
				),
				array(
					'label' => __( 'Borders', 'lc-acf-integration' ),
					'id' => 'css_inputs_trbl',
					'std' => 'top right bottom left',
					'type' => 'checkbox',
					'choices' => array(
						array(
							'label' => __( 'Top', 'lc-acf-integration' ),
							'value' => 'top',
						),
						array(
							'label' => __( 'Right', 'lc-acf-integration' ),
							'value' => 'right',
						),
						array(
							'label' => __( 'Bottom', 'lc-acf-integration' ),
							'value' => 'bottom',
						),
						array(
							'label' => __( 'Left', 'lc-acf-integration' ),
							'value' => 'left',
						),
					),
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=text], .lc-acf-module-textarea input[type=password], .lc-acf-module-textarea input[type=number], .lc-acf-module-textarea input[type=email], .lc-acf-module-textarea input[type=tel], .lc-acf-module-textarea textarea, .lc-acf-module-textarea select',
					'affect_on_change_rule' => 'border-style',
					'section' => 'styling',
					'tab' => __( 'Inputs', 'lc-acf-integration' ),
				),
				array(
					'label' => __( 'Radius - Top', 'lc-acf-integration' ),
					'id' => 'css_inputs_radius_top',
					'onlypositive' => true,
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=text], .lc-acf-module-textarea input[type=password], .lc-acf-module-textarea input[type=number], .lc-acf-module-textarea input[type=email], .lc-acf-module-textarea input[type=tel], .lc-acf-module-textarea textarea, .lc-acf-module-textarea select',
					'affect_on_change_rule' => 'border-top-left-radius,border-top-right-radius',
					'section' => 'styling',
					'tab' => __( 'Inputs', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Radius - Bottom', 'lc-acf-integration' ),
					'id' => 'css_inputs_radius_bottom',
					'onlypositive' => true,
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=text], .lc-acf-module-textarea input[type=password], .lc-acf-module-textarea input[type=number], .lc-acf-module-textarea input[type=email], .lc-acf-module-textarea input[type=tel], .lc-acf-module-textarea textarea, .lc-acf-module-textarea select',
					'affect_on_change_rule' => 'border-bottom-left-radius,border-bottom-right-radius',
					'section' => 'styling',
					'tab' => __( 'Inputs', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_inputs_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'styling',
			),
			array(
				'label' => __( 'Font', 'lc-acf-integration' ),
				'id' => 'css_inputs_font_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'styling',
				'tab' => __( 'Inputs', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Color', 'lc-acf-integration' ),
					'id' => 'css_inputs_color',
					'std' => '',
					'type' => 'color',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=text], .lc-acf-module-textarea input[type=password], .lc-acf-module-textarea input[type=number], .lc-acf-module-textarea input[type=email], .lc-acf-module-textarea input[type=tel], .lc-acf-module-textarea textarea, .lc-acf-module-textarea select',
					'affect_on_change_rule' => 'color',
					'section' => 'styling',
					'tab' => __( 'Inputs', 'lc-acf-integration' ),
				),
				array(
					'label' => __( 'Font Size', 'lc-acf-integration' ),
					'id' => 'css_inputs_font_size',
					'std' => '13',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=text], .lc-acf-module-textarea input[type=password], .lc-acf-module-textarea input[type=number], .lc-acf-module-textarea input[type=email], .lc-acf-module-textarea input[type=tel], .lc-acf-module-textarea textarea, .lc-acf-module-textarea select',
					'affect_on_change_rule' => 'font-size',
					'section' => 'styling',
					'tab' => __( 'Inputs', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Line Height', 'lc-acf-integration' ),
					'id' => 'css_inputs_line_height',
					'std' => '22',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=text], .lc-acf-module-textarea input[type=password], .lc-acf-module-textarea input[type=number], .lc-acf-module-textarea input[type=email], .lc-acf-module-textarea input[type=tel], .lc-acf-module-textarea textarea, .lc-acf-module-textarea select',
					'affect_on_change_rule' => 'line-height',
					'section' => 'styling',
					'tab' => __( 'Inputs', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Font Weight', 'lc-acf-integration' ),
					'id' => 'css_inputs_font_weight',
					'std' => '400',
					'type' => 'select',
					'choices' => array(
						array(
							'label' => '100 - Thin',
							'value' => '100',
						),
						array(
							'label' => '200 - Extra Light',
							'value' => '200',
						),
						array(
							'label' => '300 - Light',
							'value' => '300',
						),
						array(
							'label' => '400 - Normal',
							'value' => '400',
						),
						array(
							'label' => '500 - Medium',
							'value' => '500',
						),
						array(
							'label' => '600 - Semi Bold',
							'value' => '600',
						),
						array(
							'label' => '700 - Bold',
							'value' => '700',
						),
						array(
							'label' => '800 - Extra Bold',
							'value' => '800',
						),
						array(
							'label' => '900 - Black',
							'value' => '900',
						),
					),
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=text], .lc-acf-module-textarea input[type=password], .lc-acf-module-textarea input[type=number], .lc-acf-module-textarea input[type=email], .lc-acf-module-textarea input[type=tel], .lc-acf-module-textarea textarea, .lc-acf-module-textarea select',
					'affect_on_change_rule' => 'font-weight',
					'section' => 'styling',
					'tab' => __( 'Inputs', 'lc-acf-integration' ),
					'ext' => '',
				),
				array(
					'label' => __( 'Font Family', 'lc-acf-integration' ),
					'id' => 'css_inputs_font_family',
					'std' => 'Open Sans',
					'type' => 'font',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=text], .lc-acf-module-textarea input[type=password], .lc-acf-module-textarea input[type=number], .lc-acf-module-textarea input[type=email], .lc-acf-module-textarea input[type=tel], .lc-acf-module-textarea textarea, .lc-acf-module-textarea select',
					'affect_on_change_rule' => 'font-family',
					'section' => 'styling',
					'tab' => __( 'Inputs', 'lc-acf-integration' ),
				),
				array(
					'label' => __( 'Font Style', 'lc-acf-integration' ),
					'id' => 'css_inputs_font_style',
					'std' => 'normal',
					'type' => 'select',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=text], .lc-acf-module-textarea input[type=password], .lc-acf-module-textarea input[type=number], .lc-acf-module-textarea input[type=email], .lc-acf-module-textarea input[type=tel], .lc-acf-module-textarea textarea, .lc-acf-module-textarea select',
					'affect_on_change_rule' => 'font-style',
					'section' => 'styling',
					'tab' => __( 'Inputs', 'lc-acf-integration' ),
					'choices' => array(
						array(
							'label' => __( 'Normal', 'lc-acf-integration' ),
							'value' => 'normal',
						),
						array(
							'label' => __( 'Italic', 'lc-acf-integration' ),
							'value' => 'italic',
						),
					),
				),
				array(
					'label' => __( 'Letter Spacing', 'lc-acf-integration' ),
					'id' => 'css_inputs_letter_spacing',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=text], .lc-acf-module-textarea input[type=password], .lc-acf-module-textarea input[type=number], .lc-acf-module-textarea input[type=email], .lc-acf-module-textarea input[type=tel], .lc-acf-module-textarea textarea, .lc-acf-module-textarea select',
					'affect_on_change_rule' => 'letter-spacing',
					'section' => 'styling',
					'tab' => __( 'Inputs', 'lc-acf-integration' ),
					'ext' => 'px',
					'min' => -50,
					'max' => 50,
				),
			array(
				'id' => 'css_inputs_font_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'styling',
			),
			array(
				'label' => __( 'Margin', 'lc-acf-integration' ),
				'id' => 'css_inputs_margin_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'styling',
				'tab' => __( 'Inputs', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_inputs_margin_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=text], .lc-acf-module-textarea input[type=password], .lc-acf-module-textarea input[type=number], .lc-acf-module-textarea input[type=email], .lc-acf-module-textarea input[type=tel], .lc-acf-module-textarea textarea, .lc-acf-module-textarea select',
					'affect_on_change_rule' => 'margin-top',
					'section' => 'styling',
					'tab' => __( 'Inputs', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_inputs_margin_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=text], .lc-acf-module-textarea input[type=password], .lc-acf-module-textarea input[type=number], .lc-acf-module-textarea input[type=email], .lc-acf-module-textarea input[type=tel], .lc-acf-module-textarea textarea, .lc-acf-module-textarea select',
					'affect_on_change_rule' => 'margin-right',
					'section' => 'styling',
					'tab' => __( 'Inputs', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_inputs_margin_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=text], .lc-acf-module-textarea input[type=password], .lc-acf-module-textarea input[type=number], .lc-acf-module-textarea input[type=email], .lc-acf-module-textarea input[type=tel], .lc-acf-module-textarea textarea, .lc-acf-module-textarea select',
					'affect_on_change_rule' => 'margin-bottom',
					'section' => 'styling',
					'tab' => __( 'Inputs', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_inputs_margin_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=text], .lc-acf-module-textarea input[type=password], .lc-acf-module-textarea input[type=number], .lc-acf-module-textarea input[type=email], .lc-acf-module-textarea input[type=tel], .lc-acf-module-textarea textarea, .lc-acf-module-textarea select',
					'affect_on_change_rule' => 'margin-left',
					'section' => 'styling',
					'tab' => __( 'Inputs', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_inputs_margin_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'styling',
			),
			array(
				'label' => __( 'Padding', 'lc-acf-integration' ),
				'id' => 'css_inputs_padding_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'styling',
				'tab' => __( 'Inputs', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_inputs_padding_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=text], .lc-acf-module-textarea input[type=password], .lc-acf-module-textarea input[type=number], .lc-acf-module-textarea input[type=email], .lc-acf-module-textarea input[type=tel], .lc-acf-module-textarea textarea, .lc-acf-module-textarea select',
					'affect_on_change_rule' => 'padding-top',
					'section' => 'styling',
					'tab' => __( 'Inputs', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_inputs_padding_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=text], .lc-acf-module-textarea input[type=password], .lc-acf-module-textarea input[type=number], .lc-acf-module-textarea input[type=email], .lc-acf-module-textarea input[type=tel], .lc-acf-module-textarea textarea, .lc-acf-module-textarea select',
					'affect_on_change_rule' => 'padding-right',
					'section' => 'styling',
					'tab' => __( 'Inputs', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_inputs_padding_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=text], .lc-acf-module-textarea input[type=password], .lc-acf-module-textarea input[type=number], .lc-acf-module-textarea input[type=email], .lc-acf-module-textarea input[type=tel], .lc-acf-module-textarea textarea, .lc-acf-module-textarea select',
					'affect_on_change_rule' => 'padding-bottom',
					'section' => 'styling',
					'tab' => __( 'Inputs', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_inputs_padding_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=text], .lc-acf-module-textarea input[type=password], .lc-acf-module-textarea input[type=number], .lc-acf-module-textarea input[type=email], .lc-acf-module-textarea input[type=tel], .lc-acf-module-textarea textarea, .lc-acf-module-textarea select',
					'affect_on_change_rule' => 'padding-left',
					'section' => 'styling',
					'tab' => __( 'Inputs', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_inputs_padding_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'styling',
			),
			array(
				'label' => __( 'Text Shadow', 'lc-acf-integration' ),
				'id' => 'css_inputs_text_shadow',
				'std' => '',
				'type' => 'text_shadow',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea input[type=text], .lc-acf-module-textarea input[type=password], .lc-acf-module-textarea input[type=number], .lc-acf-module-textarea input[type=email], .lc-acf-module-textarea input[type=tel], .lc-acf-module-textarea textarea, .lc-acf-module-textarea select',
				'affect_on_change_rule' => 'text-shadow',
				'section' => 'styling',
				'tab' => __( 'Inputs', 'lc-acf-integration' ),
			),

			/**
			 * Blockquote
			 */

			array(
				'label' => __( 'Text Align', 'lc-acf-integration' ),
				'id' => 'css_blockquote_text_align',
				'std' => 'left',
				'type' => 'text_align',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea blockquote',
				'affect_on_change_rule' => 'text-align',
				'section' => 'styling',
				'tab' => __( 'Blockquote', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'BG Color', 'lc-acf-integration' ),
				'id' => 'css_blockquote_bg_color',
				'std' => '',
				'type' => 'color',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea blockquote',
				'affect_on_change_rule' => 'background-color',
				'section' => 'styling',
				'tab' => __( 'Blockquote', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'Border', 'lc-acf-integration' ),
				'id' => 'css_blockquote_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'styling',
				'tab' => __( 'Blockquote', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Color', 'lc-acf-integration' ),
					'id' => 'css_blockquote_color',
					'std' => '',
					'type' => 'color',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea blockquote',
					'affect_on_change_rule' => 'border-color',
					'section' => 'styling',
					'tab' => __( 'Blockquote', 'lc-acf-integration' ),
				),
				array(
					'label' => __( 'Width', 'lc-acf-integration' ),
					'id' => 'css_blockquote_width',
					'onlypositive' => true,
					'max' => 10,
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea blockquote',
					'affect_on_change_rule' => 'border-width',
					'section' => 'styling',
					'ext' => 'px',
					'tab' => __( 'Blockquote', 'lc-acf-integration' ),
				),
				array(
					'label' => __( 'Borders', 'lc-acf-integration' ),
					'id' => 'css_blockquote_trbl',
					'std' => 'top right bottom left',
					'type' => 'checkbox',
					'choices' => array(
						array(
							'label' => __( 'Top', 'lc-acf-integration' ),
							'value' => 'top',
						),
						array(
							'label' => __( 'Right', 'lc-acf-integration' ),
							'value' => 'right',
						),
						array(
							'label' => __( 'Bottom', 'lc-acf-integration' ),
							'value' => 'bottom',
						),
						array(
							'label' => __( 'Left', 'lc-acf-integration' ),
							'value' => 'left',
						),
					),
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea blockquote',
					'affect_on_change_rule' => 'border-style',
					'section' => 'styling',
					'tab' => __( 'Blockquote', 'lc-acf-integration' ),
				),
				array(
					'label' => __( 'Radius - Top', 'lc-acf-integration' ),
					'id' => 'css_blockquote_radius_top',
					'onlypositive' => true,
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea blockquote',
					'affect_on_change_rule' => 'border-top-left-radius,border-top-right-radius',
					'section' => 'styling',
					'tab' => __( 'Blockquote', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Radius - Bottom', 'lc-acf-integration' ),
					'id' => 'css_blockquote_radius_bottom',
					'onlypositive' => true,
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea blockquote',
					'affect_on_change_rule' => 'border-bottom-left-radius,border-bottom-right-radius',
					'section' => 'styling',
					'tab' => __( 'Blockquote', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_blockquote_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'styling',
			),
			array(
				'label' => __( 'Font', 'lc-acf-integration' ),
				'id' => 'css_blockquote_font_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'styling',
				'tab' => __( 'Blockquote', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Color', 'lc-acf-integration' ),
					'id' => 'css_blockquote_color',
					'std' => '',
					'type' => 'color',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea blockquote',
					'affect_on_change_rule' => 'color',
					'section' => 'styling',
					'tab' => __( 'Blockquote', 'lc-acf-integration' ),
				),
				array(
					'label' => __( 'Font Size', 'lc-acf-integration' ),
					'id' => 'css_blockquote_font_size',
					'std' => '13',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea blockquote',
					'affect_on_change_rule' => 'font-size',
					'section' => 'styling',
					'tab' => __( 'Blockquote', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Line Height', 'lc-acf-integration' ),
					'id' => 'css_blockquote_line_height',
					'std' => '22',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea blockquote',
					'affect_on_change_rule' => 'line-height',
					'section' => 'styling',
					'tab' => __( 'Blockquote', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Font Weight', 'lc-acf-integration' ),
					'id' => 'css_blockquote_font_weight',
					'std' => '400',
					'type' => 'select',
					'choices' => array(
						array(
							'label' => '100 - Thin',
							'value' => '100',
						),
						array(
							'label' => '200 - Extra Light',
							'value' => '200',
						),
						array(
							'label' => '300 - Light',
							'value' => '300',
						),
						array(
							'label' => '400 - Normal',
							'value' => '400',
						),
						array(
							'label' => '500 - Medium',
							'value' => '500',
						),
						array(
							'label' => '600 - Semi Bold',
							'value' => '600',
						),
						array(
							'label' => '700 - Bold',
							'value' => '700',
						),
						array(
							'label' => '800 - Extra Bold',
							'value' => '800',
						),
						array(
							'label' => '900 - Black',
							'value' => '900',
						),
					),
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea blockquote',
					'affect_on_change_rule' => 'font-weight',
					'section' => 'styling',
					'tab' => __( 'Blockquote', 'lc-acf-integration' ),
					'ext' => '',
				),
				array(
					'label' => __( 'Font Family', 'lc-acf-integration' ),
					'id' => 'css_blockquote_font_family',
					'std' => 'Open Sans',
					'type' => 'font',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea blockquote',
					'affect_on_change_rule' => 'font-family',
					'section' => 'styling',
					'tab' => __( 'Blockquote', 'lc-acf-integration' ),
				),
				array(
					'label' => __( 'Font Style', 'lc-acf-integration' ),
					'id' => 'css_blockquote_font_style',
					'std' => 'normal',
					'type' => 'select',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea blockquote',
					'affect_on_change_rule' => 'font-style',
					'section' => 'styling',
					'tab' => __( 'Blockquote', 'lc-acf-integration' ),
					'choices' => array(
						array(
							'label' => __( 'Normal', 'lc-acf-integration' ),
							'value' => 'normal',
						),
						array(
							'label' => __( 'Italic', 'lc-acf-integration' ),
							'value' => 'italic',
						),
					),
				),
				array(
					'label' => __( 'Letter Spacing', 'lc-acf-integration' ),
					'id' => 'css_blockquote_letter_spacing',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea blockquote',
					'affect_on_change_rule' => 'letter-spacing',
					'section' => 'styling',
					'tab' => __( 'Blockquote', 'lc-acf-integration' ),
					'ext' => 'px',
					'min' => -50,
					'max' => 50,
				),
			array(
				'id' => 'css_blockquote_font_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'styling',
			),
			array(
				'label' => __( 'Margin', 'lc-acf-integration' ),
				'id' => 'css_blockquote_margin_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'styling',
				'tab' => __( 'Blockquote', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_blockquote_margin_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea blockquote',
					'affect_on_change_rule' => 'margin-top',
					'section' => 'styling',
					'tab' => __( 'Blockquote', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_blockquote_margin_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea blockquote',
					'affect_on_change_rule' => 'margin-right',
					'section' => 'styling',
					'tab' => __( 'Blockquote', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_blockquote_margin_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea blockquote',
					'affect_on_change_rule' => 'margin-bottom',
					'section' => 'styling',
					'tab' => __( 'Blockquote', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_blockquote_margin_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea blockquote',
					'affect_on_change_rule' => 'margin-left',
					'section' => 'styling',
					'tab' => __( 'Blockquote', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_blockquote_margin_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'styling',
			),
			array(
				'label' => __( 'Padding', 'lc-acf-integration' ),
				'id' => 'css_blockquote_padding_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'styling',
				'tab' => __( 'Blockquote', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_blockquote_padding_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea blockquote',
					'affect_on_change_rule' => 'padding-top',
					'section' => 'styling',
					'tab' => __( 'Blockquote', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_blockquote_padding_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea blockquote',
					'affect_on_change_rule' => 'padding-right',
					'section' => 'styling',
					'tab' => __( 'Blockquote', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_blockquote_padding_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea blockquote',
					'affect_on_change_rule' => 'padding-bottom',
					'section' => 'styling',
					'tab' => __( 'Blockquote', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_blockquote_padding_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea blockquote',
					'affect_on_change_rule' => 'padding-left',
					'section' => 'styling',
					'tab' => __( 'Blockquote', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_blockquote_padding_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'styling',
			),
			array(
				'label' => __( 'Text Shadow', 'lc-acf-integration' ),
				'id' => 'css_blockquote_text_shadow',
				'std' => '',
				'type' => 'text_shadow',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea blockquote',
				'affect_on_change_rule' => 'text-shadow',
				'section' => 'styling',
				'tab' => __( 'Blockquote', 'lc-acf-integration' ),
			),

			/**
			 * Submit Button
			 */

			array(
				'label' => __( 'BG Color', 'lc-acf-integration' ),
				'id' => 'css_button_bg_color',
				'std' => '#5890e5',
				'type' => 'color',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea input[type=submit], .lc-acf-module-textarea button',
				'affect_on_change_rule' => 'background-color',
				'section' => 'styling',
				'tab' => __( 'Buttons', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'BG Color - Hover', 'lc-acf-integration' ),
				'id' => 'css_button_bg_color_hover',
				'std' => '#5890e5',
				'type' => 'color',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea input[type=submit]:hover, .lc-acf-module-textarea button:hover',
				'affect_on_change_rule' => 'background-color',
				'section' => 'styling',
				'tab' => __( 'Buttons', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'Border', 'lc-acf-integration' ),
				'id' => 'css_button_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'styling',
				'tab' => __( 'Buttons', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Color', 'lc-acf-integration' ),
					'id' => 'css_button_color',
					'std' => '#5890e5',
					'type' => 'color',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=submit], .lc-acf-module-textarea button',
					'affect_on_change_rule' => 'border-color',
					'section' => 'styling',
					'tab' => __( 'Buttons', 'lc-acf-integration' ),
				),
				array(
					'label' => __( 'Color - Hover', 'lc-acf-integration' ),
					'id' => 'css_button_color_hover',
					'std' => '#5890e5',
					'type' => 'color',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=submit]:hover, .lc-acf-module-textarea button:hover',
					'affect_on_change_rule' => 'border-color',
					'section' => 'styling',
					'tab' => __( 'Buttons', 'lc-acf-integration' ),
				),
				array(
					'label' => __( 'Width', 'lc-acf-integration' ),
					'id' => 'css_button_width',
					'onlypositive' => true,
					'max' => 10,
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=submit], .lc-acf-module-textarea button',
					'affect_on_change_rule' => 'border-width',
					'section' => 'styling',
					'ext' => 'px',
					'tab' => __( 'Buttons', 'lc-acf-integration' ),
				),
				array(
					'label' => __( 'Borders', 'lc-acf-integration' ),
					'id' => 'css_button_trbl',
					'std' => 'top right bottom left',
					'type' => 'checkbox',
					'choices' => array(
						array(
							'label' => __( 'Top', 'lc-acf-integration' ),
							'value' => 'top',
						),
						array(
							'label' => __( 'Right', 'lc-acf-integration' ),
							'value' => 'right',
						),
						array(
							'label' => __( 'Bottom', 'lc-acf-integration' ),
							'value' => 'bottom',
						),
						array(
							'label' => __( 'Left', 'lc-acf-integration' ),
							'value' => 'left',
						),
					),
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=submit], .lc-acf-module-textarea button',
					'affect_on_change_rule' => 'border-style',
					'section' => 'styling',
					'tab' => __( 'Buttons', 'lc-acf-integration' ),
				),
				array(
					'label' => __( 'Radius - Top', 'lc-acf-integration' ),
					'id' => 'css_button_radius_top',
					'onlypositive' => true,
					'std' => '3',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=submit], .lc-acf-module-textarea button',
					'affect_on_change_rule' => 'border-top-left-radius,border-top-right-radius',
					'section' => 'styling',
					'tab' => __( 'Buttons', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Radius - Bottom', 'lc-acf-integration' ),
					'id' => 'css_button_radius_bottom',
					'onlypositive' => true,
					'std' => '3',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=submit], .lc-acf-module-textarea button',
					'affect_on_change_rule' => 'border-bottom-left-radius,border-bottom-right-radius',
					'section' => 'styling',
					'tab' => __( 'Buttons', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_button_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'styling',
			),
			array(
				'label' => __( 'Font', 'lc-acf-integration' ),
				'id' => 'css_button_font_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'styling',
				'tab' => __( 'Buttons', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Color', 'lc-acf-integration' ),
					'id' => 'css_button_color',
					'std' => '#fff',
					'type' => 'color',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=submit], .lc-acf-module-textarea button',
					'affect_on_change_rule' => 'color',
					'section' => 'styling',
					'tab' => __( 'Buttons', 'lc-acf-integration' ),
				),
				array(
					'label' => __( 'Font Size', 'lc-acf-integration' ),
					'id' => 'css_button_font_size',
					'std' => '13',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=submit], .lc-acf-module-textarea button',
					'affect_on_change_rule' => 'font-size',
					'section' => 'styling',
					'tab' => __( 'Buttons', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Line Height', 'lc-acf-integration' ),
					'id' => 'css_button_line_height',
					'std' => '22',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=submit], .lc-acf-module-textarea button',
					'affect_on_change_rule' => 'line-height',
					'section' => 'styling',
					'tab' => __( 'Buttons', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Font Weight', 'lc-acf-integration' ),
					'id' => 'css_button_font_weight',
					'std' => '400',
					'type' => 'select',
					'choices' => array(
						array(
							'label' => '100 - Thin',
							'value' => '100',
						),
						array(
							'label' => '200 - Extra Light',
							'value' => '200',
						),
						array(
							'label' => '300 - Light',
							'value' => '300',
						),
						array(
							'label' => '400 - Normal',
							'value' => '400',
						),
						array(
							'label' => '500 - Medium',
							'value' => '500',
						),
						array(
							'label' => '600 - Semi Bold',
							'value' => '600',
						),
						array(
							'label' => '700 - Bold',
							'value' => '700',
						),
						array(
							'label' => '800 - Extra Bold',
							'value' => '800',
						),
						array(
							'label' => '900 - Black',
							'value' => '900',
						),
					),
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=submit], .lc-acf-module-textarea button',
					'affect_on_change_rule' => 'font-weight',
					'section' => 'styling',
					'tab' => __( 'Buttons', 'lc-acf-integration' ),
					'ext' => '',
				),
				array(
					'label' => __( 'Font Family', 'lc-acf-integration' ),
					'id' => 'css_button_font_family',
					'std' => 'Open Sans',
					'type' => 'font',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=submit], .lc-acf-module-textarea button',
					'affect_on_change_rule' => 'font-family',
					'section' => 'styling',
					'tab' => __( 'Buttons', 'lc-acf-integration' ),
				),
				array(
					'label' => __( 'Font Style', 'lc-acf-integration' ),
					'id' => 'css_button_font_style',
					'std' => 'normal',
					'type' => 'select',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=submit], .lc-acf-module-textarea button',
					'affect_on_change_rule' => 'font-style',
					'section' => 'styling',
					'tab' => __( 'Buttons', 'lc-acf-integration' ),
					'choices' => array(
						array(
							'label' => __( 'Normal', 'lc-acf-integration' ),
							'value' => 'normal',
						),
						array(
							'label' => __( 'Italic', 'lc-acf-integration' ),
							'value' => 'italic',
						),
					),
				),
				array(
					'label' => __( 'Letter Spacing', 'lc-acf-integration' ),
					'id' => 'css_button_letter_spacing',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=submit], .lc-acf-module-textarea button',
					'affect_on_change_rule' => 'letter-spacing',
					'section' => 'styling',
					'tab' => __( 'Buttons', 'lc-acf-integration' ),
					'ext' => 'px',
					'min' => -50,
					'max' => 50,
				),
			array(
				'id' => 'css_button_font_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'styling',
			),
			array(
				'label' => __( 'Margin', 'lc-acf-integration' ),
				'id' => 'css_button_margin_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'styling',
				'tab' => __( 'Buttons', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_button_margin_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=submit], .lc-acf-module-textarea button',
					'affect_on_change_rule' => 'margin-top',
					'section' => 'styling',
					'tab' => __( 'Buttons', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_button_margin_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=submit], .lc-acf-module-textarea button',
					'affect_on_change_rule' => 'margin-right',
					'section' => 'styling',
					'tab' => __( 'Buttons', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_button_margin_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=submit], .lc-acf-module-textarea button',
					'affect_on_change_rule' => 'margin-bottom',
					'section' => 'styling',
					'tab' => __( 'Buttons', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_button_margin_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=submit], .lc-acf-module-textarea button',
					'affect_on_change_rule' => 'margin-left',
					'section' => 'styling',
					'tab' => __( 'Buttons', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_button_margin_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'styling',
			),
			array(
				'label' => __( 'Padding', 'lc-acf-integration' ),
				'id' => 'css_button_padding_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'styling',
				'tab' => __( 'Buttons', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_button_padding_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=submit], .lc-acf-module-textarea button',
					'affect_on_change_rule' => 'padding-top',
					'section' => 'styling',
					'tab' => __( 'Buttons', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_button_padding_right',
					'std' => '15',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=submit], .lc-acf-module-textarea button',
					'affect_on_change_rule' => 'padding-right',
					'section' => 'styling',
					'tab' => __( 'Buttons', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_button_padding_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=submit], .lc-acf-module-textarea button',
					'affect_on_change_rule' => 'padding-bottom',
					'section' => 'styling',
					'tab' => __( 'Buttons', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_button_padding_left',
					'std' => '15',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=submit], .lc-acf-module-textarea button',
					'affect_on_change_rule' => 'padding-left',
					'section' => 'styling',
					'tab' => __( 'Buttons', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_button_padding_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'styling',
			),
			array(
				'label' => __( 'Text Shadow', 'lc-acf-integration' ),
				'id' => 'css_button_text_shadow',
				'std' => '',
				'type' => 'text_shadow',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea input[type=submit], .lc-acf-module-textarea button',
				'affect_on_change_rule' => 'text-shadow',
				'section' => 'styling',
				'tab' => __( 'Buttons', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'Box Shadow', 'lc-acf-integration' ),
				'id' => 'css_button_box_shadow',
				'std' => '',
				'type' => 'box_shadow',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea input[type=submit], .lc-acf-module-textarea button',
				'affect_on_change_rule' => 'box-shadow',
				'section' => 'styling',
				'tab' => __( 'Buttons', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'Box Shadow - Hover', 'lc-acf-integration' ),
				'id' => 'css_button_box_shadow_hover',
				'std' => '',
				'type' => 'box_shadow',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea input[type=submit]:hover, .lc-acf-module-textarea button:hover',
				'affect_on_change_rule' => 'box-shadow',
				'section' => 'styling',
				'tab' => __( 'Buttons', 'lc-acf-integration' ),
			),

			/**
			 * Responsive Tablet
			 */

			array(
				'label' => __( 'Responsive Styling', 'lc-acf-integration' ),
				'id' => 'css_res_t',
				'std' => 'disabled',
				'type' => 'select',
				'choices' => array(
					array(
						'label' => __( 'Disabled', 'lc-acf-integration' ),
						'value' => 'disabled',
					),
					array(
						'label' => __( 'Enabled', 'lc-acf-integration' ),
						'value' => 'enabled',
					),
				),
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'Margin', 'lc-acf-integration' ),
				'id' => 'css_res_t_margin_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_res_t_margin_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea',
					'affect_on_change_rule' => 'margin-top',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_res_t_margin_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea',
					'affect_on_change_rule' => 'margin-right',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_res_t_margin_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea',
					'affect_on_change_rule' => 'margin-bottom',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_res_t_margin_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea',
					'affect_on_change_rule' => 'margin-left',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_res_t_margin_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'Padding', 'lc-acf-integration' ),
				'id' => 'css_res_t_padding_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_res_t_padding_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea',
					'affect_on_change_rule' => 'padding-top',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_res_t_padding_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea',
					'affect_on_change_rule' => 'padding-right',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_res_t_padding_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea',
					'affect_on_change_rule' => 'padding-bottom',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_res_t_padding_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea',
					'affect_on_change_rule' => 'padding-left',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_res_t_padding_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'Font Size', 'lc-acf-integration' ),
				'id' => 'css_res_t_content_font_size',
				'std' => '13',
				'type' => 'slider',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea, .lc-acf-module-textarea p',
				'affect_on_change_rule' => 'font-size',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
				'ext' => 'px',
			),
			array(
				'label' => __( 'Line Height', 'lc-acf-integration' ),
				'id' => 'css_res_t_content_line_height',
				'std' => '22',
				'type' => 'slider',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea, .lc-acf-module-textarea p',
				'affect_on_change_rule' => 'line-height',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
				'ext' => 'px',
			),
			array(
				'label' => __( 'Margin ( paragraph )', 'lc-acf-integration' ),
				'id' => 'css_res_t_content_margin_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_res_t_content_margin_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea p',
					'affect_on_change_rule' => 'margin-top',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_res_t_content_margin_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea p',
					'affect_on_change_rule' => 'margin-right',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_res_t_content_margin_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea p',
					'affect_on_change_rule' => 'margin-bottom',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_res_t_content_margin_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea p',
					'affect_on_change_rule' => 'margin-left',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_res_t_content_margin_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'Padding ( paragraph )', 'lc-acf-integration' ),
				'id' => 'css_res_t_content_padding_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_res_t_content_padding_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea p',
					'affect_on_change_rule' => 'padding-top',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_res_t_content_padding_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea p',
					'affect_on_change_rule' => 'padding-right',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_res_t_content_padding_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea p',
					'affect_on_change_rule' => 'padding-bottom',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_res_t_content_padding_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea p',
					'affect_on_change_rule' => 'padding-left',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_res_t_content_padding_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'H1 - Text Align', 'lc-acf-integration' ),
				'id' => 'css_res_t_h1_text_align',
				'std' => 'left',
				'type' => 'text_align',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea h1',
				'affect_on_change_rule' => 'text-align',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'H1 - Font Size', 'lc-acf-integration' ),
				'id' => 'css_res_t_h1_font_size',
				'std' => '13',
				'type' => 'slider',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea h1',
				'affect_on_change_rule' => 'font-size',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
				'ext' => 'px',
			),
			array(
				'label' => __( 'H1 - Line Height', 'lc-acf-integration' ),
				'id' => 'css_res_t_h1_line_height',
				'std' => '22',
				'type' => 'slider',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea h1',
				'affect_on_change_rule' => 'line-height',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
				'ext' => 'px',
			),
			array(
				'label' => __( 'H1 - Margin', 'lc-acf-integration' ),
				'id' => 'css_res_t_h1_margin_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_res_t_h1_margin_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h1',
					'affect_on_change_rule' => 'margin-top',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_res_t_h1_margin_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h1',
					'affect_on_change_rule' => 'margin-right',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_res_t_h1_margin_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h1',
					'affect_on_change_rule' => 'margin-bottom',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_res_t_h1_margin_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h1',
					'affect_on_change_rule' => 'margin-left',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_res_t_h1_margin_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'H1 - Padding', 'lc-acf-integration' ),
				'id' => 'css_res_t_h1_padding_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_res_t_h1_padding_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h1',
					'affect_on_change_rule' => 'padding-top',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_res_t_h1_padding_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h1',
					'affect_on_change_rule' => 'padding-right',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_res_t_h1_padding_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h1',
					'affect_on_change_rule' => 'padding-bottom',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_res_t_h1_padding_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h1',
					'affect_on_change_rule' => 'padding-left',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_res_t_h1_padding_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'H2 - Text Align', 'lc-acf-integration' ),
				'id' => 'css_res_t_h2_text_align',
				'std' => 'left',
				'type' => 'text_align',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea h2',
				'affect_on_change_rule' => 'text-align',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'H2 - Font Size', 'lc-acf-integration' ),
				'id' => 'css_res_t_h2_font_size',
				'std' => '13',
				'type' => 'slider',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea h2',
				'affect_on_change_rule' => 'font-size',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
				'ext' => 'px',
			),
			array(
				'label' => __( 'H2 - Line Height', 'lc-acf-integration' ),
				'id' => 'css_res_t_h2_line_height',
				'std' => '22',
				'type' => 'slider',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea h2',
				'affect_on_change_rule' => 'line-height',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
				'ext' => 'px',
			),
			array(
				'label' => __( 'H2 - Margin', 'lc-acf-integration' ),
				'id' => 'css_res_t_h2_margin_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_res_t_h2_margin_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h2',
					'affect_on_change_rule' => 'margin-top',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_res_t_h2_margin_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h2',
					'affect_on_change_rule' => 'margin-right',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_res_t_h2_margin_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h2',
					'affect_on_change_rule' => 'margin-bottom',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_res_t_h2_margin_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h2',
					'affect_on_change_rule' => 'margin-left',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_res_t_h2_margin_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'H2 - Padding', 'lc-acf-integration' ),
				'id' => 'css_res_t_h2_padding_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_res_t_h2_padding_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h2',
					'affect_on_change_rule' => 'padding-top',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_res_t_h2_padding_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h2',
					'affect_on_change_rule' => 'padding-right',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_res_t_h2_padding_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h2',
					'affect_on_change_rule' => 'padding-bottom',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_res_t_h2_padding_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h2',
					'affect_on_change_rule' => 'padding-left',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_res_t_h2_padding_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'H3 - Text Align', 'lc-acf-integration' ),
				'id' => 'css_res_t_h3_text_align',
				'std' => 'left',
				'type' => 'text_align',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea h3',
				'affect_on_change_rule' => 'text-align',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'H3 - Font Size', 'lc-acf-integration' ),
				'id' => 'css_res_t_h3_font_size',
				'std' => '13',
				'type' => 'slider',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea h3',
				'affect_on_change_rule' => 'font-size',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
				'ext' => 'px',
			),
			array(
				'label' => __( 'H3 - Line Height', 'lc-acf-integration' ),
				'id' => 'css_res_t_h3_line_height',
				'std' => '22',
				'type' => 'slider',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea h3',
				'affect_on_change_rule' => 'line-height',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
				'ext' => 'px',
			),
			array(
				'label' => __( 'H3 - Margin', 'lc-acf-integration' ),
				'id' => 'css_res_t_h3_margin_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_res_t_h3_margin_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h3',
					'affect_on_change_rule' => 'margin-top',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_res_t_h3_margin_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h3',
					'affect_on_change_rule' => 'margin-right',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_res_t_h3_margin_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h3',
					'affect_on_change_rule' => 'margin-bottom',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_res_t_h3_margin_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h3',
					'affect_on_change_rule' => 'margin-left',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_res_t_h3_margin_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'H3 - Padding', 'lc-acf-integration' ),
				'id' => 'css_res_t_h3_padding_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_res_t_h3_padding_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h3',
					'affect_on_change_rule' => 'padding-top',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_res_t_h3_padding_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h3',
					'affect_on_change_rule' => 'padding-right',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_res_t_h3_padding_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h3',
					'affect_on_change_rule' => 'padding-bottom',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_res_t_h3_padding_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h3',
					'affect_on_change_rule' => 'padding-left',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_res_t_h3_padding_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'H4 - Text Align', 'lc-acf-integration' ),
				'id' => 'css_res_t_h4_text_align',
				'std' => 'left',
				'type' => 'text_align',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea h4',
				'affect_on_change_rule' => 'text-align',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'H4 - Font Size', 'lc-acf-integration' ),
				'id' => 'css_res_t_h4_font_size',
				'std' => '13',
				'type' => 'slider',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea h4',
				'affect_on_change_rule' => 'font-size',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
				'ext' => 'px',
			),
			array(
				'label' => __( 'H4 - Line Height', 'lc-acf-integration' ),
				'id' => 'css_res_t_h4_line_height',
				'std' => '22',
				'type' => 'slider',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea h4',
				'affect_on_change_rule' => 'line-height',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
				'ext' => 'px',
			),
			array(
				'label' => __( 'H4 - Margin', 'lc-acf-integration' ),
				'id' => 'css_res_t_h4_margin_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_res_t_h4_margin_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h4',
					'affect_on_change_rule' => 'margin-top',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_res_t_h4_margin_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h4',
					'affect_on_change_rule' => 'margin-right',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_res_t_h4_margin_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h4',
					'affect_on_change_rule' => 'margin-bottom',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_res_t_h4_margin_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h4',
					'affect_on_change_rule' => 'margin-left',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_res_t_h4_margin_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'H4 - Padding', 'lc-acf-integration' ),
				'id' => 'css_res_t_h4_padding_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_res_t_h4_padding_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h4',
					'affect_on_change_rule' => 'padding-top',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_res_t_h4_padding_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h4',
					'affect_on_change_rule' => 'padding-right',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_res_t_h4_padding_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h4',
					'affect_on_change_rule' => 'padding-bottom',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_res_t_h4_padding_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h4',
					'affect_on_change_rule' => 'padding-left',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_res_t_h4_padding_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'H5 - Text Align', 'lc-acf-integration' ),
				'id' => 'css_res_t_h5_text_align',
				'std' => 'left',
				'type' => 'text_align',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea h5',
				'affect_on_change_rule' => 'text-align',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'H5 - Font Size', 'lc-acf-integration' ),
				'id' => 'css_res_t_h5_font_size',
				'std' => '13',
				'type' => 'slider',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea h5',
				'affect_on_change_rule' => 'font-size',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
				'ext' => 'px',
			),
			array(
				'label' => __( 'H5 - Line Height', 'lc-acf-integration' ),
				'id' => 'css_res_t_h5_line_height',
				'std' => '22',
				'type' => 'slider',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea h5',
				'affect_on_change_rule' => 'line-height',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
				'ext' => 'px',
			),
			array(
				'label' => __( 'H5 - Margin', 'lc-acf-integration' ),
				'id' => 'css_res_t_h5_margin_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_res_t_h5_margin_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h5',
					'affect_on_change_rule' => 'margin-top',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_res_t_h5_margin_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h5',
					'affect_on_change_rule' => 'margin-right',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_res_t_h5_margin_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h5',
					'affect_on_change_rule' => 'margin-bottom',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_res_t_h5_margin_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h5',
					'affect_on_change_rule' => 'margin-left',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_res_t_h5_margin_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'H5 - Padding', 'lc-acf-integration' ),
				'id' => 'css_res_t_h5_padding_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_res_t_h5_padding_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h5',
					'affect_on_change_rule' => 'padding-top',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_res_t_h5_padding_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h5',
					'affect_on_change_rule' => 'padding-right',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_res_t_h5_padding_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h5',
					'affect_on_change_rule' => 'padding-bottom',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_res_t_h5_padding_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h5',
					'affect_on_change_rule' => 'padding-left',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_res_t_h5_padding_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'H6 - Text Align', 'lc-acf-integration' ),
				'id' => 'css_res_t_h6_text_align',
				'std' => 'left',
				'type' => 'text_align',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea h6',
				'affect_on_change_rule' => 'text-align',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'H6 - Font Size', 'lc-acf-integration' ),
				'id' => 'css_res_t_h6_font_size',
				'std' => '13',
				'type' => 'slider',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea h6',
				'affect_on_change_rule' => 'font-size',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
				'ext' => 'px',
			),
			array(
				'label' => __( 'H6 - Line Height', 'lc-acf-integration' ),
				'id' => 'css_res_t_h6_line_height',
				'std' => '22',
				'type' => 'slider',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea h6',
				'affect_on_change_rule' => 'line-height',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
				'ext' => 'px',
			),
			array(
				'label' => __( 'H6 - Margin', 'lc-acf-integration' ),
				'id' => 'css_res_t_h6_margin_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_res_t_h6_margin_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h6',
					'affect_on_change_rule' => 'margin-top',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_res_t_h6_margin_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h6',
					'affect_on_change_rule' => 'margin-right',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_res_t_h6_margin_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h6',
					'affect_on_change_rule' => 'margin-bottom',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_res_t_h6_margin_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h6',
					'affect_on_change_rule' => 'margin-left',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_res_t_h6_margin_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'H6 - Padding', 'lc-acf-integration' ),
				'id' => 'css_res_t_h6_padding_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_res_t_h6_padding_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h6',
					'affect_on_change_rule' => 'padding-top',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_res_t_h6_padding_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h6',
					'affect_on_change_rule' => 'padding-right',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_res_t_h6_padding_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h6',
					'affect_on_change_rule' => 'padding-bottom',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_res_t_h6_padding_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h6',
					'affect_on_change_rule' => 'padding-left',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_res_t_h6_padding_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'Lists - Font Size', 'lc-acf-integration' ),
				'id' => 'css_res_t_lists_font_size',
				'std' => '13',
				'type' => 'slider',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea li',
				'affect_on_change_rule' => 'font-size',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
				'ext' => 'px',
			),
			array(
				'label' => __( 'Lists - Line Height', 'lc-acf-integration' ),
				'id' => 'css_res_t_lists_line_height',
				'std' => '22',
				'type' => 'slider',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea li',
				'affect_on_change_rule' => 'line-height',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
				'ext' => 'px',
			),
			array(
				'label' => __( 'Lists - Margin', 'lc-acf-integration' ),
				'id' => 'css_res_t_lists_margin_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_res_t_lists_margin_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea ul,.lc-acf-module-textarea ol',
					'affect_on_change_rule' => 'margin-top',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_res_t_lists_margin_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea ul,.lc-acf-module-textarea ol',
					'affect_on_change_rule' => 'margin-right',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_res_t_lists_margin_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea ul,.lc-acf-module-textarea ol',
					'affect_on_change_rule' => 'margin-bottom',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_res_t_lists_margin_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea ul,.lc-acf-module-textarea ol',
					'affect_on_change_rule' => 'margin-left',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_res_t_lists_margin_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'Lists - Spacing', 'lc-acf-integration' ),
				'id' => 'css_res_t_lists_spacing_margin_bottom',
				'std' => '10',
				'type' => 'slider',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea li',
				'affect_on_change_rule' => 'margin-bottom',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
				'ext' => 'px',
			),
			array(
				'label' => __( 'Lists Item - Padding', 'lc-acf-integration' ),
				'id' => 'css_res_t_item_padding_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_res_t_item_padding_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea li',
					'affect_on_change_rule' => 'padding-top',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_res_t_item_padding_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea li',
					'affect_on_change_rule' => 'padding-right',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_res_t_item_padding_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea li',
					'affect_on_change_rule' => 'padding-bottom',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_res_t_item_padding_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea li',
					'affect_on_change_rule' => 'padding-left',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_res_t_item_padding_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'Inputs - Font Size', 'lc-acf-integration' ),
				'id' => 'css_res_t_inputs_font_size',
				'std' => '13',
				'type' => 'slider',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea input[type=text], .lc-acf-module-textarea input[type=password], .lc-acf-module-textarea input[type=number], .lc-acf-module-textarea input[type=email], .lc-acf-module-textarea input[type=tel], .lc-acf-module-textarea textarea, .lc-acf-module-textarea select',
				'affect_on_change_rule' => 'font-size',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
				'ext' => 'px',
			),
			array(
				'label' => __( 'Inputs - Line Height', 'lc-acf-integration' ),
				'id' => 'css_res_t_inputs_line_height',
				'std' => '22',
				'type' => 'slider',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea input[type=text], .lc-acf-module-textarea input[type=password], .lc-acf-module-textarea input[type=number], .lc-acf-module-textarea input[type=email], .lc-acf-module-textarea input[type=tel], .lc-acf-module-textarea textarea, .lc-acf-module-textarea select',
				'affect_on_change_rule' => 'line-height',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
				'ext' => 'px',
			),
			array(
				'label' => __( 'Inputs - Margin', 'lc-acf-integration' ),
				'id' => 'css_res_t_inputs_margin_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_res_t_inputs_margin_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=text], .lc-acf-module-textarea input[type=password], .lc-acf-module-textarea input[type=number], .lc-acf-module-textarea input[type=email], .lc-acf-module-textarea input[type=tel], .lc-acf-module-textarea textarea, .lc-acf-module-textarea select',
					'affect_on_change_rule' => 'margin-top',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_res_t_inputs_margin_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=text], .lc-acf-module-textarea input[type=password], .lc-acf-module-textarea input[type=number], .lc-acf-module-textarea input[type=email], .lc-acf-module-textarea input[type=tel], .lc-acf-module-textarea textarea, .lc-acf-module-textarea select',
					'affect_on_change_rule' => 'margin-right',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_res_t_inputs_margin_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=text], .lc-acf-module-textarea input[type=password], .lc-acf-module-textarea input[type=number], .lc-acf-module-textarea input[type=email], .lc-acf-module-textarea input[type=tel], .lc-acf-module-textarea textarea, .lc-acf-module-textarea select',
					'affect_on_change_rule' => 'margin-bottom',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_res_t_inputs_margin_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=text], .lc-acf-module-textarea input[type=password], .lc-acf-module-textarea input[type=number], .lc-acf-module-textarea input[type=email], .lc-acf-module-textarea input[type=tel], .lc-acf-module-textarea textarea, .lc-acf-module-textarea select',
					'affect_on_change_rule' => 'margin-left',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_res_t_inputs_margin_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'Inputs - Padding', 'lc-acf-integration' ),
				'id' => 'css_res_t_inputs_padding_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_res_t_inputs_padding_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=text], .lc-acf-module-textarea input[type=password], .lc-acf-module-textarea input[type=number], .lc-acf-module-textarea input[type=email], .lc-acf-module-textarea input[type=tel], .lc-acf-module-textarea textarea, .lc-acf-module-textarea select',
					'affect_on_change_rule' => 'padding-top',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_res_t_inputs_padding_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=text], .lc-acf-module-textarea input[type=password], .lc-acf-module-textarea input[type=number], .lc-acf-module-textarea input[type=email], .lc-acf-module-textarea input[type=tel], .lc-acf-module-textarea textarea, .lc-acf-module-textarea select',
					'affect_on_change_rule' => 'padding-right',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_res_t_inputs_padding_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=text], .lc-acf-module-textarea input[type=password], .lc-acf-module-textarea input[type=number], .lc-acf-module-textarea input[type=email], .lc-acf-module-textarea input[type=tel], .lc-acf-module-textarea textarea, .lc-acf-module-textarea select',
					'affect_on_change_rule' => 'padding-bottom',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_res_t_inputs_padding_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=text], .lc-acf-module-textarea input[type=password], .lc-acf-module-textarea input[type=number], .lc-acf-module-textarea input[type=email], .lc-acf-module-textarea input[type=tel], .lc-acf-module-textarea textarea, .lc-acf-module-textarea select',
					'affect_on_change_rule' => 'padding-left',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_res_t_inputs_padding_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'Blockquote - Text Align', 'lc-acf-integration' ),
				'id' => 'css_res_t_blockquote_text_align',
				'std' => 'left',
				'type' => 'text_align',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea blockquote',
				'affect_on_change_rule' => 'text-align',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'Blockquote - Font Size', 'lc-acf-integration' ),
				'id' => 'css_res_t_blockquote_font_size',
				'std' => '13',
				'type' => 'slider',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea blockquote',
				'affect_on_change_rule' => 'font-size',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
				'ext' => 'px',
			),
			array(
				'label' => __( 'Blockquote - Line Height', 'lc-acf-integration' ),
				'id' => 'css_res_t_blockquote_line_height',
				'std' => '22',
				'type' => 'slider',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea blockquote',
				'affect_on_change_rule' => 'line-height',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
				'ext' => 'px',
			),
			array(
				'label' => __( 'Blockquote - Margin', 'lc-acf-integration' ),
				'id' => 'css_res_t_blockquote_margin_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_res_t_blockquote_margin_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea blockquote',
					'affect_on_change_rule' => 'margin-top',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_res_t_blockquote_margin_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea blockquote',
					'affect_on_change_rule' => 'margin-right',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_res_t_blockquote_margin_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea blockquote',
					'affect_on_change_rule' => 'margin-bottom',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_res_t_blockquote_margin_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea blockquote',
					'affect_on_change_rule' => 'margin-left',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_res_t_blockquote_margin_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'Blockquote - Padding', 'lc-acf-integration' ),
				'id' => 'css_res_t_blockquote_padding_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_res_t_blockquote_padding_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea blockquote',
					'affect_on_change_rule' => 'padding-top',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_res_t_blockquote_padding_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea blockquote',
					'affect_on_change_rule' => 'padding-right',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_res_t_blockquote_padding_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea blockquote',
					'affect_on_change_rule' => 'padding-bottom',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_res_t_blockquote_padding_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea blockquote',
					'affect_on_change_rule' => 'padding-left',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_res_t_blockquote_padding_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'Buttons - Font Size', 'lc-acf-integration' ),
				'id' => 'css_res_t_button_font_size',
				'std' => '13',
				'type' => 'slider',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea input[type=submit], .lc-acf-module-textarea button',
				'affect_on_change_rule' => 'font-size',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
				'ext' => 'px',
			),
			array(
				'label' => __( 'Buttons - Line Height', 'lc-acf-integration' ),
				'id' => 'css_res_t_button_line_height',
				'std' => '22',
				'type' => 'slider',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea input[type=submit], .lc-acf-module-textarea button',
				'affect_on_change_rule' => 'line-height',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
				'ext' => 'px',
			),
			array(
				'label' => __( 'Buttons - Margin', 'lc-acf-integration' ),
				'id' => 'css_res_t_button_margin_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_res_t_button_margin_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=submit], .lc-acf-module-textarea button',
					'affect_on_change_rule' => 'margin-top',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_res_t_button_margin_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=submit], .lc-acf-module-textarea button',
					'affect_on_change_rule' => 'margin-right',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_res_t_button_margin_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=submit], .lc-acf-module-textarea button',
					'affect_on_change_rule' => 'margin-bottom',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_res_t_button_margin_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=submit], .lc-acf-module-textarea button',
					'affect_on_change_rule' => 'margin-left',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_res_t_button_margin_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'Buttons - Padding', 'lc-acf-integration' ),
				'id' => 'css_res_t_button_padding_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_res_t_button_padding_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=submit], .lc-acf-module-textarea button',
					'affect_on_change_rule' => 'padding-top',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_res_t_button_padding_right',
					'std' => '15',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=submit], .lc-acf-module-textarea button',
					'affect_on_change_rule' => 'padding-right',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_res_t_button_padding_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=submit], .lc-acf-module-textarea button',
					'affect_on_change_rule' => 'padding-bottom',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_res_t_button_padding_left',
					'std' => '15',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=submit], .lc-acf-module-textarea button',
					'affect_on_change_rule' => 'padding-left',
					'section' => 'responsive',
					'tab' => __( 'Tablet', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_res_t_button_padding_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'responsive',
				'tab' => __( 'Tablet', 'lc-acf-integration' ),
			),

			/**
			 * Responsive Phone
			 */

			array(
				'label' => __( 'Responsive Styling', 'lc-acf-integration' ),
				'id' => 'css_res_p',
				'std' => 'disabled',
				'type' => 'select',
				'choices' => array(
					array(
						'label' => __( 'Disabled', 'lc-acf-integration' ),
						'value' => 'disabled',
					),
					array(
						'label' => __( 'Enabled', 'lc-acf-integration' ),
						'value' => 'enabled',
					),
				),
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'Margin', 'lc-acf-integration' ),
				'id' => 'css_res_p_margin_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_res_p_margin_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea',
					'affect_on_change_rule' => 'margin-top',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_res_p_margin_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea',
					'affect_on_change_rule' => 'margin-right',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_res_p_margin_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea',
					'affect_on_change_rule' => 'margin-bottom',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_res_p_margin_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea',
					'affect_on_change_rule' => 'margin-left',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_res_p_margin_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'Padding', 'lc-acf-integration' ),
				'id' => 'css_res_p_padding_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_res_p_padding_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea',
					'affect_on_change_rule' => 'padding-top',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_res_p_padding_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea',
					'affect_on_change_rule' => 'padding-right',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_res_p_padding_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea',
					'affect_on_change_rule' => 'padding-bottom',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_res_p_padding_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea',
					'affect_on_change_rule' => 'padding-left',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_res_p_padding_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'Font Size', 'lc-acf-integration' ),
				'id' => 'css_res_p_content_font_size',
				'std' => '13',
				'type' => 'slider',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea, .lc-acf-module-textarea p',
				'affect_on_change_rule' => 'font-size',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
				'ext' => 'px',
			),
			array(
				'label' => __( 'Line Height', 'lc-acf-integration' ),
				'id' => 'css_res_p_content_line_height',
				'std' => '22',
				'type' => 'slider',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea, .lc-acf-module-textarea p',
				'affect_on_change_rule' => 'line-height',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
				'ext' => 'px',
			),
			array(
				'label' => __( 'Margin ( paragraph )', 'lc-acf-integration' ),
				'id' => 'css_res_p_content_margin_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_res_p_content_margin_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea p',
					'affect_on_change_rule' => 'margin-top',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_res_p_content_margin_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea p',
					'affect_on_change_rule' => 'margin-right',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_res_p_content_margin_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea p',
					'affect_on_change_rule' => 'margin-bottom',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_res_p_content_margin_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea p',
					'affect_on_change_rule' => 'margin-left',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_res_p_content_margin_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'Padding ( paragraph )', 'lc-acf-integration' ),
				'id' => 'css_res_p_content_padding_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_res_p_content_padding_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea p',
					'affect_on_change_rule' => 'padding-top',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_res_p_content_padding_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea p',
					'affect_on_change_rule' => 'padding-right',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_res_p_content_padding_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea p',
					'affect_on_change_rule' => 'padding-bottom',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_res_p_content_padding_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea p',
					'affect_on_change_rule' => 'padding-left',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_res_p_content_padding_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'H1 - Text Align', 'lc-acf-integration' ),
				'id' => 'css_res_p_h1_text_align',
				'std' => 'left',
				'type' => 'text_align',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea h1',
				'affect_on_change_rule' => 'text-align',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'H1 - Font Size', 'lc-acf-integration' ),
				'id' => 'css_res_p_h1_font_size',
				'std' => '13',
				'type' => 'slider',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea h1',
				'affect_on_change_rule' => 'font-size',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
				'ext' => 'px',
			),
			array(
				'label' => __( 'H1 - Line Height', 'lc-acf-integration' ),
				'id' => 'css_res_p_h1_line_height',
				'std' => '22',
				'type' => 'slider',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea h1',
				'affect_on_change_rule' => 'line-height',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
				'ext' => 'px',
			),
			array(
				'label' => __( 'H1 - Margin', 'lc-acf-integration' ),
				'id' => 'css_res_p_h1_margin_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_res_p_h1_margin_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h1',
					'affect_on_change_rule' => 'margin-top',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_res_p_h1_margin_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h1',
					'affect_on_change_rule' => 'margin-right',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_res_p_h1_margin_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h1',
					'affect_on_change_rule' => 'margin-bottom',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_res_p_h1_margin_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h1',
					'affect_on_change_rule' => 'margin-left',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_res_p_h1_margin_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'H1 - Padding', 'lc-acf-integration' ),
				'id' => 'css_res_p_h1_padding_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_res_p_h1_padding_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h1',
					'affect_on_change_rule' => 'padding-top',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_res_p_h1_padding_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h1',
					'affect_on_change_rule' => 'padding-right',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_res_p_h1_padding_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h1',
					'affect_on_change_rule' => 'padding-bottom',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_res_p_h1_padding_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h1',
					'affect_on_change_rule' => 'padding-left',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_res_p_h1_padding_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'H2 - Text Align', 'lc-acf-integration' ),
				'id' => 'css_res_p_h2_text_align',
				'std' => 'left',
				'type' => 'text_align',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea h2',
				'affect_on_change_rule' => 'text-align',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'H2 - Font Size', 'lc-acf-integration' ),
				'id' => 'css_res_p_h2_font_size',
				'std' => '13',
				'type' => 'slider',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea h2',
				'affect_on_change_rule' => 'font-size',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
				'ext' => 'px',
			),
			array(
				'label' => __( 'H2 - Line Height', 'lc-acf-integration' ),
				'id' => 'css_res_p_h2_line_height',
				'std' => '22',
				'type' => 'slider',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea h2',
				'affect_on_change_rule' => 'line-height',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
				'ext' => 'px',
			),
			array(
				'label' => __( 'H2 - Margin', 'lc-acf-integration' ),
				'id' => 'css_res_p_h2_margin_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_res_p_h2_margin_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h2',
					'affect_on_change_rule' => 'margin-top',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_res_p_h2_margin_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h2',
					'affect_on_change_rule' => 'margin-right',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_res_p_h2_margin_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h2',
					'affect_on_change_rule' => 'margin-bottom',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_res_p_h2_margin_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h2',
					'affect_on_change_rule' => 'margin-left',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_res_p_h2_margin_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'H2 - Padding', 'lc-acf-integration' ),
				'id' => 'css_res_p_h2_padding_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_res_p_h2_padding_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h2',
					'affect_on_change_rule' => 'padding-top',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_res_p_h2_padding_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h2',
					'affect_on_change_rule' => 'padding-right',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_res_p_h2_padding_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h2',
					'affect_on_change_rule' => 'padding-bottom',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_res_p_h2_padding_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h2',
					'affect_on_change_rule' => 'padding-left',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_res_p_h2_padding_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'H3 - Text Align', 'lc-acf-integration' ),
				'id' => 'css_res_p_h3_text_align',
				'std' => 'left',
				'type' => 'text_align',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea h3',
				'affect_on_change_rule' => 'text-align',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'H3 - Font Size', 'lc-acf-integration' ),
				'id' => 'css_res_p_h3_font_size',
				'std' => '13',
				'type' => 'slider',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea h3',
				'affect_on_change_rule' => 'font-size',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
				'ext' => 'px',
			),
			array(
				'label' => __( 'H3 - Line Height', 'lc-acf-integration' ),
				'id' => 'css_res_p_h3_line_height',
				'std' => '22',
				'type' => 'slider',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea h3',
				'affect_on_change_rule' => 'line-height',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
				'ext' => 'px',
			),
			array(
				'label' => __( 'H3 - Margin', 'lc-acf-integration' ),
				'id' => 'css_res_p_h3_margin_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_res_p_h3_margin_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h3',
					'affect_on_change_rule' => 'margin-top',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_res_p_h3_margin_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h3',
					'affect_on_change_rule' => 'margin-right',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_res_p_h3_margin_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h3',
					'affect_on_change_rule' => 'margin-bottom',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_res_p_h3_margin_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h3',
					'affect_on_change_rule' => 'margin-left',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_res_p_h3_margin_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'H3 - Padding', 'lc-acf-integration' ),
				'id' => 'css_res_p_h3_padding_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_res_p_h3_padding_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h3',
					'affect_on_change_rule' => 'padding-top',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_res_p_h3_padding_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h3',
					'affect_on_change_rule' => 'padding-right',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_res_p_h3_padding_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h3',
					'affect_on_change_rule' => 'padding-bottom',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_res_p_h3_padding_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h3',
					'affect_on_change_rule' => 'padding-left',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_res_p_h3_padding_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'H4 - Text Align', 'lc-acf-integration' ),
				'id' => 'css_res_p_h4_text_align',
				'std' => 'left',
				'type' => 'text_align',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea h4',
				'affect_on_change_rule' => 'text-align',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'H4 - Font Size', 'lc-acf-integration' ),
				'id' => 'css_res_p_h4_font_size',
				'std' => '13',
				'type' => 'slider',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea h4',
				'affect_on_change_rule' => 'font-size',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
				'ext' => 'px',
			),
			array(
				'label' => __( 'H4 - Line Height', 'lc-acf-integration' ),
				'id' => 'css_res_p_h4_line_height',
				'std' => '22',
				'type' => 'slider',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea h4',
				'affect_on_change_rule' => 'line-height',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
				'ext' => 'px',
			),
			array(
				'label' => __( 'H4 - Margin', 'lc-acf-integration' ),
				'id' => 'css_res_p_h4_margin_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_res_p_h4_margin_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h4',
					'affect_on_change_rule' => 'margin-top',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_res_p_h4_margin_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h4',
					'affect_on_change_rule' => 'margin-right',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_res_p_h4_margin_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h4',
					'affect_on_change_rule' => 'margin-bottom',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_res_p_h4_margin_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h4',
					'affect_on_change_rule' => 'margin-left',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_res_p_h4_margin_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'H4 - Padding', 'lc-acf-integration' ),
				'id' => 'css_res_p_h4_padding_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_res_p_h4_padding_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h4',
					'affect_on_change_rule' => 'padding-top',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_res_p_h4_padding_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h4',
					'affect_on_change_rule' => 'padding-right',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_res_p_h4_padding_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h4',
					'affect_on_change_rule' => 'padding-bottom',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_res_p_h4_padding_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h4',
					'affect_on_change_rule' => 'padding-left',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_res_p_h4_padding_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'H5 - Text Align', 'lc-acf-integration' ),
				'id' => 'css_res_p_h5_text_align',
				'std' => 'left',
				'type' => 'text_align',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea h5',
				'affect_on_change_rule' => 'text-align',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'H5 - Font Size', 'lc-acf-integration' ),
				'id' => 'css_res_p_h5_font_size',
				'std' => '13',
				'type' => 'slider',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea h5',
				'affect_on_change_rule' => 'font-size',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
				'ext' => 'px',
			),
			array(
				'label' => __( 'H5 - Line Height', 'lc-acf-integration' ),
				'id' => 'css_res_p_h5_line_height',
				'std' => '22',
				'type' => 'slider',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea h5',
				'affect_on_change_rule' => 'line-height',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
				'ext' => 'px',
			),
			array(
				'label' => __( 'H5 - Margin', 'lc-acf-integration' ),
				'id' => 'css_res_p_h5_margin_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_res_p_h5_margin_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h5',
					'affect_on_change_rule' => 'margin-top',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_res_p_h5_margin_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h5',
					'affect_on_change_rule' => 'margin-right',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_res_p_h5_margin_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h5',
					'affect_on_change_rule' => 'margin-bottom',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_res_p_h5_margin_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h5',
					'affect_on_change_rule' => 'margin-left',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_res_p_h5_margin_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'H5 - Padding', 'lc-acf-integration' ),
				'id' => 'css_res_p_h5_padding_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_res_p_h5_padding_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h5',
					'affect_on_change_rule' => 'padding-top',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_res_p_h5_padding_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h5',
					'affect_on_change_rule' => 'padding-right',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_res_p_h5_padding_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h5',
					'affect_on_change_rule' => 'padding-bottom',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_res_p_h5_padding_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h5',
					'affect_on_change_rule' => 'padding-left',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_res_p_h5_padding_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'H6 - Text Align', 'lc-acf-integration' ),
				'id' => 'css_res_p_h6_text_align',
				'std' => 'left',
				'type' => 'text_align',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea h6',
				'affect_on_change_rule' => 'text-align',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'H6 - Font Size', 'lc-acf-integration' ),
				'id' => 'css_res_p_h6_font_size',
				'std' => '13',
				'type' => 'slider',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea h6',
				'affect_on_change_rule' => 'font-size',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
				'ext' => 'px',
			),
			array(
				'label' => __( 'H6 - Line Height', 'lc-acf-integration' ),
				'id' => 'css_res_p_h6_line_height',
				'std' => '22',
				'type' => 'slider',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea h6',
				'affect_on_change_rule' => 'line-height',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
				'ext' => 'px',
			),
			array(
				'label' => __( 'H6 - Margin', 'lc-acf-integration' ),
				'id' => 'css_res_p_h6_margin_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_res_p_h6_margin_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h6',
					'affect_on_change_rule' => 'margin-top',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_res_p_h6_margin_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h6',
					'affect_on_change_rule' => 'margin-right',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_res_p_h6_margin_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h6',
					'affect_on_change_rule' => 'margin-bottom',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_res_p_h6_margin_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h6',
					'affect_on_change_rule' => 'margin-left',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_res_p_h6_margin_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'H6 - Padding', 'lc-acf-integration' ),
				'id' => 'css_res_p_h6_padding_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_res_p_h6_padding_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h6',
					'affect_on_change_rule' => 'padding-top',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_res_p_h6_padding_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h6',
					'affect_on_change_rule' => 'padding-right',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_res_p_h6_padding_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h6',
					'affect_on_change_rule' => 'padding-bottom',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_res_p_h6_padding_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea h6',
					'affect_on_change_rule' => 'padding-left',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_res_p_h6_padding_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'Lists - Font Size', 'lc-acf-integration' ),
				'id' => 'css_res_p_lists_font_size',
				'std' => '13',
				'type' => 'slider',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea li',
				'affect_on_change_rule' => 'font-size',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
				'ext' => 'px',
			),
			array(
				'label' => __( 'Lists - Line Height', 'lc-acf-integration' ),
				'id' => 'css_res_p_lists_line_height',
				'std' => '22',
				'type' => 'slider',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea li',
				'affect_on_change_rule' => 'line-height',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
				'ext' => 'px',
			),
			array(
				'label' => __( 'Lists - Margin', 'lc-acf-integration' ),
				'id' => 'css_res_p_lists_margin_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_res_p_lists_margin_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea ul,.lc-acf-module-textarea ol',
					'affect_on_change_rule' => 'margin-top',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_res_p_lists_margin_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea ul,.lc-acf-module-textarea ol',
					'affect_on_change_rule' => 'margin-right',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_res_p_lists_margin_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea ul,.lc-acf-module-textarea ol',
					'affect_on_change_rule' => 'margin-bottom',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_res_p_lists_margin_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea ul,.lc-acf-module-textarea ol',
					'affect_on_change_rule' => 'margin-left',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_res_p_lists_margin_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'Lists - Spacing', 'lc-acf-integration' ),
				'id' => 'css_res_p_lists_spacing_margin_bottom',
				'std' => '10',
				'type' => 'slider',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea li',
				'affect_on_change_rule' => 'margin-bottom',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
				'ext' => 'px',
			),
			array(
				'label' => __( 'Lists Item - Padding', 'lc-acf-integration' ),
				'id' => 'css_res_p_item_padding_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_res_p_item_padding_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea li',
					'affect_on_change_rule' => 'padding-top',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_res_p_item_padding_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea li',
					'affect_on_change_rule' => 'padding-right',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_res_p_item_padding_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea li',
					'affect_on_change_rule' => 'padding-bottom',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_res_p_item_padding_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea li',
					'affect_on_change_rule' => 'padding-left',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_res_p_item_padding_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'Inputs - Font Size', 'lc-acf-integration' ),
				'id' => 'css_res_p_inputs_font_size',
				'std' => '13',
				'type' => 'slider',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea input[type=text], .lc-acf-module-textarea input[type=password], .lc-acf-module-textarea input[type=number], .lc-acf-module-textarea input[type=email], .lc-acf-module-textarea input[type=tel], .lc-acf-module-textarea textarea, .lc-acf-module-textarea select',
				'affect_on_change_rule' => 'font-size',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
				'ext' => 'px',
			),
			array(
				'label' => __( 'Inputs - Line Height', 'lc-acf-integration' ),
				'id' => 'css_res_p_inputs_line_height',
				'std' => '22',
				'type' => 'slider',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea input[type=text], .lc-acf-module-textarea input[type=password], .lc-acf-module-textarea input[type=number], .lc-acf-module-textarea input[type=email], .lc-acf-module-textarea input[type=tel], .lc-acf-module-textarea textarea, .lc-acf-module-textarea select',
				'affect_on_change_rule' => 'line-height',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
				'ext' => 'px',
			),
			array(
				'label' => __( 'Inputs - Margin', 'lc-acf-integration' ),
				'id' => 'css_res_p_inputs_margin_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_res_p_inputs_margin_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=text], .lc-acf-module-textarea input[type=password], .lc-acf-module-textarea input[type=number], .lc-acf-module-textarea input[type=email], .lc-acf-module-textarea input[type=tel], .lc-acf-module-textarea textarea, .lc-acf-module-textarea select',
					'affect_on_change_rule' => 'margin-top',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_res_p_inputs_margin_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=text], .lc-acf-module-textarea input[type=password], .lc-acf-module-textarea input[type=number], .lc-acf-module-textarea input[type=email], .lc-acf-module-textarea input[type=tel], .lc-acf-module-textarea textarea, .lc-acf-module-textarea select',
					'affect_on_change_rule' => 'margin-right',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_res_p_inputs_margin_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=text], .lc-acf-module-textarea input[type=password], .lc-acf-module-textarea input[type=number], .lc-acf-module-textarea input[type=email], .lc-acf-module-textarea input[type=tel], .lc-acf-module-textarea textarea, .lc-acf-module-textarea select',
					'affect_on_change_rule' => 'margin-bottom',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_res_p_inputs_margin_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=text], .lc-acf-module-textarea input[type=password], .lc-acf-module-textarea input[type=number], .lc-acf-module-textarea input[type=email], .lc-acf-module-textarea input[type=tel], .lc-acf-module-textarea textarea, .lc-acf-module-textarea select',
					'affect_on_change_rule' => 'margin-left',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_res_p_inputs_margin_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'Inputs - Padding', 'lc-acf-integration' ),
				'id' => 'css_res_p_inputs_padding_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_res_p_inputs_padding_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=text], .lc-acf-module-textarea input[type=password], .lc-acf-module-textarea input[type=number], .lc-acf-module-textarea input[type=email], .lc-acf-module-textarea input[type=tel], .lc-acf-module-textarea textarea, .lc-acf-module-textarea select',
					'affect_on_change_rule' => 'padding-top',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_res_p_inputs_padding_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=text], .lc-acf-module-textarea input[type=password], .lc-acf-module-textarea input[type=number], .lc-acf-module-textarea input[type=email], .lc-acf-module-textarea input[type=tel], .lc-acf-module-textarea textarea, .lc-acf-module-textarea select',
					'affect_on_change_rule' => 'padding-right',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_res_p_inputs_padding_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=text], .lc-acf-module-textarea input[type=password], .lc-acf-module-textarea input[type=number], .lc-acf-module-textarea input[type=email], .lc-acf-module-textarea input[type=tel], .lc-acf-module-textarea textarea, .lc-acf-module-textarea select',
					'affect_on_change_rule' => 'padding-bottom',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_res_p_inputs_padding_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=text], .lc-acf-module-textarea input[type=password], .lc-acf-module-textarea input[type=number], .lc-acf-module-textarea input[type=email], .lc-acf-module-textarea input[type=tel], .lc-acf-module-textarea textarea, .lc-acf-module-textarea select',
					'affect_on_change_rule' => 'padding-left',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_res_p_inputs_padding_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'Blockquote - Text Align', 'lc-acf-integration' ),
				'id' => 'css_res_p_blockquote_text_align',
				'std' => 'left',
				'type' => 'text_align',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea blockquote',
				'affect_on_change_rule' => 'text-align',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'Blockquote - Font Size', 'lc-acf-integration' ),
				'id' => 'css_res_p_blockquote_font_size',
				'std' => '13',
				'type' => 'slider',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea blockquote',
				'affect_on_change_rule' => 'font-size',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
				'ext' => 'px',
			),
			array(
				'label' => __( 'Blockquote - Line Height', 'lc-acf-integration' ),
				'id' => 'css_res_p_blockquote_line_height',
				'std' => '22',
				'type' => 'slider',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea blockquote',
				'affect_on_change_rule' => 'line-height',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
				'ext' => 'px',
			),
			array(
				'label' => __( 'Blockquote - Margin', 'lc-acf-integration' ),
				'id' => 'css_res_p_blockquote_margin_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_res_p_blockquote_margin_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea blockquote',
					'affect_on_change_rule' => 'margin-top',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_res_p_blockquote_margin_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea blockquote',
					'affect_on_change_rule' => 'margin-right',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_res_p_blockquote_margin_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea blockquote',
					'affect_on_change_rule' => 'margin-bottom',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_res_p_blockquote_margin_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea blockquote',
					'affect_on_change_rule' => 'margin-left',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_res_p_blockquote_margin_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'Blockquote - Padding', 'lc-acf-integration' ),
				'id' => 'css_res_p_blockquote_padding_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_res_p_blockquote_padding_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea blockquote',
					'affect_on_change_rule' => 'padding-top',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_res_p_blockquote_padding_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea blockquote',
					'affect_on_change_rule' => 'padding-right',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_res_p_blockquote_padding_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea blockquote',
					'affect_on_change_rule' => 'padding-bottom',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_res_p_blockquote_padding_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea blockquote',
					'affect_on_change_rule' => 'padding-left',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_res_p_blockquote_padding_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'Buttons - Font Size', 'lc-acf-integration' ),
				'id' => 'css_res_p_button_font_size',
				'std' => '13',
				'type' => 'slider',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea input[type=submit], .lc-acf-module-textarea button',
				'affect_on_change_rule' => 'font-size',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
				'ext' => 'px',
			),
			array(
				'label' => __( 'Buttons - Line Height', 'lc-acf-integration' ),
				'id' => 'css_res_p_button_line_height',
				'std' => '22',
				'type' => 'slider',
				'refresh_on_change' => false,
				'affect_on_change_el' => '.lc-acf-module-textarea input[type=submit], .lc-acf-module-textarea button',
				'affect_on_change_rule' => 'line-height',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
				'ext' => 'px',
			),
			array(
				'label' => __( 'Buttons - Margin', 'lc-acf-integration' ),
				'id' => 'css_res_p_button_margin_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_res_p_button_margin_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=submit], .lc-acf-module-textarea button',
					'affect_on_change_rule' => 'margin-top',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_res_p_button_margin_right',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=submit], .lc-acf-module-textarea button',
					'affect_on_change_rule' => 'margin-right',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_res_p_button_margin_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=submit], .lc-acf-module-textarea button',
					'affect_on_change_rule' => 'margin-bottom',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_res_p_button_margin_left',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=submit], .lc-acf-module-textarea button',
					'affect_on_change_rule' => 'margin-left',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_res_p_button_margin_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
			array(
				'label' => __( 'Buttons - Padding', 'lc-acf-integration' ),
				'id' => 'css_res_p_button_padding_group',
				'type' => 'group',
				'action' => 'open',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),
				array(
					'label' => __( 'Top', 'lc-acf-integration' ),
					'id' => 'css_res_p_button_padding_top',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=submit], .lc-acf-module-textarea button',
					'affect_on_change_rule' => 'padding-top',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Right', 'lc-acf-integration' ),
					'id' => 'css_res_p_button_padding_right',
					'std' => '15',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=submit], .lc-acf-module-textarea button',
					'affect_on_change_rule' => 'padding-right',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Bottom', 'lc-acf-integration' ),
					'id' => 'css_res_p_button_padding_bottom',
					'std' => '0',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=submit], .lc-acf-module-textarea button',
					'affect_on_change_rule' => 'padding-bottom',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
				array(
					'label' => __( 'Left', 'lc-acf-integration' ),
					'id' => 'css_res_p_button_padding_left',
					'std' => '15',
					'type' => 'slider',
					'refresh_on_change' => false,
					'affect_on_change_el' => '.lc-acf-module-textarea input[type=submit], .lc-acf-module-textarea button',
					'affect_on_change_rule' => 'padding-left',
					'section' => 'responsive',
					'tab' => __( 'Phone', 'lc-acf-integration' ),
					'ext' => 'px',
				),
			array(
				'id' => 'css_res_p_button_padding_group',
				'type' => 'group',
				'action' => 'close',
				'section' => 'responsive',
				'tab' => __( 'Phone', 'lc-acf-integration' ),
			),

		);

		$dslc_options = array_merge( $dslc_options, $this->shared_options( 'animation_options', array( 'hover_opts' => false ) ) );
		$dslc_options = array_merge( $dslc_options, $this->presets_options() );

		return apply_filters( 'dslc_module_options', $dslc_options, $this->module_id );

	}

	/**
	 * Module HTML output.
	 *
	 * @param  array $options Module options to fill the module template.
	 * @return void
	 */
	function output( $options ) {

		global $dslc_active;

		if ( $dslc_active && is_user_logged_in() && current_user_can( DS_LIVE_COMPOSER_CAPABILITY ) ) {
			$dslc_is_admin = true;
		} else {
			$dslc_is_admin = false;
		}

		$this->module_start( $options );
		/* Module output starts here */
		?>

		<div class="lc-acf-module-textarea">
		<?php

		if ( isset( $_POST['dslc_url_vars'] ) ) {

			if ( isset( $_POST['dslc_url_vars']['preview_id'] ) ) {
				$preview_id = $_POST['dslc_url_vars']['preview_id'];
			} else {
				$preview_id = '';
			}
		} elseif ( isset( $_GET['preview_id'] ) ) {

			$preview_id = $_GET['preview_id'];
		} else {

			$preview_id = '';
		}

		$module_id = $this->module_id;
		$post_id = $options['post_id'];
		$field = $options['select_field'];

		$lcacf_array_real_data = array(
			'module_id' => $module_id,
			'post_id' => $post_id,
			'preview_id' => $preview_id,
			'field' => $field,
			'dslc_is_admin' => $dslc_is_admin,
		);

		$lcacf_array_default_data = array(
			'module_id' => $module_id,
			'field' => $field,
			'dslc_is_admin' => $dslc_is_admin,
		);

		if ( ! $dslc_active ) {

			if ( 'dslc_templates' !== get_post_type( get_the_ID() ) ) {
				lcacf_display_real_data( $lcacf_array_real_data );
			} else {
				if ( is_user_logged_in() && current_user_can( DS_LIVE_COMPOSER_CAPABILITY ) ) {
					lcacf_display_default_data( $lcacf_array_default_data );
				}
			}
		} elseif ( $dslc_active ) {

			if ( 'dslc_templates' !== get_post_type( $post_id ) ) {
				lcacf_display_real_data( $lcacf_array_real_data );
			} elseif ( ! empty( $preview_id ) ) {
				lcacf_display_real_data( $lcacf_array_real_data );
			} else {
				lcacf_display_default_data( $lcacf_array_default_data );
			}
		}

		?>
		</div>

		<?php
		/* Module output ends here */
		$this->module_end( $options );
	}
}

/**
 * Register Module
 */
add_action( 'dslc_hook_register_modules', 'lcacf_init_textarea' );

function lcacf_init_textarea() {
    return dslc_register_module( 'ACF_Textarea' );
}
